/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kelude.aps.opensearch.annotations;

import com.taobao.kelude.aps.opensearch.OpenSearchException;
import com.taobao.kelude.aps.opensearch.annotations.FieldPlugin;
import com.taobao.kelude.aps.opensearch.annotations.SearchEntity;
import com.taobao.kelude.aps.opensearch.annotations.SearchEntityMeta;
import com.taobao.kelude.aps.opensearch.annotations.SearchFieldMeta;
import com.taobao.kelude.aps.opensearch.annotations.SearchMapping;
import com.taobao.kelude.aps.opensearch.plugins.SearchFieldPlugin;
import com.taobao.kelude.aps.utils.ReflectUtils;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class SearchMetaFactory {
    public static SearchMetaFactory INSTANCE = new SearchMetaFactory();
    private static Map<Class<?>, SearchEntityMeta> classMap = new ConcurrentHashMap();
    private static Map<String, SearchEntityMeta> tableMap = new ConcurrentHashMap<String, SearchEntityMeta>();
    private static Object mutex = new Object();

    private SearchMetaFactory() {
    }

    public SearchEntityMeta get(Class<?> targetClass) {
        return classMap.get(targetClass);
    }

    public SearchEntityMeta get(String tableName) {
        return tableMap.get(tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchEntityMeta register(Class<?> targetClass) {
        SearchEntityMeta meta = classMap.get(targetClass);
        if (meta == null) {
            Object object = mutex;
            synchronized (object) {
                meta = classMap.get(targetClass);
                if (meta == null) {
                    meta = new SearchEntityMeta();
                    this.parseClassAnnotation(targetClass, meta);
                    this.registerMeta(meta);
                }
            }
        }
        return meta;
    }

    private void registerMeta(SearchEntityMeta meta) {
        classMap.put(meta.getTargetClass(), meta);
        tableMap.put(meta.getTableName(), meta);
    }

    private boolean parseClassAnnotation(Class<?> targetClass, SearchEntityMeta meta) {
        SearchEntity entity = targetClass.getAnnotation(SearchEntity.class);
        if (entity != null) {
            meta.setTableName(entity.value());
            meta.setTargetClass(targetClass);
            this.parseFieldsAnnotation(targetClass, meta);
            return true;
        }
        return false;
    }

    private void parseFieldsAnnotation(Class<?> targetClass, SearchEntityMeta meta) {
        List<Field> list = ReflectUtils.getDeepFields(targetClass);
        for (Field field : list) {
            SearchFieldMeta.SearchFieldType fieldType;
            SearchMapping mapping = field.getAnnotation(SearchMapping.class);
            if (mapping == null) continue;
            String name = mapping.value();
            if ("".equals(name.trim())) {
                name = field.getName();
            }
            if ((fieldType = mapping.fieldType()) == SearchFieldMeta.SearchFieldType.RELATE) {
                SearchEntityMeta relateMeta = new SearchEntityMeta();
                if (!this.parseClassAnnotation(field.getType(), relateMeta)) continue;
                meta.getRelateFieldMap().put(field, relateMeta);
                this.registerMeta(relateMeta);
                continue;
            }
            SearchFieldMeta fieldMeta = new SearchFieldMeta();
            fieldMeta.setField(field);
            fieldMeta.setFieldType(fieldType);
            fieldMeta.setArrayIndexType(mapping.arrayIndexType());
            fieldMeta.setColumnName(name);
            fieldMeta.setAllowNull(mapping.allowNull());
            fieldMeta.setReadable(mapping.readable());
            fieldMeta.setWriteable(mapping.writeable());
            fieldMeta.setPrimaryKey(mapping.primaryKey());
            fieldMeta.setUrlEncode(mapping.urlEncode());
            fieldMeta.setAllowMapping(mapping.allowMapping());
            fieldMeta.parseType(field);
            this.parseFieldPluginAnnotation(field, fieldMeta);
            meta.getFieldsMap().put(name, fieldMeta);
            if (!fieldMeta.primaryKey) continue;
            meta.setPrimaryField(fieldMeta);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseFieldPluginAnnotation(Field field, SearchFieldMeta fieldMeta) {
        FieldPlugin fieldPlugin = field.getAnnotation(FieldPlugin.class);
        if (fieldPlugin == null) return;
        Class<? extends SearchFieldPlugin> pluginClass = fieldPlugin.value();
        if (pluginClass == null) throw new OpenSearchException("Invalid field plugin arguments of field " + field);
        SearchFieldPlugin plugin = ReflectUtils.newInstance(pluginClass);
        if (plugin == null) throw new OpenSearchException("Fail to instance field plugin " + pluginClass + " of field " + field);
        fieldMeta.setPluginClass(pluginClass);
        fieldMeta.setFieldPlugin(plugin);
        fieldMeta.setPluginParams(fieldPlugin.params());
        plugin.setup(fieldMeta);
    }
}

