/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kelude.aps.opensearch.plugins;

import com.taobao.kelude.aps.opensearch.CustomFieldEntry;
import com.taobao.kelude.aps.opensearch.CustomFieldSearchFactory;
import com.taobao.kelude.aps.opensearch.OpenSearchException;
import com.taobao.kelude.aps.opensearch.annotations.SearchFieldMeta;
import com.taobao.kelude.aps.opensearch.plugins.SearchFieldPlugin;
import com.taobao.kelude.aps.utils.DateUtils;
import com.taobao.kelude.aps.utils.ReflectUtils;
import com.taobao.kelude.aps.utils.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchCfsFieldPlugin
implements SearchFieldPlugin {
    private static final Logger log = LoggerFactory.getLogger(SearchCfsFieldPlugin.class);
    private static final String FIELD_SEPARATOR = "\t";
    private static final String VALUE_SEPARATOR = ":";

    @Override
    public void setup(SearchFieldMeta fieldMeta) {
    }

    @Override
    public Object read(SearchFieldMeta fieldMeta, JsonNode node) {
        String value = node.asText();
        if (value == null || "".equals(value.trim())) {
            return null;
        }
        String[] params = value.split(FIELD_SEPARATOR);
        HashMap<String, String> map = new HashMap<String, String>();
        for (String param : params) {
            String[] vals = param.split(VALUE_SEPARATOR);
            if (vals.length != 2) {
                log.error("Search cfs invalid values " + param + " of " + value);
                continue;
            }
            String attrId = vals[0];
            String attrValue = vals[1];
            attrValue = SearchCfsFieldPlugin.transformCfs(attrValue);
            String oldValue = (String)map.get(attrId);
            if (oldValue == null) {
                map.put(attrId, attrValue);
                continue;
            }
            String sep = ",";
            CustomFieldEntry cfEntry = CustomFieldSearchFactory.getEntry(Integer.parseInt(attrId));
            if (cfEntry != null && cfEntry.isArray()) {
                sep = cfEntry.getMultiValSeparator();
            }
            map.put(attrId, StringUtils.bufferString(oldValue, sep, attrValue));
        }
        return map;
    }

    @Override
    public Object write(SearchFieldMeta fieldMeta, Object fieldValue, Map<String, Object> externResult) {
        Map map = (Map)fieldValue;
        if (map == null || map.isEmpty()) {
            return null;
        }
        ArrayList<String> cfsList = new ArrayList<String>(map.size() + 8);
        for (Map.Entry entry : map.entrySet()) {
            String attrValue = (String)entry.getValue();
            CustomFieldEntry cfEntry = CustomFieldSearchFactory.getEntry(Integer.parseInt((String)entry.getKey()));
            if (cfEntry != null) {
                if (cfEntry.getFieldName() != null) {
                    Object value = this.parseFieldValue(cfEntry, attrValue);
                    if (value != null) {
                        externResult.put(cfEntry.getFieldName(), value);
                    }
                } else if (cfEntry.isArray()) {
                    String[] params;
                    for (String param : params = attrValue.split(cfEntry.getMultiValSeparator())) {
                        if ("".equals(param.trim())) continue;
                        cfsList.add(StringUtils.bufferString(entry.getKey(), VALUE_SEPARATOR, param));
                    }
                    continue;
                }
            }
            cfsList.add(StringUtils.bufferString(entry.getKey(), VALUE_SEPARATOR, attrValue));
        }
        return cfsList.toArray(new String[0]);
    }

    private Object parseFieldValue(CustomFieldEntry cfEntry, String attrValue) {
        try {
            if (cfEntry.getFieldType() == CustomFieldEntry.CustomFieldType.INT) {
                return Long.parseLong(attrValue);
            }
            if (cfEntry.getFieldType() == CustomFieldEntry.CustomFieldType.FLOAT) {
                return Float.valueOf(Float.parseFloat(attrValue));
            }
            if (cfEntry.getFieldType() == CustomFieldEntry.CustomFieldType.DOUBLE) {
                return Double.parseDouble(attrValue);
            }
            if (cfEntry.getFieldType() == CustomFieldEntry.CustomFieldType.STRING) {
                return attrValue;
            }
            if (cfEntry.getFieldType() == CustomFieldEntry.CustomFieldType.INT_ARRAY) {
                String[] params = attrValue.split(cfEntry.getMultiValSeparator());
                return ReflectUtils.convertLongArray(params);
            }
            if (cfEntry.getFieldType() == CustomFieldEntry.CustomFieldType.FLOAT_ARRAY) {
                String[] params = attrValue.split(cfEntry.getMultiValSeparator());
                return ReflectUtils.convertFloatArray(params);
            }
            if (cfEntry.getFieldType() == CustomFieldEntry.CustomFieldType.DOUBLE_ARRAY) {
                String[] params = attrValue.split(cfEntry.getMultiValSeparator());
                return ReflectUtils.convertDoubleArray(params);
            }
            if (cfEntry.getFieldType() == CustomFieldEntry.CustomFieldType.STRING_ARRAY) {
                String[] params = attrValue.split(cfEntry.getMultiValSeparator());
                return params;
            }
            if (cfEntry.getFieldType() == CustomFieldEntry.CustomFieldType.DATE) {
                Date date = DateUtils.integerTimeToDate(attrValue);
                return date == null ? null : Long.valueOf(date.getTime());
            }
            throw new OpenSearchException("Not support custom field type " + (Object)((Object)cfEntry.getFieldType()));
        }
        catch (Exception e) {
            throw new OpenSearchException("Fail to parse attr value. Cause " + e.getMessage(), e);
        }
    }

    private static String transformCfs(String text) {
        try {
            if (text == null) {
                return null;
            }
            text = text.replaceAll("%3a", VALUE_SEPARATOR).replaceAll("%3b", ";");
            return text;
        }
        catch (Exception e) {
            log.error("decode method id SearchCfsFieldPlugin:" + e.getMessage(), (Throwable)e);
            return text;
        }
    }
}

