/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kelude.aps.sentiment;

import com.taobao.kelude.aps.sentiment.SentimentAnalysis;
import com.taobao.kelude.aps.sentiment.SentimentBean;

public class EmotionStatistic {
    private static final float OFFSET_VAL = 0.001f;
    int totalScore;
    int totalCount;
    float midOffset;
    int posCount = 0;
    int midCount = 0;
    int negCount = 0;

    public EmotionStatistic() {
    }

    public EmotionStatistic(int totalScore, int totalCount, float midOffset, int posCount, int midCount, int negCount) {
        this.totalScore = totalScore;
        this.totalCount = totalCount;
        this.midOffset = midOffset;
        this.posCount = posCount;
        this.midCount = midCount;
        this.negCount = negCount;
    }

    public void updateBean(SentimentBean bean) {
        int emotionScore = bean.getClassify();
        if (emotionScore != 0) {
            int val = emotionScore * SentimentAnalysis.KernelFunc.kernel(bean.getCount());
            this.totalScore += val;
            this.totalCount += Math.abs(val);
            if (val > 0) {
                ++this.posCount;
            } else {
                ++this.negCount;
            }
        } else {
            this.midOffset += 0.001f;
            ++this.midCount;
        }
    }

    public int getTotalScore() {
        return this.totalScore;
    }

    public void setTotalScore(int totalScore) {
        this.totalScore = totalScore;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    public float getMidOffset() {
        return this.midOffset;
    }

    public void setMidOffset(float midOffset) {
        this.midOffset = midOffset;
    }

    public int getPosCount() {
        return this.posCount;
    }

    public void setPosCount(int posCount) {
        this.posCount = posCount;
    }

    public int getMidCount() {
        return this.midCount;
    }

    public void setMidCount(int midCount) {
        this.midCount = midCount;
    }

    public int getNegCount() {
        return this.negCount;
    }

    public void setNegCount(int negCount) {
        this.negCount = negCount;
    }

    public String toString() {
        return "EmotionStatistic [totalScore=" + this.totalScore + ", totalCount=" + this.totalCount + ", midOffset=" + this.midOffset + ", posCount=" + this.posCount + ", midCount=" + this.midCount + ", negCount=" + this.negCount + "]";
    }
}

