/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kelude.aps.sentiment;

import com.taobao.kelude.aps.helper.EnvHelper;
import com.taobao.kelude.aps.sentiment.EmotionStatistic;
import com.taobao.kelude.aps.sentiment.SentimentBean;
import com.taobao.kelude.aps.sentiment.SentimentException;
import com.taobao.kelude.aps.sentiment.SentimentService;
import com.taobao.kelude.aps.sentiment.SentimentThread;
import com.taobao.kelude.aps.sentiment.WeiboFilter;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentimentAnalysis {
    private static Logger log = LoggerFactory.getLogger(SentimentAnalysis.class);
    private static final int MAX_WAIT_TIME = 10000;
    private static final float OFFSET_MAX = 0.05f;
    private static final int MAX_SCORE = 100;
    private static int[] SCOPE = new int[]{1, 5, 10, 15, 20, 25, 30};
    private static int MAX_SCOPE = SCOPE[SCOPE.length - 1];
    private int maxFlush = 50;
    private ExecutorService threadPool;
    SentimentService sentimentService;
    List<SentimentBean> cache = new LinkedList<SentimentBean>();
    List<Future<EmotionStatistic>> futures = new LinkedList<Future<EmotionStatistic>>();
    EmotionStatistic midStaticticBean = new EmotionStatistic();
    int totalScore;
    int totalCount;
    float midOffset;
    int posCount = 0;
    int midCount = 0;
    int negCount = 0;

    public SentimentAnalysis(SentimentService sentimentService) {
        this(sentimentService, 10);
    }

    public SentimentAnalysis(SentimentService sentimentService, int threadCount) {
        this.sentimentService = sentimentService;
        if (EnvHelper.getEnvType() == EnvHelper.EnvType.PROD) {
            this.threadPool = Executors.newFixedThreadPool(threadCount);
            this.maxFlush = 50;
        } else {
            this.threadPool = Executors.newFixedThreadPool(2);
            this.maxFlush = 30;
        }
    }

    public SentimentAnalysis(SentimentService sentimentService, ExecutorService threadPool) {
        this.sentimentService = sentimentService;
        this.threadPool = threadPool;
        this.maxFlush = EnvHelper.getEnvType() == EnvHelper.EnvType.PROD ? 50 : 30;
    }

    public void update(String userId, String content, int number) throws SentimentException {
        try {
            content = WeiboFilter.filterComment(content);
            SentimentBean bean = new SentimentBean(content, number);
            if ("".equals(content)) {
                bean.setClassify(0);
                this.midStaticticBean.updateBean(bean);
            } else {
                this.cache.add(bean);
            }
            if (this.cache.size() >= this.maxFlush) {
                this.flushEmotion();
            }
        }
        catch (Exception e) {
            throw new SentimentException("Fail to update sentiment score. Cause " + e.getMessage(), e);
        }
    }

    private void flushEmotion() throws SentimentException {
        LinkedList<SentimentBean> data = new LinkedList<SentimentBean>();
        int len = this.cache.size();
        for (int i = 0; i < len; ++i) {
            data.add(this.cache.get(i));
        }
        this.cache.clear();
        if (this.sentimentService != null) {
            SentimentThread thread = new SentimentThread(this.sentimentService, data);
            Future<EmotionStatistic> future = this.threadPool.submit(thread);
            this.futures.add(future);
        }
    }

    public int doFinal() throws SentimentException {
        this.flushEmotion();
        this.doStatistic();
        if (Float.compare(this.midOffset, 0.05f) > 0) {
            this.midOffset = 0.05f;
        }
        float per = 0.0f;
        if (this.totalCount != 0) {
            per = (float)this.totalScore / (float)this.totalCount;
        }
        if (this.totalScore > 0) {
            per -= this.midOffset;
        } else if (this.totalScore < 0) {
            per += this.midOffset;
        }
        log.debug("pos:" + this.posCount + " neg:" + this.negCount + " mid:" + this.midCount + " midoff:" + this.midOffset + " per:" + per);
        return (int)(per * 100.0f);
    }

    private void doStatistic() {
        for (Future<EmotionStatistic> future : this.futures) {
            try {
                EmotionStatistic statistic = future.get(10000L, TimeUnit.MILLISECONDS);
                this.midOffset += statistic.getMidOffset();
                this.totalScore += statistic.getTotalScore();
                this.totalCount += statistic.getTotalCount();
                this.posCount += statistic.getPosCount();
                this.midCount += statistic.getMidCount();
                this.negCount += statistic.getNegCount();
            }
            catch (Exception e) {
                log.error("Fail to wait emotion score data. Cause " + e.getMessage(), (Throwable)e);
            }
        }
        this.midOffset += this.midStaticticBean.getMidOffset();
        this.totalScore += this.midStaticticBean.getTotalScore();
        this.totalCount += this.midStaticticBean.getTotalCount();
        this.posCount += this.midStaticticBean.getPosCount();
        this.midCount += this.midStaticticBean.getMidCount();
        this.negCount += this.midStaticticBean.getNegCount();
    }

    public int getPosCount() {
        return this.posCount;
    }

    public int getMidCount() {
        return this.midCount;
    }

    public int getNegCount() {
        return this.negCount;
    }

    public int getTotalScore() {
        return this.totalScore;
    }

    public void setTotalScore(int totalScore) {
        this.totalScore = totalScore;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    static class KernelFunc {
        KernelFunc() {
        }

        public static int kernel(int n) {
            if (n < MAX_SCOPE) {
                int ret = n;
                for (int v : SCOPE) {
                    if (n > v) continue;
                    ret = v;
                    break;
                }
                return ret;
            }
            return (int)(Math.log(n) * 10.0);
        }
    }
}

