/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kelude.aps.sentiment;

public class WeiboFilter {
    private static final char CHAR_AT_USER = '@';
    private static final String SINGLE_CHARS = "!?.~\uff01\uff1f\u3002\uff5e";
    private static String[] stopWords = new String[]{"\u56de\u590d", "\u54c8", "\u5475\u5475", "\u563f\u563f", "\u8f6c\u53d1\u5fae\u535a", "\u8f6c\u53d1", "\u8f6c\u5566", "[]"};
    private static char[] nameTailChars = new char[]{' ', ',', ':', '\u3002', '\uff0c', '\uff1a', '\t', '\n'};

    public static String filterComment(String comment) {
        for (String stopWord : stopWords) {
            comment = comment.replace(stopWord, "");
        }
        StringBuilder buf = new StringBuilder();
        boolean isName = false;
        int len = comment.length();
        int index = 0;
        while (index < len) {
            char ch = comment.charAt(index++);
            if (!isName) {
                if (ch == '@') {
                    isName = true;
                    continue;
                }
                int bufLen = buf.length();
                if (bufLen > 0) {
                    char ch1 = buf.charAt(bufLen - 1);
                    if (ch == ch1 && (ch != ch1 || SINGLE_CHARS.indexOf(ch) >= 0)) continue;
                    buf.append(ch);
                    continue;
                }
                buf.append(ch);
                continue;
            }
            for (char tailCh : nameTailChars) {
                if (ch != tailCh) continue;
                isName = false;
            }
        }
        String result = buf.toString().trim();
        if (result.length() == 1 && SINGLE_CHARS.indexOf(result) > 0) {
            result = "";
        }
        return result;
    }
}

