/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kelude.aps.utils;

import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AESUtils {
    public static final String KEY_ALGORITHM = "AES";
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final Logger logger = Logger.getLogger(AESUtils.class);
    public static final String CIPHER_ALGORITHM = "AES/ECB/PKCS5Padding";

    public static String generateSHAValue(String srcData) {
        if (StringUtils.isEmpty((String)srcData)) {
            return null;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            messageDigest.update(srcData.getBytes());
            byte[] encryptedData = messageDigest.digest();
            if (null == encryptedData || encryptedData.length == 0) {
                return null;
            }
            StringBuilder buf = new StringBuilder(encryptedData.length * 2);
            for (byte bData : encryptedData) {
                buf.append(HEX_DIGITS[bData >> 4 & 0xF]);
                buf.append(HEX_DIGITS[bData & 0xF]);
            }
            return buf.toString();
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String initkey() throws Exception {
        KeyGenerator kg = KeyGenerator.getInstance(KEY_ALGORITHM);
        kg.init(128);
        SecretKey secretKey = kg.generateKey();
        return Base64.encodeBase64String((byte[])secretKey.getEncoded());
    }

    public static Key toKey(byte[] key) throws Exception {
        return new SecretKeySpec(key, KEY_ALGORITHM);
    }

    public static String encrypt(String data, String key) throws Exception {
        Key k = AESUtils.toKey(Base64.decodeBase64((String)key));
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(1, k);
        return Base64.encodeBase64String((byte[])cipher.doFinal(data.getBytes()));
    }

    public static String decrypt(String data, String key) throws Exception {
        Key k = AESUtils.toKey(Base64.decodeBase64((String)key));
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(2, k);
        return new String(cipher.doFinal(Base64.decodeBase64((String)data)));
    }

    public static String generateMD5Value(String srcData) {
        if (StringUtils.isEmpty((String)srcData)) {
            return null;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(srcData.getBytes());
            byte[] encryptedData = messageDigest.digest();
            if (null == encryptedData || encryptedData.length == 0) {
                return null;
            }
            StringBuilder buf = new StringBuilder(encryptedData.length * 2);
            for (int i = 0; i < encryptedData.length; ++i) {
                buf.append(HEX_DIGITS[encryptedData[i] >> 4 & 0xF]);
                buf.append(HEX_DIGITS[encryptedData[i] & 0xF]);
            }
            return buf.toString();
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

