/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kelude.aps.utils;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.PriorityQueue;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DateUtils {
    private static final Logger log = LoggerFactory.getLogger(DateUtils.class);
    public static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_BEIJING_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZZ";
    public static final String FULL_DATE_TIME_FORMAT = "EEE MMM dd HH:mm:ss z yyyy";
    public static final String DATE_INTEGER_FORMAT = "yyyyMMdd";
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String SIMPLE_TIME_FORMAT = "HH:mm";
    public static final String TIME_FORMAT = "HH:mm:ss";
    public static final String CN_MONTH_FORMAT = "MM\u6708dd\u65e5";
    public static final String CN_YEAR_FORMAT = "yy\u5e74MM\u6708dd\u65e5";
    public static final String SIMPLE_DATE_FORMAT = "yyyy/M/d";
    public static final long DAY_LENGTH = 86400000L;
    public static final long HOUR_LENGTH = 3600000L;
    public static final long MINUTE_LENGTH = 60000L;
    public static final int MONTH_AMOUNT_PER_QUARTER = 3;
    private static final String TODAY_TAIL = "\u5206\u949f\u524d";
    private static final String TODAY_HEAD = "\u4eca\u5929";
    private static Pattern pattern = Pattern.compile("^([\\d\\.]+)([^\\d\\.]*)$");
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static ThreadLocalDateFormat fmtThreadLocal = new ThreadLocalDateFormat();

    private DateUtils() {
    }

    public static Date getOffsetDate(int offset) {
        Calendar calender = Calendar.getInstance();
        calender.add(5, offset);
        return calender.getTime();
    }

    public static Date formatDate(String time) throws ParseException {
        SimpleDateFormat dt = null;
        if (time.indexOf(47) == 4) {
            dt = time.length() == 8 || time.length() == 9 || time.length() == 10 ? new SimpleDateFormat("yyyy/MM/dd") : (time.length() == 7 ? new SimpleDateFormat("yyyy/MM") : (time.length() == 13 ? new SimpleDateFormat("yyyy/MM/dd HH") : (time.length() == 15 ? new SimpleDateFormat("yyyy/M/dd HH:mm") : (time.length() == 16 ? new SimpleDateFormat("yyyy/MM/dd HH:mm") : (time.length() == 18 ? new SimpleDateFormat("yyyy/M/dd HH:mm:ss") : new SimpleDateFormat("yyyy/MM/dd HH:mm:ss"))))));
            return dt.parse(time);
        }
        dt = time.length() == 7 ? new SimpleDateFormat("yyyy-MM") : (time.length() == 10 ? new SimpleDateFormat(DATE_FORMAT) : (time.length() == 13 ? new SimpleDateFormat("yyyy-MM-dd HH") : (time.length() == 16 ? new SimpleDateFormat("yyyy-MM-dd HH:mm") : (time.length() == 19 ? new SimpleDateFormat(DATE_TIME_FORMAT) : new SimpleDateFormat(DATE_FORMAT)))));
        return dt.parse(time);
    }

    public static Date formatDateForConsults(String time) throws ParseException {
        SimpleDateFormat dt = null;
        dt = time.indexOf(47) == 2 ? new SimpleDateFormat("dd/MM/yyyy HH:mm") : new SimpleDateFormat("yyyy/dd/MM HH:mm");
        return dt.parse(time);
    }

    public static String dateTimeToString(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_TIME_FORMAT);
        return sdf.format(date);
    }

    public static String dateTimeToString(Integer dateNumber, String format) {
        SimpleDateFormat dt = null;
        dt = new SimpleDateFormat(format);
        Date date = null;
        try {
            date = dt.parse(dateNumber.toString());
        }
        catch (ParseException e) {
            log.info("dateUtils paseStringToDate failed!" + dateNumber + " " + "dateFormat:" + format);
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_TIME_FORMAT);
        return sdf.format(date);
    }

    public static Integer dateToInteger(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_INTEGER_FORMAT);
        String now = sdf.format(date);
        return Integer.valueOf(now);
    }

    public static Date timeToDate(String time, String dateFormat) {
        SimpleDateFormat dt = new SimpleDateFormat(dateFormat);
        Date date = null;
        try {
            date = dt.parse(time);
        }
        catch (ParseException e) {
            log.info("dateUtils paseStringToDate failed!" + time + " " + "dateFormat:" + dateFormat);
        }
        return date;
    }

    public static Date integerTimeToDate(String dateFormat) {
        if (null == dateFormat) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_INTEGER_FORMAT);
        try {
            return sdf.parse(dateFormat);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static Date stringTimeToDate(String dateFormat) {
        if (null == dateFormat) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_TIME_FORMAT);
        try {
            return sdf.parse(dateFormat);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static String dateToString(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(SIMPLE_DATE_FORMAT);
        return sdf.format(date);
    }

    public static String dateToString() {
        return DateUtils.dateFormat(new Date());
    }

    public static String dateToString(Date date, String format) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }

    public static Date stringToNextDate(String dateFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat(SIMPLE_DATE_FORMAT);
        try {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(sdf.parse(dateFormat));
            ((Calendar)calendar).add(5, 1);
            return calendar.getTime();
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static Date sevenDaysAgo(Date date) {
        if (date != null) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(date);
            ((Calendar)calendar).add(5, -7);
            return calendar.getTime();
        }
        return null;
    }

    public static Date aMonthAgo(Date date) {
        if (date != null) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(date);
            ((Calendar)calendar).add(2, -1);
            return calendar.getTime();
        }
        return null;
    }

    public static Date yesterday(Date date) {
        if (date != null) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(date);
            ((Calendar)calendar).add(5, -1);
            return calendar.getTime();
        }
        return null;
    }

    public static Date nextDate(Date date) {
        if (date != null) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(date);
            ((Calendar)calendar).add(5, 1);
            return calendar.getTime();
        }
        return null;
    }

    public static String nextDatetoString(String dateFormat) {
        SimpleDateFormat formatter = new SimpleDateFormat(SIMPLE_DATE_FORMAT);
        return formatter.format(DateUtils.stringToNextDate(dateFormat));
    }

    public static Date stringToDate(String dateStr, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        try {
            if (StringUtils.isNotEmpty((String)dateStr)) {
                return sdf.parse(dateStr);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return null;
    }

    public static Date defaultStringToDate(String dateStr) {
        SimpleDateFormat df = new SimpleDateFormat(FULL_DATE_TIME_FORMAT, Locale.US);
        try {
            return df.parse(dateStr);
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Date stringToDate(String dateFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        try {
            if (StringUtils.isNotEmpty((String)dateFormat)) {
                return sdf.parse(dateFormat);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return null;
    }

    public static Date getNowOnOneDay(int num) {
        Calendar cal = Calendar.getInstance();
        cal.add(6, num);
        return cal.getTime();
    }

    public static long getDaysBetweenTwoDates(Date start, Date end) {
        long days = 0L;
        try {
            Date startDate = new SimpleDateFormat(SIMPLE_DATE_FORMAT).parse(DateUtils.dateToString(start));
            Date endDate = new SimpleDateFormat(SIMPLE_DATE_FORMAT).parse(DateUtils.dateToString(end));
            long diff = startDate.getTime() - endDate.getTime();
            days = diff / 86400000L;
        }
        catch (ParseException e) {
            // empty catch block
        }
        return days;
    }

    private static String dateFormat(Date start, Date end) {
        StringBuilder sb = new StringBuilder();
        long diff = start.getTime() - end.getTime();
        if (diff < 0L) {
            long days = DateUtils.getDaysBetweenTwoDates(end, start);
            if (days == 1L) {
                sb.append("\u660e\u5929");
            } else if (days == 2L) {
                sb.append("\u540e\u5929");
            } else {
                int years = end.getYear() - start.getYear();
                if (years == 0) {
                    sb.append(DateUtils.dateToString(end, CN_MONTH_FORMAT));
                } else if (years == 1) {
                    sb.append("\u53bb\u5e74");
                    sb.append(DateUtils.dateToString(end, CN_MONTH_FORMAT));
                } else {
                    sb.append(DateUtils.dateToString(end, CN_YEAR_FORMAT));
                }
            }
        } else {
            long days = DateUtils.getDaysBetweenTwoDates(start, end);
            if (days > 0L && days <= 6L) {
                if (days == 1L) {
                    sb.append("\u6628\u5929");
                } else if (days == 2L) {
                    sb.append("\u524d\u5929");
                } else {
                    sb.append(days);
                    sb.append("\u5929\u524d");
                }
            } else {
                int years = start.getYear() - end.getYear();
                if (years == 0) {
                    sb.append(DateUtils.dateToString(end, CN_MONTH_FORMAT));
                } else if (years == 1) {
                    sb.append("\u53bb\u5e74 ");
                    sb.append(DateUtils.dateToString(end, CN_MONTH_FORMAT));
                } else {
                    sb.append(DateUtils.dateToString(end, CN_YEAR_FORMAT));
                }
            }
        }
        return sb.toString();
    }

    public static String getSimpleTimeFormat(Date date) {
        return DateUtils.dateToString(date, SIMPLE_TIME_FORMAT);
    }

    public static String getTimeFormat(Date date) {
        return DateUtils.dateToString(date, TIME_FORMAT);
    }

    public static String aboutTimeFormat(Date date) {
        if (date == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Date now = new Date();
        long diff = now.getTime() - date.getTime();
        long days = diff / 86400000L;
        if (days == 0L) {
            long hours = diff / 3600000L;
            if (hours == 0L) {
                long minutes = diff / 60000L;
                if (minutes == 0L) {
                    long s = diff / 1000L;
                    if (s < 3L) {
                        sb.append("\u521a\u521a");
                    } else {
                        sb.append("\u7ea6");
                        sb.append(diff / 1000L);
                        sb.append("\u79d2\u524d");
                    }
                } else {
                    sb.append("\u7ea6");
                    sb.append(minutes);
                    sb.append(TODAY_TAIL);
                }
            } else {
                if (DateUtils.dateToString(now).equals(DateUtils.dateToString(date))) {
                    sb.append(TODAY_HEAD);
                } else {
                    sb.append("\u6628\u5929");
                }
                sb.append(DateUtils.getSimpleTimeFormat(date));
            }
        } else {
            sb.append(DateUtils.dateFormat(now, date));
            sb.append(" ");
            sb.append(DateUtils.getSimpleTimeFormat(date));
        }
        return sb.toString();
    }

    public static String accurateTimeFormat(Date date) {
        if (date == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Date now = new Date();
        if (DateUtils.dateToString(now).equals(DateUtils.dateToString(date))) {
            sb.append(TODAY_HEAD);
            sb.append(DateUtils.getSimpleTimeFormat(date));
        } else {
            sb.append(DateUtils.dateFormat(now, date));
            sb.append("");
            sb.append(DateUtils.getSimpleTimeFormat(date));
        }
        return sb.toString();
    }

    public static String dateFormat(Date date) {
        if (date == null) {
            return "";
        }
        Date now = new Date();
        if (DateUtils.dateToString(now).equals(DateUtils.dateToString(date))) {
            return "\u4eca\u5929 ";
        }
        return DateUtils.dateFormat(now, date);
    }

    public static Calendar getToday0() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    public static Date getOneDay0(int num) {
        Calendar cal = Calendar.getInstance();
        cal.add(6, num);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date randomBirthday() {
        Calendar rightNow = Calendar.getInstance();
        int year = DateUtils.randomYear();
        int month = DateUtils.randomMonth();
        SimpleDateFormat simpleDate = new SimpleDateFormat("yyyy/MM");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(year);
        stringBuilder.append("/");
        stringBuilder.append(month);
        try {
            rightNow.setTime(simpleDate.parse(stringBuilder.toString()));
        }
        catch (ParseException e) {
            // empty catch block
        }
        int days = rightNow.getActualMaximum(5);
        rightNow.set(year, month, (int)(Math.random() * (double)days) + 1);
        return rightNow.getTime();
    }

    public static boolean isFirstDayOfWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int dayOfWeek = calendar.get(7);
        return 2 == dayOfWeek;
    }

    public static boolean isFirstDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int dayOfMonth = calendar.get(5);
        return 1 == dayOfMonth;
    }

    public static boolean isFirstDayOfQuater(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int month = calendar.get(2);
        return 0 == month % 3 && DateUtils.isFirstDayOfMonth(date);
    }

    public static Date addDays(Date date, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(6, amount);
        return calendar.getTime();
    }

    public static Date nowAfterYears(Date date) {
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1) - 1;
        calendar.setTime(date);
        calendar.set(1, year);
        return calendar.getTime();
    }

    public static Date addMinutes(Date date, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(12, amount);
        return calendar.getTime();
    }

    public static Date addSeconds(Date date, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(13, amount);
        return calendar.getTime();
    }

    public static Date getFirstDayOfLastWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int dayOfWeek = calendar.get(7);
        return DateUtils.getZeroClockOfDay(DateUtils.addDays(date, -5 - dayOfWeek));
    }

    public static Date getFirstDayOfLastMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, -1);
        calendar.set(5, 1);
        return DateUtils.getZeroClockOfDay(calendar.getTime());
    }

    public static Date getFirstDayOfLastQuarter(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int curMonth = calendar.get(2);
        int monthDiff = -3 - curMonth % 3;
        calendar.add(2, monthDiff);
        calendar.set(5, 1);
        return DateUtils.getZeroClockOfDay(calendar.getTime());
    }

    public static Date getZeroClockOfDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getLastDivisibleTimeByMinutes(Date curTime, int divMinutes) {
        Calendar c = Calendar.getInstance();
        c.setTime(curTime);
        c.set(13, 0);
        c.set(14, 0);
        int minute = c.get(12);
        minute -= minute % divMinutes;
        c.set(12, minute);
        return c.getTime();
    }

    public static Date getLastDivisibleTimeBySeconds(Date curTime, int divSeconds) {
        Calendar c = Calendar.getInstance();
        c.setTime(curTime);
        c.set(14, 0);
        int seconds = c.get(13);
        seconds -= seconds % divSeconds;
        c.set(13, seconds);
        return c.getTime();
    }

    public static int compare(Date date1, Date date2) {
        Calendar c1 = Calendar.getInstance();
        c1.setTime(date1);
        Calendar c2 = Calendar.getInstance();
        c2.setTime(date2);
        return c1.compareTo(c2);
    }

    public static long compareMinutes(Date date1, Date date2, TimeUnit unit) {
        long t1 = date1.getTime();
        long t2 = date2.getTime();
        long dt = t1 - t2;
        return unit.convert(dt, TimeUnit.MILLISECONDS);
    }

    public static String getTimeLeftStr(Date date) {
        if (null == date) {
            return "";
        }
        long diff = (date.getTime() - new Date().getTime()) / 1000L;
        long min = 0L;
        long hour = 0L;
        long day = 0L;
        StringBuilder buf = new StringBuilder();
        if (diff <= 0L) {
            return "\u5df2\u8fc7\u671f";
        }
        day = diff / 86400L;
        hour = (diff -= day * 86400L) / 3600L;
        min = (diff -= hour * 3600L) / 60L;
        if (day != 0L) {
            buf.append(day).append("\u5929");
        }
        if (hour != 0L) {
            buf.append(hour).append("\u5c0f\u65f6");
        }
        if (min != 0L) {
            buf.append(min).append("\u5206\u949f");
        } else if (diff % 60L != 0L) {
            buf.append("1\u5206\u949f");
        }
        return buf.toString();
    }

    private static int randomYear() {
        return (int)(Math.random() * 12.0) + 1985;
    }

    private static int randomMonth() {
        return (int)(Math.random() * 12.0) + 1;
    }

    public static DateFormat getThreadLocalDateFormat() {
        return (DateFormat)fmtThreadLocal.get();
    }

    public static Date convertWeiboTime(String time) {
        time = time.trim();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        SimpleDateFormat sdfFull = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        if (time.endsWith(TODAY_TAIL)) {
            int minutes = Integer.parseInt(time.substring(0, time.indexOf(TODAY_TAIL)).trim());
            Calendar calender = Calendar.getInstance();
            calender.add(12, -minutes);
            return calender.getTime();
        }
        if (time.startsWith(TODAY_HEAD)) {
            String dt = time.substring(TODAY_HEAD.length() + 1).trim();
            dt = sdf.format(new Date()) + " " + dt;
            try {
                return sdfFull.parse(dt);
            }
            catch (ParseException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        } else if (time.length() <= 12) {
            time = time.replace("\u6708", "-").replace("\u65e5", "");
            int year = Calendar.getInstance().get(1);
            String dt = year + "-" + time;
            try {
                return sdfFull.parse(dt);
            }
            catch (ParseException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        } else {
            try {
                return sdfFull.parse(time);
            }
            catch (ParseException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return new Date();
    }

    public static Date utcToBeijingDate(String dateStr) {
        dateStr = dateStr.replace("T", " ").replace("Z", " ");
        return DateUtils.addMinutes(DateUtils.stringToDate(dateStr, DATE_TIME_FORMAT), 480);
    }

    public static Date utcToBeijingDate(String dateStr, String format) {
        dateStr = dateStr.replace("T", " ").replace("Z", " ");
        return DateUtils.addMinutes(DateUtils.stringToDate(dateStr, format), 480);
    }

    public static String utcToBeijing(String dateStr) {
        return DateUtils.utcToBeijing(dateStr, DATE_TIME_FORMAT);
    }

    public static String utcToBeijing(String dateStr, String format) {
        Date date = DateUtils.utcToBeijingDate(dateStr, format);
        return DateUtils.dateToString(date, format);
    }

    public static String utcNextDayToBeijing(String dateStr, String format) {
        Date date = DateUtils.utcToBeijingDate(dateStr, format);
        date = DateUtils.addDays(date, 1);
        return DateUtils.dateToString(date, format);
    }

    public static Date getMondayOfTheWeek(Date time) {
        Calendar c = Calendar.getInstance();
        c.setTime(time);
        int day_of_week = c.get(7) - 1;
        if (day_of_week == 0) {
            day_of_week = 7;
        }
        c.add(5, -day_of_week + 1);
        return c.getTime();
    }

    public static Long stringToTimeSecond(String val) {
        if (val == null) {
            return null;
        }
        Matcher matcher = pattern.matcher(val);
        if (matcher.find() && matcher.groupCount() == 2) {
            long time = Long.parseLong(matcher.group(1));
            String unit = matcher.group(2);
            if ("\u5929".equals(unit)) {
                return time * 24L * 60L * 60L;
            }
            if ("\u5206\u949f".equals(unit)) {
                return time * 60L;
            }
            if ("\u5c0f\u65f6".equals(unit)) {
                return time * 60L * 60L;
            }
            if ("\u79d2".equals(unit)) {
                return time;
            }
        }
        return null;
    }

    public static Long stringToTimeMillis(String val) {
        if (val == null) {
            return null;
        }
        Matcher matcher = pattern.matcher(val);
        if (matcher.find() && matcher.groupCount() == 2) {
            double time = Double.parseDouble(matcher.group(1));
            String unit = matcher.group(2);
            if ("\u5929".equals(unit)) {
                return (long)(time * 24.0 * 60.0 * 60.0 * 1000.0);
            }
            if ("\u5206\u949f".equals(unit)) {
                return (long)(time * 60.0 * 1000.0);
            }
            if ("\u5c0f\u65f6".equals(unit)) {
                return (long)(time * 60.0 * 60.0 * 1000.0);
            }
            if ("\u79d2".equals(unit)) {
                return (long)(time * 1000.0);
            }
            return (long)time;
        }
        try {
            return Long.parseLong(val);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date stringToFullDate(String val) {
        if (val == null) {
            return null;
        }
        try {
            val = val.trim();
            Date date = DateUtils.stringToFullDateFmt2(val);
            if (date != null) {
                return date;
            }
            Pattern pattern = Pattern.compile("\\d{2,4}-\\d{1,2}-\\d{1,2}\\s\\d{1,2}:\\d{1,2}");
            Matcher matcher = pattern.matcher(val);
            if (matcher.matches()) {
                SimpleDateFormat sdf = new SimpleDateFormat("yy-MM-dd HH:mm");
                return sdf.parse(val);
            }
            pattern = Pattern.compile("\\d{2,4}-\\d{1,2}-\\d{1,2}\\s\\d{1,2}:\\d{1,2}:\\d{1,2}");
            if (matcher.matches()) {
                SimpleDateFormat sdf = new SimpleDateFormat("yy-MM-dd HH:mm:ss");
                return sdf.parse(val);
            }
            pattern = Pattern.compile("\\d{2,4}\u5e74\\d{1,2}\u6708\\d{1,2}\u65e5\\d{1,2}\u65f6.*");
            matcher = pattern.matcher(val);
            if (matcher.matches()) {
                SimpleDateFormat sdf = new SimpleDateFormat("yy\u5e74MM\u6708dd\u65e5HH\u65f6");
                return sdf.parse(val);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Date stringToFullDateFmt2(String val) {
        if (val == null) {
            return null;
        }
        Matcher matcher = pattern.matcher(val);
        if (matcher.find() && matcher.groupCount() == 2) {
            Calendar calender = Calendar.getInstance();
            int time = Integer.parseInt(matcher.group(1));
            String unit = matcher.group(2);
            if (TODAY_TAIL.equals(unit)) {
                calender.add(12, -time);
            } else if ("\u79d2\u524d".equals(unit)) {
                calender.add(13, -time);
            } else if ("\u5c0f\u65f6\u524d".equals(unit)) {
                calender.add(10, -time);
            } else if ("\u5929\u524d".equals(unit)) {
                calender.add(5, -time);
            }
            return calender.getTime();
        }
        return null;
    }

    public static Date getLastDate(List<Date> dateList) {
        if (dateList == null || dateList.size() <= 0) {
            return null;
        }
        PriorityQueue<Date> queue = new PriorityQueue<Date>();
        for (Date date : dateList) {
            if (date == null) continue;
            queue.add(date);
        }
        Date result = null;
        Date flag = (Date)queue.poll();
        while (flag != null) {
            result = flag;
            flag = (Date)queue.poll();
        }
        return result;
    }

    public static String getDateNow(String format) {
        Date date = new Date();
        SimpleDateFormat df = new SimpleDateFormat(format);
        String timeNow = df.format(date);
        return timeNow;
    }

    public static Date stringToWeiboDateFmt(String val) {
        if (val == null) {
            return null;
        }
        if ("\u521a\u521a".equals(val)) {
            return new Date();
        }
        Calendar calender = Calendar.getInstance();
        Pattern pattern = Pattern.compile("^([\\d\\.]+)([^\\d\\.]*)$");
        Matcher matcher = pattern.matcher(val);
        if (matcher.find() && matcher.groupCount() == 2) {
            int time = Integer.parseInt(matcher.group(1));
            String unit = matcher.group(2);
            System.out.println(time + "  " + unit);
            if (TODAY_TAIL.equals(unit)) {
                calender.add(12, -time);
            } else if ("\u79d2\u524d".equals(unit)) {
                calender.add(13, -time);
            } else if ("\u5c0f\u65f6\u524d".equals(unit)) {
                calender.add(10, -time);
            } else if ("\u5929\u524d".equals(unit)) {
                calender.add(5, -time);
            }
            return calender.getTime();
        }
        if (val.startsWith(TODAY_HEAD)) {
            val = val.substring(TODAY_HEAD.length()).trim();
            pattern = Pattern.compile("\\d+:\\d+");
            matcher = pattern.matcher(val);
            if (matcher.matches()) {
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat("HH:ss");
                    Date time = sdf.parse(val);
                    int year = calender.get(1);
                    int month = calender.get(2);
                    int day = calender.get(5);
                    calender.setTime(time);
                    calender.set(1, year);
                    calender.set(2, month);
                    calender.set(5, day);
                    return calender.getTime();
                }
                catch (Exception e) {}
            }
        } else {
            pattern = Pattern.compile("\\d+\\-\\d+\\s+\\d+:\\d+");
            matcher = pattern.matcher(val);
            if (matcher.matches()) {
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat("MM-dd HH:ss");
                    Date time = sdf.parse(val);
                    int year = calender.get(1);
                    calender.setTime(time);
                    calender.set(1, year);
                    return calender.getTime();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if ((matcher = (pattern = Pattern.compile("\\d+\\-\\d+\\-\\d+\\s+\\d+:\\d+")).matcher(val)).matches()) {
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:ss");
                    return sdf.parse(val);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return new Date();
    }

    public static Date getWeiboDate(String dateStr) {
        Date date = null;
        try {
            date = new SimpleDateFormat("E MMM dd HH:mm:ss z yyyy", Locale.US).parse(dateStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }

    public static void main(String[] args) {
    }

    private static class ThreadLocalDateFormat
    extends ThreadLocal<DateFormat> {
        DateFormat proto;

        public ThreadLocalDateFormat() {
            SimpleDateFormat tmp = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.ROOT);
            tmp.setTimeZone(UTC);
            this.proto = tmp;
        }

        @Override
        protected DateFormat initialValue() {
            return (DateFormat)this.proto.clone();
        }
    }
}

