/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kelude.aps.utils;

import com.alibaba.druid.util.Base64;
import com.taobao.kelude.aps.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileUtils {
    public static final String SUFFIX_JPG = "jpg";
    public static final String SUFFIX_XLSX = "xlsx";

    public static String generateRandomFileName() {
        String filename = "";
        try {
            filename = filename + InetAddress.getLocalHost().getHostName();
            filename = filename.replaceAll("\\.", "_");
            filename = filename + System.currentTimeMillis();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return filename;
    }

    public static String generateRandomJpgFileName() {
        String filename = FileUtils.generateRandomFileName();
        return StringUtils.isEmpty((String)filename) ? "" : filename + "." + SUFFIX_JPG;
    }

    public static String generateRandomJpgFileNameEx() {
        return UUID.randomUUID().toString().replace("-", "") + "." + SUFFIX_JPG;
    }

    public static String generateRandomExcelFileName() {
        String filename = FileUtils.generateRandomFileName();
        return StringUtils.isEmpty((String)filename) ? "" : filename + "." + SUFFIX_XLSX;
    }

    public static String getFileNameSuffix(String fileName) {
        String[] nameParts = fileName.split("\\.");
        String suffix = "";
        if (nameParts.length > 1) {
            suffix = suffix + nameParts[1];
        }
        return suffix;
    }

    public static String getFileType(String fileName) {
        String[] nameParts = fileName.split("\\.");
        if (nameParts.length > 1) {
            return nameParts[nameParts.length - 1];
        }
        return "";
    }

    public static Boolean isPicture(String fileName) {
        if (null == fileName || "".equals(fileName)) {
            return false;
        }
        Pattern pattern = Pattern.compile("\\.(jpeg|gif|bmp|png|jpg|ico|jpe|tiff|tif)$", 2);
        Matcher matcher = pattern.matcher(fileName);
        return matcher.find();
    }

    public static String encodeBase64File(File file) throws Exception {
        FileInputStream inputFile = new FileInputStream(file);
        byte[] buffer = new byte[(int)file.length()];
        inputFile.read(buffer);
        inputFile.close();
        return Base64.byteArrayToBase64((byte[])buffer);
    }

    public static String generateRandomFileNameWithSuffix(String suffix) {
        String filename = FileUtils.generateRandomFileName();
        if (suffix == null) {
            return StringUtils.isEmpty((String)filename) ? "" : filename;
        }
        return StringUtils.isEmpty((String)filename) ? "" : filename + "." + suffix;
    }
}

