/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kelude.aps.utils;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IOUtils {
    private static Logger log = LoggerFactory.getLogger(IOUtils.class);

    private IOUtils() {
    }

    public static void closeStream(Reader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void closeStream(Writer writer) {
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void closeStream(InputStream ins) {
        try {
            if (ins != null) {
                ins.close();
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void closeStream(OutputStream out) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object fileToObject(File file) {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        ObjectInputStream ois = null;
        try {
            if (!file.exists()) {
                Object var2_2 = null;
                return var2_2;
            }
            ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            Object object = ois.readObject();
            IOUtils.closeStream(ois);
            return object;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            IOUtils.closeStream(ois);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stringToFile(File file, String str) {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(file));
            writer.write(str);
            writer.flush();
        }
        catch (IOException e) {
            try {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(writer);
                throw throwable;
            }
            IOUtils.closeStream(writer);
        }
        IOUtils.closeStream(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String streamToString(InputStream ins, String charset) {
        String string;
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(ins, charset));
            String line = null;
            while ((line = br.readLine()) != null) {
                bw.write(line + "\n");
            }
            bw.flush();
            string = sw.toString();
        }
        catch (Exception e) {
            String string2;
            try {
                log.error(e.getMessage(), (Throwable)e);
                string2 = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(bw);
                IOUtils.closeStream(br);
                throw throwable;
            }
            IOUtils.closeStream(bw);
            IOUtils.closeStream(br);
            return string2;
        }
        IOUtils.closeStream(bw);
        IOUtils.closeStream(br);
        return string;
    }
}

