/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kelude.aps.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javassist.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReflectUtils {
    private static final Logger log = LoggerFactory.getLogger(ReflectUtils.class);

    private ReflectUtils() {
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String getRealFieldName(String fieldName) {
        String[] params = fieldName.split("_");
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < params.length; ++i) {
            String param = params[i];
            if (i > 0) {
                char ch = param.charAt(0);
                ch = Character.toUpperCase(ch);
                String suffix = param.substring(1);
                buf.append(ch).append(suffix);
                continue;
            }
            buf.append(param);
        }
        return buf.toString();
    }

    public static Object invokeMethod(Object obj, Method method, Object ... vals) {
        try {
            return method.invoke(obj, vals);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static boolean setFieldValue(Object obj, Field field, Object value) {
        try {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            field.set(obj, value);
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static Field getDeepField(Class<?> clazz, String fieldName) {
        try {
            Field field = null;
            do {
                try {
                    field = clazz.getDeclaredField(fieldName);
                    if (field != null) continue;
                    clazz = clazz.getSuperclass();
                }
                catch (NoSuchFieldException e) {
                    clazz = clazz.getSuperclass();
                }
            } while (clazz != null && !clazz.equals(Object.class) && field == null);
            return field;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static List<Field> getDeepFields(Class<?> clazz) {
        ArrayList<Field> result = new ArrayList<Field>();
        try {
            do {
                Field[] fields;
                if ((fields = clazz.getDeclaredFields()) == null) continue;
                for (Field field : fields) {
                    if (field.isEnumConstant() || Modifier.isStatic((int)field.getModifiers()) || Modifier.isFinal((int)field.getModifiers())) continue;
                    result.add(field);
                }
                clazz = clazz.getSuperclass();
            } while (clazz != null && !clazz.equals(Object.class));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... types) {
        try {
            return clazz.getMethod(methodName, types);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Method getDeepMethod(Class<?> clazz, String methodName, Class<?> ... types) {
        if (clazz.isInterface()) {
            return ReflectUtils.getMethod(clazz, methodName, types);
        }
        try {
            Method method = null;
            do {
                try {
                    types = types == null || types.length == 0 ? null : types;
                    method = clazz.getDeclaredMethod(methodName, types);
                    if (method != null) continue;
                    clazz = clazz.getSuperclass();
                }
                catch (NoSuchMethodException e) {
                    if (!clazz.isInterface()) {
                        clazz = clazz.getSuperclass();
                        continue;
                    }
                    Class<?>[] interfaceClass = clazz.getInterfaces();
                    if (interfaceClass != null) {
                        Class<?> c;
                        Class<?>[] arr$ = interfaceClass;
                        int len$ = arr$.length;
                        for (int i$ = 0; i$ < len$ && (method = ReflectUtils.getMethod(c = arr$[i$], methodName, types)) == null; ++i$) {
                        }
                    }
                    clazz = null;
                }
            } while (clazz != null && !clazz.equals(Object.class) && method == null);
            return method;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Class<?>[] getObjectClasses(Object[] objs) {
        if (objs == null || objs.length == 0) {
            return null;
        }
        Class[] classes = new Class[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            classes[i] = objs[i] == null ? null : objs[i].getClass();
        }
        return classes;
    }

    public static Method getSetMethod(Class<?> clazz, String fieldName, Class<?> ... types) {
        try {
            String[] params = fieldName.split("_");
            StringBuilder buf = new StringBuilder();
            buf.append("set");
            for (String param : params) {
                char ch = param.charAt(0);
                ch = Character.toUpperCase(ch);
                String suffix = param.substring(1);
                buf.append(ch).append(suffix);
            }
            String methodName = buf.toString();
            return clazz.getMethod(methodName, types);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Method getGetMethod(Class<?> clazz, String fieldName, Class<?> ... types) {
        try {
            String[] params = fieldName.split("_");
            StringBuilder buf = new StringBuilder();
            buf.append("get");
            for (String param : params) {
                char ch = param.charAt(0);
                ch = Character.toUpperCase(ch);
                String suffix = param.substring(1);
                buf.append(ch).append(suffix);
            }
            String methodName = buf.toString();
            return clazz.getMethod(methodName, types);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Object convertStringToClass(Class<?> typeClass, String val) {
        if (val == null) {
            return null;
        }
        if (typeClass.equals(String.class)) {
            return val;
        }
        if (typeClass.equals(Integer.class) || typeClass.equals(Integer.TYPE)) {
            return Integer.parseInt(val);
        }
        if (typeClass.equals(Double.class) || typeClass.equals(Double.TYPE)) {
            return Double.parseDouble(val);
        }
        if (typeClass.equals(Float.class) || typeClass.equals(Float.TYPE)) {
            return Float.valueOf(Float.parseFloat(val));
        }
        if (typeClass.equals(Long.class) || typeClass.equals(Long.TYPE)) {
            return Long.parseLong(val);
        }
        if (typeClass.equals(Short.class) || typeClass.equals(Short.TYPE)) {
            return Short.parseShort(val);
        }
        if (typeClass.equals(Boolean.class) || typeClass.equals(Boolean.TYPE)) {
            return Boolean.parseBoolean(val);
        }
        if (typeClass.equals(Character.class) || typeClass.equals(Character.TYPE)) {
            return Character.valueOf(val.charAt(0));
        }
        throw new RuntimeException("Invalid convert class from string to " + typeClass);
    }

    public static String getMethodUniqueName(Method method) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(method.getDeclaringClass().getName()).append('.');
            sb.append(method.getName()).append('(');
            Class<?>[] params = method.getParameterTypes();
            if (params != null) {
                for (int j = 0; j < params.length; ++j) {
                    sb.append(ReflectUtils.getTypeName(params[j]));
                    if (j >= params.length - 1) continue;
                    sb.append(',');
                }
            }
            sb.append(')');
            return sb.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getTypeName(Class<?> type) {
        if (type.isArray()) {
            try {
                Class<?> cl = type;
                int dimensions = 0;
                while (cl.isArray()) {
                    ++dimensions;
                    cl = cl.getComponentType();
                }
                StringBuffer sb = new StringBuffer();
                sb.append(cl.getName());
                for (int i = 0; i < dimensions; ++i) {
                    sb.append("[]");
                }
                return sb.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return type.getName();
    }

    public static Long[] convertLongArray(String[] args) {
        if (args == null) {
            return null;
        }
        Long[] ret = new Long[args.length];
        for (int i = 0; i < args.length; ++i) {
            ret[i] = Long.parseLong(args[i]);
        }
        return ret;
    }

    public static Float[] convertFloatArray(String[] args) {
        if (args == null) {
            return null;
        }
        Float[] ret = new Float[args.length];
        for (int i = 0; i < args.length; ++i) {
            ret[i] = Float.valueOf(Float.parseFloat(args[i]));
        }
        return ret;
    }

    public static Double[] convertDoubleArray(String[] args) {
        if (args == null) {
            return null;
        }
        Double[] ret = new Double[args.length];
        for (int i = 0; i < args.length; ++i) {
            ret[i] = Double.parseDouble(args[i]);
        }
        return ret;
    }
}

