/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kelude.aps.utils;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class WordsUtils {
    static String[] stopPreffixWords = new String[]{"\u4e00", "\u8fd8", "\u4e0b", "\u4e0d", "\u5bf9", "\u4e24", "\u6709", "\u51e0", "\u597d", "\u518d", "\u6ca1", "\u4f46", "\u53ef", "\u770b", "\uff1b", "\u591a", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u8d70", "\u5165", "\u5411", "\u6700", "\u5927", "\u8ba9", "\u8d8a", "\u6bcf", "\u6216", "\u8bf7", "\u54ea", "\u90a3", "\u5f88", "\u8fc7", "\u7b2c", "\u4e0a", "@", "+", "\u4e14", "\u8fd9", "\u624d", "\u4e86", "\u591f", "\u600e", "\u5219", "\u5413"};
    static String[] stopSuffixWords = new String[]{"\u4e86", "\u91cc", "\u4e0d", "\u65e0"};

    private WordsUtils() {
    }

    public static boolean checkInvalidWord(String s) {
        int len = s.length();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < len; ++i) {
            String t = String.valueOf(s.charAt(i));
            Integer count = (Integer)map.get(t);
            if (count == null) {
                count = 0;
            }
            if ((count = Integer.valueOf(count + 1)) > 2) {
                return true;
            }
            map.put(t, count);
        }
        map.clear();
        return false;
    }

    public static boolean matchStopWord(String s) {
        for (String head : stopPreffixWords) {
            if (!s.startsWith(head)) continue;
            return true;
        }
        for (String end : stopSuffixWords) {
            if (!s.endsWith(end)) continue;
            return true;
        }
        return false;
    }

    public static Integer[][] getWordVector(String word1, String word2) {
        LinkedHashMap<Integer, Integer> map1 = WordsUtils.computeWordVector(word1);
        LinkedHashMap<Integer, Integer> map2 = WordsUtils.computeWordVector(word2);
        List<Integer>[] list = WordsUtils.getWordTotalVectors(map1, map2);
        Integer[][] result = new Integer[2][];
        result[0] = new Integer[list[0].size()];
        list[0].toArray(result[0]);
        result[1] = new Integer[list[1].size()];
        list[1].toArray(result[1]);
        return result;
    }

    private static List<Integer>[] getWordTotalVectors(LinkedHashMap<Integer, Integer> word1, LinkedHashMap<Integer, Integer> word2) {
        LinkedList[] result = new LinkedList[]{new LinkedList(), new LinkedList()};
        LinkedHashMap<Integer, Integer> total = new LinkedHashMap<Integer, Integer>();
        for (Integer key : word1.keySet()) {
            total.put(key, key);
        }
        for (Integer key : word2.keySet()) {
            total.put(key, key);
        }
        for (Integer key : total.keySet()) {
            Integer count = word1.get(key);
            Integer count2 = word2.get(key);
            count = count == null ? 0 : 1;
            if ((count2 = Integer.valueOf(count2 == null ? 0 : 1)) == null) continue;
            result[0].add(count);
            result[1].add(count2);
        }
        return result;
    }

    private static LinkedHashMap<Integer, Integer> computeWordVector(String word) {
        word = word.toLowerCase();
        LinkedHashMap<Integer, Integer> map = new LinkedHashMap<Integer, Integer>();
        int len = word.length();
        for (int i = 0; i < len; ++i) {
            char ch = word.charAt(i);
            Integer key = ch;
            Integer count = map.get(key);
            if (count == null) {
                count = 0;
            }
            count = count + 1;
            map.put(key, count);
        }
        return map;
    }

    public static boolean containDigit(String word) {
        int len = word.length();
        for (int i = 0; i < len; ++i) {
            char ch = word.charAt(i);
            if (!WordsUtils.checkCharDigit(ch)) continue;
            return true;
        }
        return false;
    }

    public static int checkDigitCount(String word) {
        int count = 0;
        int len = word.length();
        for (int i = 0; i < len; ++i) {
            char ch = word.charAt(i);
            if (!WordsUtils.checkCharDigit(ch)) continue;
            ++count;
        }
        return count;
    }

    public static boolean checkEnglishDigit(String word) {
        boolean endigit = true;
        int len = word.length();
        for (int i = 0; i < len; ++i) {
            char ch = word.charAt(i);
            if (WordsUtils.checkEnglishChar(ch) || WordsUtils.checkCharDigit(ch)) continue;
            endigit = false;
            break;
        }
        return endigit;
    }

    public static boolean checkCharDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static boolean checkSameString(String s) {
        char ch = s.charAt(0);
        for (int i = 0; i < s.length(); ++i) {
            if (ch == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkWordDigit(String s) {
        try {
            Long.parseLong(s);
            return true;
        }
        catch (Exception e) {
            try {
                Double.parseDouble(s);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    public static boolean checkEnglish(String word) {
        int len = word.length();
        for (int i = 0; i < len; ++i) {
            char ch = word.charAt(i);
            if ('a' <= ch && ch <= 'z') continue;
            return false;
        }
        return true;
    }

    public static boolean checkEnglishChar(char ch) {
        return 'a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z';
    }

    public static boolean checkChinese(String word) {
        char[] charArray = word.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            if (charArray[i] < '\u4e00' || charArray[i] > '\u9fbb') continue;
            return true;
        }
        return false;
    }

    public static boolean checkChineseChar(char ch) {
        return ch >= '\u4e00' && ch <= '\u9fbb';
    }

    public static int intValue(Object val) {
        if (val == null) {
            return 0;
        }
        if (val instanceof Long) {
            return ((Long)val).intValue();
        }
        if (val instanceof Integer) {
            return (Integer)val;
        }
        if (val instanceof Short) {
            return ((Short)val).shortValue();
        }
        return 0;
    }

    public static String unicodeToString(String str) {
        if (str == null || "".equals(str.trim())) {
            return "";
        }
        Pattern pattern = Pattern.compile("(\\\\u(\\p{XDigit}{4}))");
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            char ch = (char)Integer.parseInt(matcher.group(2), 16);
            str = str.replace(matcher.group(1), ch + "");
        }
        return str;
    }

    public static String filterWeiboHtmlContent(String content) {
        if (content.indexOf(" alt=") >= 0) {
            String reg = "<img[^<>]*?\\salt=['\"]?(.*?)['\"]?\\s.*?>";
            Matcher m = Pattern.compile(reg).matcher(content);
            while (m.find()) {
                String p = m.group(0);
                String r = m.group(1);
                content = content.replace(p, r);
                m = Pattern.compile(reg).matcher(content);
            }
        }
        return WordsUtils.filterHtml(content).trim();
    }

    public static String filterHtml(String str) {
        String regxpForHtml = "<([^>]*)>";
        Pattern pattern = Pattern.compile(regxpForHtml);
        Matcher matcher = pattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        boolean result1 = matcher.find();
        while (result1) {
            matcher.appendReplacement(sb, "");
            result1 = matcher.find();
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static List<String> tagAttrMatch(String source, String element, String attr) {
        LinkedList<String> result = new LinkedList<String>();
        String reg = "<" + element + "[^<>]*?\\s" + attr + "=['\"]?(.*?)['\"]?\\s.*?>";
        Matcher m = Pattern.compile(reg).matcher(source);
        while (m.find()) {
            String r = m.group(1);
            result.add(r);
        }
        return result;
    }
}

