/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kelude.aps.crawler.model;

import com.taobao.kelude.aps.sentiment.SentimentAnalysis;
import com.taobao.kelude.aps.sentiment.SentimentException;
import com.taobao.kelude.common.BaseModel;
import java.util.Calendar;
import java.util.Date;

public abstract class BaseCrawlerEntity
extends BaseModel {
    private static final long serialVersionUID = -3470661743503311326L;
    protected String id;
    protected String content;
    protected String visitUrl;
    protected int emotionScore;
    protected int posCount;
    protected int negCount;
    protected int midCount;
    protected int hot;
    protected int statisticEmotion;
    protected int statisticCount;

    public int setEmotionAnalysis(SentimentAnalysis analysis) throws SentimentException {
        int emotionScore;
        this.emotionScore = emotionScore = analysis.doFinal();
        this.posCount = analysis.getPosCount();
        this.negCount = analysis.getNegCount();
        this.midCount = analysis.getMidCount();
        this.statisticEmotion = analysis.getTotalScore();
        this.statisticCount = analysis.getTotalCount();
        return emotionScore;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        if (content.length() > 80) {
            content = content.substring(0, 80);
            content = content + "...";
        }
        this.content = content.trim();
    }

    public abstract int computeHot();

    public abstract boolean checkTimeFilter();

    protected boolean checkTimeFilter(Date lastDate) {
        long diff = this.getTodayStartTime() - lastDate.getTime();
        long days = diff / 86400000L;
        return days > 3L;
    }

    private long getTodayStartTime() {
        Calendar todayStart = Calendar.getInstance();
        todayStart.set(10, 0);
        todayStart.set(12, 0);
        todayStart.set(13, 0);
        todayStart.set(14, 0);
        return todayStart.getTime().getTime();
    }

    public int getEmotionScore() {
        return this.emotionScore;
    }

    public void setEmotionScore(int emotionScore) {
        this.emotionScore = emotionScore;
    }

    public int getPosCount() {
        return this.posCount;
    }

    public void setPosCount(int posCount) {
        this.posCount = posCount;
    }

    public int getNegCount() {
        return this.negCount;
    }

    public void setNegCount(int negCount) {
        this.negCount = negCount;
    }

    public int getMidCount() {
        return this.midCount;
    }

    public void setMidCount(int midCount) {
        this.midCount = midCount;
    }

    public String getVisitUrl() {
        return this.visitUrl;
    }

    public void setVisitUrl(String visitUrl) {
        this.visitUrl = visitUrl;
    }

    public int getHot() {
        return this.hot;
    }

    public void setHot(int hot) {
        this.hot = hot;
    }

    public int getStatisticEmotion() {
        return this.statisticEmotion;
    }

    public void setStatisticEmotion(int statisticEmotion) {
        this.statisticEmotion = statisticEmotion;
    }

    public int getStatisticCount() {
        return this.statisticCount;
    }

    public void setStatisticCount(int statisticCount) {
        this.statisticCount = statisticCount;
    }

    public String toString() {
        return "BaseCrawlerEntity [id=" + this.id + ", content=" + this.content + ", emotionScore=" + this.emotionScore + ", posCount=" + this.posCount + ", negCount=" + this.negCount + ", midCount=" + this.midCount + "]";
    }
}

