/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kelude.aps.crawler.model;

import com.taobao.kelude.aps.utils.DateUtils;
import com.taobao.kelude.common.BaseModel;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewsEntity
extends BaseModel {
    private static final long serialVersionUID = 6973786374581568689L;
    private static Logger log = LoggerFactory.getLogger(NewsEntity.class);
    protected String id;
    protected String title;
    protected String description;
    protected String visitUrl;
    private String date;
    private Date time;
    private String sourceType;
    private String source;
    private long repostCount;
    private long commentCount;
    private int weiboVerifiedType;
    private long weiboFollowersCount;
    private String weiboNickName;
    private String similarUrl;
    private Integer similarNumber;
    private String desc;

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getSimilarUrl() {
        return this.similarUrl;
    }

    public void setSimilarUrl(String similarUrl) {
        this.similarUrl = similarUrl;
    }

    public Integer getSimilarNumber() {
        return this.similarNumber;
    }

    public void setSimilarNumber(Integer similarNumber) {
        this.similarNumber = similarNumber;
    }

    public NewsEntity() {
    }

    public NewsEntity(String sourceType) {
        this.sourceType = sourceType;
    }

    public boolean checkToutiaoTimeFilter() {
        if (this.date == null || "".equals(this.date.trim())) {
            return false;
        }
        this.date = this.date.trim();
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm");
            Date lastDate = dateFormat.parse(this.date);
            return this.checkTimeFilter(lastDate);
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean checkYoudaoTimeFilter() {
        if (this.date == null || "".equals(this.date) || this.date.indexOf("\u5206\u949f\u524d") >= 0 || this.date.indexOf("\u5c0f\u65f6\u524d") >= 0 || this.date.indexOf("\u6628\u5929") >= 0) {
            return false;
        }
        if (this.time == null) {
            this.date = this.date.trim();
            String newDate = this.date.replace("\u5e74", "-").replace("\u6708", "-").replace("\u65e5", "");
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                this.time = dateFormat.parse(newDate);
            }
            catch (ParseException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.checkTimeFilter(this.time);
    }

    public boolean checkSogouTimeFilter() {
        if (this.date == null) {
            return false;
        }
        try {
            if (this.time == null) {
                this.date = this.date.trim();
                this.time = DateUtils.formatDate(this.date.trim());
            }
            return this.checkTimeFilter(this.time);
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean checkBaiduTimeFilter() {
        if (this.date == null) {
            return false;
        }
        try {
            if (this.time == null) {
                this.date = this.date.trim();
                if ("".equals(this.date) || this.date.indexOf("\u5206\u949f\u524d") >= 0 || this.date.indexOf("\u5c0f\u65f6\u524d") >= 0 || this.date.indexOf("\u6628\u5929") >= 0) {
                    return false;
                }
                String newDate = this.date.replace("\u5e74", "-").replace("\u6708", "-").replace("\u65e5", "");
                this.time = DateUtils.formatDate(newDate.trim());
            }
            return this.checkTimeFilter(this.time);
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean checkWeiboTimeFilter() {
        if (this.date.indexOf("\u5206\u949f\u524d") >= 0 || this.date.indexOf("\u4eca\u5929") >= 0 || this.date.indexOf("\u5c0f\u65f6\u524d") >= 0) {
            return false;
        }
        if (this.date.indexOf("\u5e74") >= 0) {
            return true;
        }
        if (this.time == null) {
            this.time = DateUtils.convertWeiboTime(this.date);
        }
        return this.checkTimeFilter(this.time);
    }

    protected boolean checkTimeFilter(Date lastDate) {
        long diff = this.getTodayStartTime() - lastDate.getTime();
        long days = diff / 86400000L;
        return days > 3L;
    }

    private long getTodayStartTime() {
        Calendar todayStart = Calendar.getInstance();
        todayStart.set(10, 0);
        todayStart.set(12, 0);
        todayStart.set(13, 0);
        todayStart.set(14, 0);
        return todayStart.getTime().getTime();
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getVisitUrl() {
        return this.visitUrl;
    }

    public void setVisitUrl(String visitUrl) {
        this.visitUrl = visitUrl;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public long getRepostCount() {
        return this.repostCount;
    }

    public void setRepostCount(long repostCount) {
        this.repostCount = repostCount;
    }

    public int getWeiboVerifiedType() {
        return this.weiboVerifiedType;
    }

    public void setWeiboVerifiedType(int weiboVerifiedType) {
        this.weiboVerifiedType = weiboVerifiedType;
    }

    public long getWeiboFollowersCount() {
        return this.weiboFollowersCount;
    }

    public void setWeiboFollowersCount(long weiboFollowersCount) {
        this.weiboFollowersCount = weiboFollowersCount;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setSource(String source, String defaultSource) {
        if (source == null || "".equals(source.trim())) {
            this.source = defaultSource == null ? "\u5916\u90e8\u65b0\u95fb" : defaultSource;
        } else {
            if (source.indexOf("\u817e\u8baf") >= 0 || source.indexOf("qq.com") >= 0) {
                source = "\u817e\u8baf\u7f51";
            } else if (source.indexOf("\u641c\u72d0") >= 0 || source.indexOf("sohu.com") >= 0) {
                source = "\u641c\u72d0";
            } else if (source.indexOf("\u65b0\u6d6a") >= 0 || source.indexOf("sina.com") >= 0) {
                source = "\u65b0\u6d6a";
            } else if (source.indexOf("\u7f51\u6613") >= 0 || source.indexOf("163.com") >= 0) {
                source = "\u7db2\u6613";
            }
            this.source = source.trim();
        }
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getWeiboNickName() {
        return this.weiboNickName;
    }

    public void setWeiboNickName(String weiboNickName) {
        this.weiboNickName = weiboNickName;
    }

    public long getCommentCount() {
        return this.commentCount;
    }

    public void setCommentCount(long commentCount) {
        this.commentCount = commentCount;
    }

    public String getHost() {
        String[] strs;
        if (this.getVisitUrl() != null && (strs = this.getVisitUrl().split("/")) != null && strs.length > 2) {
            return strs[2];
        }
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        return "NewsEntity [id=" + this.id + ", title=" + this.title + ", description=" + this.description + ", visitUrl=" + this.visitUrl + ", date=" + this.date + ", time=" + this.time + ", sourceType=" + this.sourceType + ", source=" + this.source + ", repostCount=" + this.repostCount + ", weiboVerifiedType=" + this.weiboVerifiedType + ", weiboFollowersCount=" + this.weiboFollowersCount + ", weiboNickName=" + this.weiboNickName + "]";
    }
}

