/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kelude.aps.feedback.enums;

public enum OsType {
    ANDROID(0, "android"),
    IOS(1, "ios"),
    WIN(2, "windows"),
    MAC(3, "mac"),
    LINUX(4, "linux"),
    UNKNOWN(5, "UNKNOWN");

    private int key;
    private String description;

    private OsType(int key, String description) {
        this.key = key;
        this.description = description;
    }

    public static OsType getEnumByKey(Integer key) {
        if (key == null) {
            return null;
        }
        for (OsType ne : OsType.values()) {
            if (!key.equals(ne.getKey())) continue;
            return ne;
        }
        return null;
    }

    public static OsType getEnumByDescription(String desc) {
        if (desc == null) {
            return UNKNOWN;
        }
        for (OsType ne : OsType.values()) {
            if (!desc.equalsIgnoreCase(ne.getDescription())) continue;
            return ne;
        }
        return UNKNOWN;
    }

    public int getKey() {
        return this.key;
    }

    public void setKey(int key) {
        this.key = key;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

