/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kelude.aps.feedback.enums;

public enum ProductType {
    MOBILE(0, "mobile"),
    PC(1, "pc"),
    WEB(2, "web"),
    NEWS(3, "news"),
    TEXT(20, "text"),
    FILE(21, "file"),
    IMG(22, "img"),
    FORM(23, "form"),
    HTML(24, "html"),
    SYSTEM(25, "system"),
    WEIBO_STATUS(30, "weibo status"),
    WEIBO_COMMENT(31, "weibo comment"),
    WEIBO_PRIMESSAGE(32, "weibo private message"),
    APPCHNL(4, "app channel"),
    PICTURE(50, "picture"),
    VOICE(51, "voice"),
    PIC_TXT_MIX(52, "pic_text_mix"),
    FACEBOOK_POST(60, "facebook post"),
    FACEBOOK_PRIMESSAGE(61, "facebook private message"),
    TWITTER_POST(62, "twitter post"),
    TWITTER_PRIMESSAGE(63, "twitter private message");

    private int key;
    private String description;

    private ProductType(int key, String description) {
        this.key = key;
        this.description = description;
    }

    public static ProductType getEnumByKey(Integer key) {
        if (key == null) {
            return null;
        }
        for (ProductType ne : ProductType.values()) {
            if (!key.equals(ne.getKey())) continue;
            return ne;
        }
        return null;
    }

    public static ProductType getEnumByDescription(String desc) {
        if (desc == null) {
            return null;
        }
        for (ProductType ne : ProductType.values()) {
            if (!desc.equalsIgnoreCase(ne.getDescription())) continue;
            return ne;
        }
        return null;
    }

    public int getKey() {
        return this.key;
    }

    public void setKey(int key) {
        this.key = key;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

