/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kelude.aps.feedback.helper;

import com.taobao.kelude.aps.utils.DateUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.common.SolrDocument;

public class TSearchHelper {
    private static final Pattern PTN_VALID_OPERATOR = Pattern.compile("^AND\\s|\\sAND$|^AND$|\\sAND\\s|^OR\\s|\\sOR$|^OR$|\\sOR\\s|^NOT\\s|\\sNOT$|^NOT$|\\sNOT\\s");
    private static final Pattern PTN_QUOTA = Pattern.compile("(^|\\s)\"[^\".]*\"(\\s|$)");

    public static boolean operatorExists(String input) {
        if (StringUtils.isEmpty((String)input)) {
            return true;
        }
        Matcher matcher = PTN_VALID_OPERATOR.matcher(input);
        return matcher.find();
    }

    public static Integer getIntValueOf(Boolean value) {
        if (null != value) {
            return value != false ? 1 : 0;
        }
        return null;
    }

    public static void appendStrListField2QueryStr(StringBuilder qStr, List<String> values, String fieldName, Boolean jointAnd) {
        if (null != values && !values.isEmpty() && StringUtils.isNotEmpty((String)fieldName)) {
            ArrayList<String> newValues = new ArrayList<String>();
            for (String val : values) {
                newValues.add("\"" + TSearchHelper.escapeQueryStr(val) + "\"");
            }
            String jointChar = jointAnd != false ? " AND " : " OR ";
            qStr.append(fieldName + ":(" + StringUtils.join(newValues, (String)jointChar) + ") ");
        }
    }

    public static void appendCustFields2QueryStr(StringBuilder qStr, Map<String, String> cfs, String fieldNamePrefix) {
        if (cfs != null && !cfs.isEmpty()) {
            for (Map.Entry<String, String> entry : cfs.entrySet()) {
                TSearchHelper.appendSingleCustField2QueryStr(qStr, entry.getValue(), fieldNamePrefix + entry.getKey());
            }
        }
    }

    public static void appendEmptyCustFields2QueryStr(StringBuilder qStr, Map<String, String> cfs, String fieldNamePrefix) {
        if (cfs != null && !cfs.isEmpty()) {
            for (Map.Entry<String, String> entry : cfs.entrySet()) {
                TSearchHelper.appendEmptyCustField2QueryStr(qStr, entry.getValue(), fieldNamePrefix + entry.getKey());
            }
        }
    }

    public static void appendEmptyCustField2QueryStr(StringBuilder qStr, String value, String fieldName) {
        if (StringUtils.isNotEmpty((String)value) && StringUtils.isNotEmpty((String)fieldName)) {
            qStr.append("-" + fieldName + ":" + "[0 TO *]" + " ");
        }
    }

    public static void appendBinaryCfs2QueryStr(StringBuilder qStr, Map<String, String> cfs, String fieldNamePrefix) {
        if (cfs != null && !cfs.isEmpty()) {
            for (Map.Entry<String, String> entry : cfs.entrySet()) {
                TSearchHelper.appendBinaryCfAsOne2QueryStr(qStr, entry.getValue(), fieldNamePrefix + entry.getKey());
            }
        }
    }

    private static void addSingleValue2List(List<String> valueList, String singleValue) {
        if (Pattern.matches("^\"[\\w\\W]+\"$", singleValue = singleValue.trim())) {
            valueList.add(TSearchHelper.escapeQueryStrBasic(singleValue));
        } else {
            valueList.add(TSearchHelper.escapeQueryStr(singleValue) + "*");
        }
    }

    public static void appendSingleCustField2QueryStr(StringBuilder qStr, String value, String fieldName) {
        if (StringUtils.isNotEmpty((String)value) && StringUtils.isNotEmpty((String)fieldName)) {
            String solrStr = TSearchHelper.escapeQueryStrBasic(value);
            if (!TSearchHelper.operatorExists(value)) {
                ArrayList<String> valueList = new ArrayList<String>();
                Matcher mQuota = PTN_QUOTA.matcher(value);
                while (mQuota.find()) {
                    TSearchHelper.addSingleValue2List(valueList, mQuota.group());
                    value = value.replace(mQuota.group().trim(), "");
                }
                String[] values = value.trim().split(" ");
                for (int i = 0; i < values.length; ++i) {
                    if (!StringUtils.isNotBlank((String)values[i])) continue;
                    TSearchHelper.addSingleValue2List(valueList, values[i]);
                }
                if (!valueList.isEmpty()) {
                    solrStr = StringUtils.join(valueList, (String)" OR ");
                }
            }
            qStr.append(fieldName + ":(");
            qStr.append(solrStr);
            qStr.append(") ");
        }
    }

    public static void appendLongOrFields2QueryStr(StringBuilder qStr, Long value, Long value1, String ... fieldNames) {
        if (value == null || value < 0L || fieldNames.length == 0) {
            return;
        }
        qStr.append('(');
        int index = 0;
        for (String fieldName : fieldNames) {
            if (null == fieldName || !StringUtils.isNotEmpty((String)fieldName)) continue;
            if (index > 0) {
                qStr.append(" OR ");
            }
            qStr.append(fieldName).append(':').append(value).append(' ');
            ++index;
        }
        if (value1 != null) {
            qStr.append(" OR ");
            qStr.append("cluster_id").append(':').append(value1).append(' ');
        }
        qStr.append(')');
    }

    public static void appendIntListField2QueryStr(StringBuilder qStr, List<Integer> values, String fieldName) {
        if (null != values && !values.isEmpty() && StringUtils.isNotEmpty((String)fieldName)) {
            qStr.append(fieldName + ":(" + StringUtils.join(values, (String)" OR ") + ") ");
        }
    }

    public static void appendNumber2QueryStr(StringBuilder qStr, List<Integer> values, String fieldName) {
        if (null != values && !values.isEmpty() && StringUtils.isNotEmpty((String)fieldName)) {
            String value = "";
            for (Integer number : values) {
                value = value + "\"";
                value = value + number;
                value = value + "\"";
                value = value + " OR ";
            }
            value = value.substring(0, value.length() - 4);
            qStr.append(fieldName + ":(" + value + ") ");
        }
    }

    public static void appendLongListField2QueryStr(StringBuilder qStr, List<Long> values, String fieldName) {
        if (null != values && !values.isEmpty() && StringUtils.isNotEmpty((String)fieldName)) {
            qStr.append(fieldName + ":(" + StringUtils.join(values, (String)" OR ") + ") ");
        }
    }

    public static void insertLongListAsMultiitem(StringBuilder qStr, List<Long> values, String fieldName) {
        if (null != values && !values.isEmpty() && StringUtils.isNotEmpty((String)fieldName)) {
            qStr.insert(0, String.format("{!multiterm multitermfield=%s multiterms=%s operator=AND}", fieldName, StringUtils.join(values, (String)",")));
        }
    }

    public static void insertStringListAsMultiitem(StringBuilder qStr, String values, String fieldName) {
        String[] sss = StringUtils.split((String)values, (String)",");
        qStr.insert(0, "(");
        qStr.append(")");
        qStr.append(" OR  _query_:");
        qStr.append("\"");
        List<String> clusterIds = Arrays.asList(sss);
        if (null != clusterIds && !clusterIds.isEmpty() && StringUtils.isNotEmpty((String)fieldName)) {
            qStr.append(String.format("{!multiterm multitermfield=%s multiterms=%s}", fieldName, StringUtils.join(clusterIds, (String)",")));
        }
        qStr.append("\"");
    }

    public static void insertStringListAsMultiitem(StringBuilder qStr, List<String> values, String fieldName) {
        if (null != values && !values.isEmpty() && StringUtils.isNotEmpty((String)fieldName)) {
            qStr.insert(0, String.format("{!multiterm multitermfield=%s multiterms=%s operator=AND}", fieldName, StringUtils.join(values, (String)",")));
        }
    }

    public static void appendBoolField2QueryStr(StringBuilder qStr, Boolean value, String fieldName) {
        if (null != value && StringUtils.isNotEmpty((String)fieldName)) {
            qStr.append(fieldName + ":" + TSearchHelper.getIntValueOf(value) + " ");
        }
    }

    public static void appendTimeField2QueryStr(StringBuilder qStr, String startDateStr, String endDateStr, Integer duration, String filedName) {
        Date endDate;
        Date startDate;
        if (StringUtils.isEmpty((String)startDateStr) && StringUtils.isEmpty((String)endDateStr) && null == duration || StringUtils.isEmpty((String)filedName)) {
            return;
        }
        StringBuilder queryString = new StringBuilder();
        if (!StringUtils.isEmpty((String)startDateStr) || !StringUtils.isEmpty((String)endDateStr)) {
            startDate = null != startDateStr && startDateStr.length() > 10 ? DateUtils.stringTimeToDate(startDateStr) : DateUtils.stringToDate(startDateStr);
            endDate = null != endDateStr && endDateStr.length() > 10 ? DateUtils.stringTimeToDate(endDateStr) : DateUtils.stringToDate(endDateStr);
        } else {
            startDate = DateUtils.addMinutes(new Date(), -duration.intValue());
            endDate = null;
        }
        DateFormat df = DateUtils.getThreadLocalDateFormat();
        if (startDate != null && endDate != null) {
            queryString.append(filedName + ":[" + df.format(startDate) + " TO " + df.format(endDate) + "]");
            queryString.append(" ");
        } else if (startDate == null && endDate != null) {
            queryString.append(filedName + ":[* TO " + df.format(endDate) + "]");
            queryString.append(" ");
        } else if (startDate != null && endDate == null) {
            queryString.append(filedName + ":[" + df.format(startDate) + " TO *]");
            queryString.append(" ");
        }
        qStr.append(queryString.toString());
    }

    public static void appendConsultTimeField2QueryStr(StringBuilder qStr, String startDateStr, String endDateStr, Integer duration, String filedName) {
        if (StringUtils.isEmpty((String)startDateStr) && StringUtils.isEmpty((String)endDateStr) && null == duration || StringUtils.isEmpty((String)filedName)) {
            return;
        }
        StringBuilder queryString = new StringBuilder();
        if (startDateStr != null && endDateStr != null) {
            queryString.append(filedName + ":[" + startDateStr + " TO " + endDateStr + "]");
            queryString.append(" ");
        } else if (startDateStr == null && endDateStr != null) {
            queryString.append(filedName + ":[* TO " + endDateStr + "]");
            queryString.append(" ");
        } else if (startDateStr != null && endDateStr == null) {
            queryString.append(filedName + ":[" + startDateStr + " TO *]");
            queryString.append(" ");
        }
        qStr.append(queryString.toString());
    }

    public static void appendStrFieldAsOne2QueryStr(StringBuilder qStr, String value, String fieldName) {
        if (StringUtils.isNotEmpty((String)value) && StringUtils.isNotEmpty((String)fieldName)) {
            qStr.append(fieldName + ":\"" + TSearchHelper.escapeQuotesInQueryStr(value.trim()) + "\" ");
        }
    }

    public static void appendBinaryCfAsOne2QueryStr(StringBuilder qStr, String value, String fieldName) {
        if (StringUtils.isNotEmpty((String)value) && StringUtils.isNotEmpty((String)fieldName)) {
            if ("0".equals(value)) {
                qStr.append("-" + fieldName + ":" + 1 + " ");
            } else {
                qStr.append(fieldName + ":(" + value + ")" + " ");
            }
        }
    }

    public static void appendStrField2QueryStr(StringBuilder qStr, String value, String fieldName, boolean isFuzzy) {
        if (StringUtils.isNotEmpty((String)value) && StringUtils.isNotEmpty((String)fieldName)) {
            String solrStr = TSearchHelper.escapeQueryStr(value);
            if (!TSearchHelper.operatorExists(value)) {
                String[] values = value.trim().split(" ");
                ArrayList<String> valueList = new ArrayList<String>();
                for (int i = 0; i < values.length; ++i) {
                    if (!StringUtils.isNotEmpty((String)values[i])) continue;
                    valueList.add(TSearchHelper.escapeQueryStr(values[i]) + (isFuzzy ? "*" : ""));
                }
                if (!valueList.isEmpty()) {
                    solrStr = StringUtils.join(valueList, (String)" OR ");
                }
            }
            qStr.append(fieldName + ":(");
            qStr.append(solrStr);
            qStr.append(") ");
        }
    }

    public static void appendTbNickNameStrField2QueryStr(StringBuilder qStr, String value, String fieldName, boolean isFuzzy) {
        if (StringUtils.isNotEmpty((String)value) && StringUtils.isNotEmpty((String)fieldName)) {
            String solrStr = TSearchHelper.escapeQueryStr(value);
            if (!TSearchHelper.operatorExists(value)) {
                String[] values = value.trim().split(" ");
                ArrayList<String> valueList = new ArrayList<String>();
                for (int i = 0; i < values.length; ++i) {
                    if (!StringUtils.isNotEmpty((String)values[i])) continue;
                    valueList.add(TSearchHelper.escapeQueryStr(values[i]) + (isFuzzy ? "*" : ""));
                }
                if (!valueList.isEmpty()) {
                    solrStr = StringUtils.join(valueList, (String)" OR ");
                }
            }
            qStr.append("(");
            qStr.append(fieldName + ":(");
            qStr.append(solrStr);
            qStr.append(") ");
            qStr.append(" OR ");
            qStr.append("parent_source:(");
            qStr.append(solrStr);
            qStr.append(") ");
            qStr.append(") ");
        }
    }

    public static void appendReferStrField2QueryStr(StringBuilder qStr, String value, String fieldName, boolean isFuzzy) {
        if (StringUtils.isNotEmpty((String)value) && StringUtils.isNotEmpty((String)fieldName)) {
            String solrStr = null;
            Integer index = value.indexOf("http:");
            if (index == -1) {
                String tmp = value;
                String tmpSolrStr = null;
                value = "http://" + value;
                solrStr = TSearchHelper.escapeQueryStr(value);
                solrStr = solrStr + (isFuzzy ? "*" : "");
                tmp = "https://" + tmp;
                tmpSolrStr = TSearchHelper.escapeQueryStr(tmp);
                tmpSolrStr = tmpSolrStr + (isFuzzy ? "*" : "");
                solrStr = solrStr + " OR " + tmpSolrStr;
            } else {
                solrStr = TSearchHelper.escapeQueryStr(value);
                solrStr = solrStr + (isFuzzy ? "*" : "");
            }
            qStr.append(fieldName + ":(");
            qStr.append(solrStr);
            qStr.append(") ");
        }
    }

    public static void appendReferStrListField2QueryStr(StringBuilder qStr, List<String> values, String fieldName, Boolean jointAnd) {
        if (null != values && !values.isEmpty() && StringUtils.isNotEmpty((String)fieldName)) {
            ArrayList<String> newValues = new ArrayList<String>();
            String solrStr = null;
            for (String value : values) {
                Integer index = value.indexOf("http:");
                if (index == -1) {
                    String tmp = value;
                    String tmpSolrStr = null;
                    value = "http://" + value;
                    solrStr = TSearchHelper.escapeQueryStr(value);
                    solrStr = solrStr + "*";
                    tmp = "https://" + tmp;
                    tmpSolrStr = TSearchHelper.escapeQueryStr(tmp);
                    solrStr = solrStr + " OR " + tmpSolrStr;
                    solrStr = solrStr + "*";
                } else {
                    solrStr = TSearchHelper.escapeQueryStr(value);
                    solrStr = solrStr + "*";
                }
                newValues.add(solrStr);
            }
            String jointChar = jointAnd != false ? " AND " : " OR ";
            qStr.append(fieldName + ":(" + StringUtils.join(newValues, (String)jointChar) + ") ");
        }
    }

    public static void appendIntField2QueryStr(StringBuilder qStr, Integer value, String fieldName) {
        if (null != value && StringUtils.isNotEmpty((String)fieldName)) {
            qStr.append(fieldName + ":\"" + value + "\" ");
        }
    }

    public static void appendIntFieldNotExpr2QueryStr(StringBuilder qStr, Integer value, String fieldName) {
        if (null != value && StringUtils.isNotEmpty((String)fieldName)) {
            qStr.append("-" + fieldName + ":\"" + value + "\" ");
        }
    }

    public static void appendLongField2QueryStr(StringBuilder qStr, Long value, String fieldName) {
        if (null != value && StringUtils.isNotEmpty((String)fieldName)) {
            qStr.append(fieldName + ":" + value + " ");
        }
    }

    public static void appendStringNotNullField2QueryStr(StringBuilder qStr, String fieldName) {
        if (StringUtils.isNotEmpty((String)fieldName)) {
            qStr.append(fieldName + ":['' TO *]");
        }
    }

    public static String strValueOf(Long obj) {
        return obj == null ? null : obj.toString();
    }

    public static String strValueOf(Integer obj) {
        return obj == null ? null : obj.toString();
    }

    public static String strValueOf(Boolean obj) {
        return obj == null ? null : obj.toString();
    }

    public static String strValueOf(Date obj) {
        return obj == null ? null : String.valueOf(obj.getTime());
    }

    public static String tlongValueOf(Date obj) {
        String tlongValue = null;
        if (obj != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            tlongValue = sdf.format(obj);
        }
        return tlongValue;
    }

    public static String tDateValueOf(Date obj) {
        String tlongValue = null;
        if (obj != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            tlongValue = sdf.format(obj);
        }
        return tlongValue;
    }

    public static Integer parseObjectToInt(Object o) {
        String s = (String)o;
        if (StringUtils.isBlank((String)s)) {
            return null;
        }
        return Integer.parseInt(s);
    }

    public static Boolean parseObjectToBool(Object o) {
        String s = (String)o;
        if (StringUtils.isBlank((String)s)) {
            return null;
        }
        return Boolean.parseBoolean(s);
    }

    public static Date parseObjectToDate(Object o) {
        Long dateL = (Long)o;
        if (o == null) {
            return null;
        }
        return new Date(dateL);
    }

    public static Long getLongFieldValue(SolrDocument doc, String fieldName) {
        Object val = doc.getFieldValue(fieldName);
        if (val != null && val instanceof Long) {
            return (Long)val;
        }
        return null;
    }

    public static Date getDateFieldValue(SolrDocument doc, String fieldName) {
        Object val = doc.getFieldValue(fieldName);
        if (val != null && val instanceof Date) {
            return (Date)val;
        }
        return null;
    }

    public static Integer getIntFieldValue(SolrDocument doc, String fieldName) {
        Object val = doc.getFieldValue(fieldName);
        if (val != null && val instanceof Integer) {
            return (Integer)val;
        }
        return null;
    }

    public static Boolean getBoolFieldValue(SolrDocument doc, String fieldName) {
        Object val = doc.getFieldValue(fieldName);
        if (val != null && val instanceof Integer) {
            return (Integer)val == 1;
        }
        return null;
    }

    public static String getStrFieldValue(SolrDocument doc, String fieldName) {
        Object val = doc.getFieldValue(fieldName);
        if (val != null && val instanceof String) {
            return (String)val;
        }
        return null;
    }

    private static String escapeQueryStr(String qStr) {
        return TSearchHelper.escapeQueryStrBasic(qStr).replace("\"", "\\\"");
    }

    private static String escapeQueryStrBasic(String qStr) {
        return qStr.replace("\\", "\\\\").replace("+", "\\+").replace("-", "\\-").replace("&&", "\\&&").replace("||", "\\||").replace("!", "\\!").replace("(", "\\(").replace(")", "\\)").replace("{", "\\{").replace("}", "\\}").replace("[", "\\[").replace("]", "\\]").replace("^", "\\^").replace("~", "\\~").replace("*", "\\*").replace("?", "\\?").replace(":", "\\:");
    }

    private static String escapeQuotesInQueryStr(String qStr) {
        return qStr.replace("\"", "\\\"");
    }

    public static String escapeBlankChar(String data) {
        return data.replaceAll("\t", "").replaceAll("(\n|\r)+", "`\\n`");
    }

    public static String dealImgNextLine(String data) {
        String[] strs;
        if (!StringUtils.isBlank((String)data) && data.indexOf("[[+_+]]") >= 0 && (strs = data.split("\n")) != null && strs.length > 0) {
            StringBuilder result = new StringBuilder("");
            for (int i = 0; i < strs.length; ++i) {
                if (strs[i].indexOf("[[+_+]]") >= 0 && i + 1 < strs.length && strs[i + 1].indexOf("[[+_+]]") < 0 && strs[i + 1].length() <= 40) {
                    result.append(strs[i]).append("\n");
                    result.append("[[++++").append(strs[i + 1]).append("----]]").append("\n");
                    ++i;
                    continue;
                }
                result.append(strs[i]).append("\n");
            }
            return result.toString();
        }
        return data;
    }

    public static void appendOpensearchIntFieldNotExpr2QueryStr(StringBuilder qStr, Integer value, String fieldName) {
        if (null != value && StringUtils.isNotEmpty((String)fieldName)) {
            qStr.append("ANDNOT" + fieldName + ":\"" + value + "\" ");
        }
    }

    public static void appendOpensearchStringFieldNotExpr2QueryStr(StringBuilder qStr, String value, String fieldName) {
        if (null != value && StringUtils.isNotEmpty((String)fieldName)) {
            qStr.append("ANDNOT" + fieldName + ":\"" + value + "\" ");
        }
    }
}

