/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kelude.aps.helper;

import com.taobao.kelude.common.PagedResult;
import com.taobao.kelude.common.Result;
import com.taobao.kelude.common.util.EmailUtils;
import com.taobao.kelude.common.util.PropertyUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.ThrowsAdvice;

public class MonitorThrowsAdvice
implements ThrowsAdvice {
    private static Logger log = LoggerFactory.getLogger(MonitorThrowsAdvice.class);
    private static final String MAIL_DUTY = "exception.mail";

    public void afterThrowing(Method m, Object args, Object target, Throwable subclass) {
        Class<Object> retClass = m.getReturnType();
        if (!retClass.isAssignableFrom(Result.class) && !retClass.isAssignableFrom(PagedResult.class)) {
            log.error(subclass.getMessage(), subclass);
            return;
        }
        StringWriter writer = new StringWriter(512);
        PrintWriter out = new PrintWriter(writer);
        out.write("<p>");
        out.write("Method:" + m + "<br>\r\n");
        if (args instanceof Object[]) {
            Object[] objs = (Object[])args;
            out.write("parameters:" + Arrays.toString(objs) + "\r\n");
        }
        out.write("</p>");
        out.write("<p>");
        subclass.printStackTrace(out);
        out.write("</p>");
        out.flush();
        String content = writer.toString();
        out.close();
        Object[] dutyPersons = MonitorThrowsAdvice.getDutyPersion();
        log.info("send error email content:" + content);
        log.info("send error email target:" + Arrays.toString(dutyPersons));
        StringBuilder subject = new StringBuilder("\u8206\u60c5\u5f02\u5e38\u63d0\u9192");
        try {
            InetAddress ia = InetAddress.getLocalHost();
            String host = ia.getHostName();
            String IP = ia.getHostAddress();
            subject.append('[').append(host).append('/').append(IP).append(']');
        }
        catch (UnknownHostException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        EmailUtils.sendSimpleMailMessage((String[])dutyPersons, (String)subject.toString(), (String)content);
    }

    private static String[] getDutyPersion() {
        String emails = "";
        emails = PropertyUtils.getProperty((String)MAIL_DUTY, (String)"/config.properties");
        if (null == emails || "".equals(emails)) {
            emails = PropertyUtils.getProperty((String)MAIL_DUTY);
        }
        if (null != emails && !"".equals(emails)) {
            return emails.split(",");
        }
        return new String[]{"lihua.llh@alibaba-inc.com"};
    }
}

