/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kelude.aps.kbm.helper;

import com.taobao.kelude.aps.utils.StringUtils;

public final class KbmHelper {
    public static final String CUSTOM_ATTR_MULTI_VALUE_SEP = "\u001d";
    public static final String CUSTOM_ATTR_SEP = ":";

    private KbmHelper() {
    }

    public static String customAttr(String attrName, String attrValue) {
        attrName = attrName != null ? attrName.replace(CUSTOM_ATTR_SEP, "\uff1a") : attrName;
        attrValue = attrValue != null ? attrValue.replace(CUSTOM_ATTR_SEP, "\uff1a") : attrValue;
        return StringUtils.bufferString(attrName, CUSTOM_ATTR_SEP, attrValue);
    }

    public static String[] getAttrMultiValues(String value) {
        return value.split(CUSTOM_ATTR_MULTI_VALUE_SEP);
    }

    public static String stringAttrMultiValues(String ... values) {
        StringBuilder buf = new StringBuilder();
        for (String value : values) {
            buf.append(value).append(CUSTOM_ATTR_MULTI_VALUE_SEP);
        }
        if (buf.length() > 0) {
            buf.setLength(buf.length() - CUSTOM_ATTR_MULTI_VALUE_SEP.length());
        }
        return buf.toString();
    }
}

