/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kelude.aps.opensearch.annotations;

import com.taobao.kelude.aps.opensearch.plugins.SearchFieldPlugin;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchFieldMeta
implements Serializable {
    private static final long serialVersionUID = -6885864268585033058L;
    private static final Logger log = LoggerFactory.getLogger(SearchFieldMeta.class);
    private String columnName;
    private Field field;
    private SearchFieldType fieldType;
    private SearchArrayIndexType arrayIndexType;
    private Class<?> type;
    private boolean array = false;
    private boolean collection = false;
    private boolean allowNull = true;
    boolean readable = true;
    boolean writeable = true;
    boolean primaryKey = false;
    boolean urlEncode = false;
    boolean allowMapping = true;
    private Class<?> arrayType;
    private Class<? extends SearchFieldPlugin> pluginClass;
    private SearchFieldPlugin fieldPlugin;
    private String[] pluginParams;

    public void parseType(Field field) {
        if (field == null) {
            return;
        }
        this.type = field.getType();
        this.array = this.type.isArray();
        if (this.array) {
            this.arrayType = this.type.getComponentType();
        } else if (Collection.class.isAssignableFrom(this.type)) {
            this.collection = true;
        }
    }

    public Object getValue(Object obj) {
        this.field.setAccessible(true);
        try {
            return this.field.get(obj);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public SearchFieldType getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(SearchFieldType fieldType) {
        this.fieldType = fieldType;
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public boolean isArray() {
        return this.array;
    }

    public Class<?> getArrayType() {
        return this.arrayType;
    }

    public boolean isCollection() {
        return this.collection;
    }

    public SearchArrayIndexType getArrayIndexType() {
        return this.arrayIndexType;
    }

    public void setArrayIndexType(SearchArrayIndexType arrayIndexType) {
        this.arrayIndexType = arrayIndexType;
    }

    public boolean isAllowNull() {
        return this.allowNull;
    }

    public void setAllowNull(boolean allowNull) {
        this.allowNull = allowNull;
    }

    public boolean isReadable() {
        return this.readable;
    }

    public void setReadable(boolean readable) {
        this.readable = readable;
    }

    public boolean isWriteable() {
        return this.writeable;
    }

    public void setWriteable(boolean writeable) {
        this.writeable = writeable;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(boolean primaryKey) {
        this.primaryKey = primaryKey;
    }

    public Class<? extends SearchFieldPlugin> getPluginClass() {
        return this.pluginClass;
    }

    public void setPluginClass(Class<? extends SearchFieldPlugin> pluginClass) {
        this.pluginClass = pluginClass;
    }

    public SearchFieldPlugin getFieldPlugin() {
        return this.fieldPlugin;
    }

    public void setFieldPlugin(SearchFieldPlugin fieldPlugin) {
        this.fieldPlugin = fieldPlugin;
    }

    public String[] getPluginParams() {
        return this.pluginParams;
    }

    public void setPluginParams(String[] pluginParams) {
        this.pluginParams = pluginParams;
    }

    public boolean isUrlEncode() {
        return this.urlEncode;
    }

    public void setUrlEncode(boolean urlEncode) {
        this.urlEncode = urlEncode;
    }

    public boolean isAllowMapping() {
        return this.allowMapping;
    }

    public void setAllowMapping(boolean allowMapping) {
        this.allowMapping = allowMapping;
    }

    public String toString() {
        return "SearchFieldMeta [columnName=" + this.columnName + ", field=" + this.field + ", fieldType=" + (Object)((Object)this.fieldType) + ", arrayIndexType=" + (Object)((Object)this.arrayIndexType) + ", type=" + this.type + ", array=" + this.array + ", collection=" + this.collection + ", allowNull=" + this.allowNull + ", readable=" + this.readable + ", writeable=" + this.writeable + ", primaryKey=" + this.primaryKey + ", urlEncode=" + this.urlEncode + ", allowMapping=" + this.allowMapping + ", arrayType=" + this.arrayType + ", pluginClass=" + this.pluginClass + ", fieldPlugin=" + this.fieldPlugin + ", pluginParams=" + Arrays.toString(this.pluginParams) + "]";
    }

    public static enum SearchArrayIndexType {
        NONE,
        INT8_ARRAY,
        INT16_ARRAY,
        INT32_ARRAY,
        INT64_ARRAY,
        FLOAT_ARRAY,
        DOUBLE_ARRAY,
        STRING_ARRAY;

    }

    public static enum SearchFieldType {
        BAISC,
        ARRAY,
        RELATE;

    }
}

