/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kelude.aps.opensearch.plugins;

import com.taobao.kelude.aps.feedback.model.Tag;
import com.taobao.kelude.aps.opensearch.annotations.SearchFieldMeta;
import com.taobao.kelude.aps.opensearch.plugins.SearchFieldPlugin;
import com.taobao.kelude.aps.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonNode;

public class SearchTagsFieldPlugin
implements SearchFieldPlugin {
    private static final List<Integer> EVENT_TYPES = Arrays.asList(Tag.TYPE_INTERNAL_EVENTS, Tag.TYPE_EXTERNAL_EVENTS);
    private static final List<Integer> VIEW_TYPES = Arrays.asList(Tag.TYPE_INTERNAL_VIEW, Tag.TYPE_EXTERNAL_VIEW);

    @Override
    public void setup(SearchFieldMeta fieldMeta) {
    }

    @Override
    public Object read(SearchFieldMeta fieldMeta, JsonNode node) {
        return null;
    }

    @Override
    public Object write(SearchFieldMeta fieldMeta, Object fieldValue, Map<String, Object> externResult) {
        List tags = (List)fieldValue;
        if (tags == null) {
            return null;
        }
        externResult.put("tag_ids", SearchTagsFieldPlugin.appendTagIds((List<Tag>)tags, Tag.TYPE_NORMAL));
        externResult.put("tag_names", SearchTagsFieldPlugin.appendTagNames((List<Tag>)tags, Tag.TYPE_NORMAL));
        externResult.put("event_ids", SearchTagsFieldPlugin.appendTagIds((List<Tag>)tags, EVENT_TYPES));
        externResult.put("event_names", SearchTagsFieldPlugin.appendTagNames((List<Tag>)tags, EVENT_TYPES));
        externResult.put("feedback_classify_ids", SearchTagsFieldPlugin.appendTagIds((List<Tag>)tags, Tag.TYPE_CLASSIFY));
        externResult.put("feedback_classify", SearchTagsFieldPlugin.appendTagIds((List<Tag>)tags, Tag.TYPE_CLASSIFY));
        externResult.put("view_ids", SearchTagsFieldPlugin.appendTagIds((List<Tag>)tags, VIEW_TYPES));
        externResult.put("view_id_emotions", SearchTagsFieldPlugin.appendTagIdAndEmotions(tags, VIEW_TYPES));
        externResult.put("address_ids", SearchTagsFieldPlugin.appendTagIds((List<Tag>)tags, Tag.TYPE_ADDRESS));
        externResult.put("tags_empty", externResult.get("tag_ids") != null ? 0 : 1);
        return null;
    }

    private static Integer[] appendTagIds(List<Tag> tags, Integer tagsType) {
        if (null != tags) {
            ArrayList<Integer> tagIds = new ArrayList<Integer>();
            for (Tag tag : tags) {
                if (!tagsType.equals(tag.getTagsType())) continue;
                tagIds.add(tag.getId());
            }
            return tagIds.toArray(new Integer[0]);
        }
        return null;
    }

    public static String appendTagNames(List<Tag> tags, Integer tagsType) {
        if (null != tags && !tags.isEmpty()) {
            ArrayList<String> tagNames = new ArrayList<String>();
            for (Tag tag : tags) {
                if (!tagsType.equals(tag.getTagsType())) continue;
                tagNames.add(tag.getName());
            }
            return StringUtils.join(tagNames, "|");
        }
        return "";
    }

    public static String appendTagNames(List<Tag> tags, List<Integer> tagsTypes) {
        if (null != tags && !tags.isEmpty()) {
            ArrayList<String> tagNames = new ArrayList<String>();
            for (Tag tag : tags) {
                if (!tagsTypes.contains(tag.getTagsType())) continue;
                tagNames.add(tag.getName());
            }
            return StringUtils.join(tagNames, "|");
        }
        return "";
    }

    private static Integer[] appendTagIds(List<Tag> tags, List<Integer> tagsTypes) {
        if (null != tags) {
            ArrayList<Integer> tagIds = new ArrayList<Integer>();
            for (Tag tag : tags) {
                if (!tagsTypes.contains(tag.getTagsType())) continue;
                tagIds.add(tag.getId());
            }
            return tagIds.toArray(new Integer[0]);
        }
        return null;
    }

    private static String[] appendTagIdAndEmotions(List<Tag> tags, List<Integer> tagsTypes) {
        if (null != tags) {
            ArrayList<String> tagIdAndEmotions = new ArrayList<String>();
            for (Tag tag : tags) {
                if (!tagsTypes.contains(tag.getTagsType())) continue;
                String value = StringUtils.bufferString(tag.getId(), Character.valueOf('_'), tag.getEmotionTendency() != null ? tag.getEmotionTendency() : "0");
                tagIdAndEmotions.add(value);
            }
            return tagIdAndEmotions.toArray(new String[0]);
        }
        return null;
    }
}

