/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kelude.aps.sentiment;

import com.taobao.kelude.aps.sentiment.EmotionStatistic;
import com.taobao.kelude.aps.sentiment.SentimentBean;
import com.taobao.kelude.aps.sentiment.SentimentException;
import com.taobao.kelude.aps.sentiment.SentimentService;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentimentThread
implements Callable<EmotionStatistic> {
    private static Logger log = LoggerFactory.getLogger(SentimentThread.class);
    private int maxFlush = 50;
    SentimentService sentimentService;
    List<SentimentBean> data;
    EmotionStatistic statisticBean;

    public SentimentThread(SentimentService sentimentService, List<SentimentBean> data) {
        this.sentimentService = sentimentService;
        this.data = data;
        this.maxFlush = data.size();
    }

    @Override
    public EmotionStatistic call() throws Exception {
        this.statisticBean = new EmotionStatistic();
        try {
            this.flushEmotion(this.data, true);
        }
        catch (Exception e) {
            log.error("Fail to get emotion statistic data from thread " + Thread.currentThread().getName());
        }
        return this.statisticBean;
    }

    private void flushEmotion(List<SentimentBean> flushData, boolean recursion) throws SentimentException {
        block5: {
            if (flushData.isEmpty()) {
                return;
            }
            try {
                List<SentimentBean> result = this.sentimentService.getContentEmotions(flushData);
                for (SentimentBean bean : result) {
                    this.statisticBean.updateBean(bean);
                }
                flushData.clear();
            }
            catch (NullPointerException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                int val = this.maxFlush / 2;
                this.maxFlush = val >= 5 ? val : 5;
                log.error("Fail to flush sentiment score. Cause " + e.getMessage() + ". Try again by maxFlush " + this.maxFlush);
                if (!recursion) break block5;
                this.flushPageEmotion(flushData);
            }
        }
    }

    private void flushPageEmotion(List<SentimentBean> flushData) {
        if (flushData.isEmpty()) {
            return;
        }
        int len = flushData.size();
        int pageCount = len % this.maxFlush == 0 ? len / this.maxFlush : len / this.maxFlush + 1;
        for (int page = 1; page <= pageCount; ++page) {
            int curIndex = (page - 1) * this.maxFlush;
            LinkedList<SentimentBean> pageList = new LinkedList<SentimentBean>();
            for (int i = curIndex; i < curIndex + this.maxFlush; ++i) {
                pageList.add(flushData.get(i));
            }
            try {
                this.flushEmotion(pageList, false);
                continue;
            }
            catch (SentimentException e) {
                log.error("Fail to flush page sentiment score. Cause " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

