/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kelude.aps.utils;

import com.taobao.kelude.aps.common.service.LdbTairService;
import com.taobao.kelude.aps.feedback.enums.TairKeyType;
import com.taobao.kelude.aps.utils.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class AccessAspect {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private ExecutorService threadPool = new ThreadPoolExecutor(5, 16, 300L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10000), new ThreadPoolExecutor.CallerRunsPolicy());
    @Resource
    private LdbTairService ldbTairService;
    private static Integer EXPIRE_TIME = 2592000;
    private static final Map<String, Boolean> HOT_METHOD_MAP = new HashMap<String, Boolean>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("queryFeedbackExtern", true);
            this.put("matchRules", true);
            this.put("addCustomValue", true);
            this.put("asyncInsert", true);
            this.put("addOrUpdateFeedbackExtern", true);
            this.put("matchCombiledRule", true);
            this.put("saveOrMigrateFeedback", true);
            this.put("search", true);
        }
    };
    public static ConcurrentHashMap<String, Boolean> logKeyMap = new ConcurrentHashMap();

    @Pointcut(value="execution(* com.taobao.kelude.aps.feedback.service..*.*(..)) || execution(* com.taobao.kelude.aps.feedback.manager..*.*(..)) || execution(* com.taobao.kelude.aps.kbm.service..*.*(..))|| execution(* com.taobao.kelude.aps.umeng.service..*.*(..))|| execution(* com.taobao.kelude.aps.weibo.service..*.*(..))|| execution(* com.taobao.kelude.aps.weibo.manager..*.*(..))")
    public void xxMethod() {
    }

    @After(value="xxMethod()")
    public void doAfter(final JoinPoint jp) {
        this.threadPool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    String targetClass = jp.getTarget().getClass().getName();
                    String targetMethod = jp.getSignature().getName();
                    if (HOT_METHOD_MAP.get(targetMethod) != null) {
                        return;
                    }
                    String key = StringUtils.bufferString(targetClass, Character.valueOf('_'), targetMethod);
                    if (logKeyMap.get(key) != null) {
                        return;
                    }
                    String cacheResult = (String)AccessAspect.this.ldbTairService.getValueFromTair(TairKeyType.fb_methodAccessLog.key, key);
                    if (cacheResult != null) {
                        logKeyMap.put(key, true);
                        return;
                    }
                    AccessAspect.this.log.info("^" + targetClass + "^" + targetMethod);
                    AccessAspect.this.ldbTairService.putDataToTair(TairKeyType.fb_methodAccessLog.key, key, "true", 0, (int)EXPIRE_TIME);
                    logKeyMap.put(key, true);
                }
                catch (Exception e) {
                    AccessAspect.this.log.error("doAfter failed!", (Throwable)e);
                }
            }
        });
    }
}

