/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kelude.aps.utils;

import com.taobao.kelude.aps.feedback.enums.ApiErrType;
import com.taobao.kelude.common.PagedResult;
import com.taobao.kelude.common.Result;

public class ApiResultUtils {
    public static Result<?> setErr4Result(Result<?> result, ApiErrType errType, Object ... args) {
        String errMsg = errType.errMsg;
        if (args.length > 0) {
            result.addFailureMessage(String.format(errMsg, args));
        } else {
            result.addFailureMessage(errMsg);
        }
        result.setErrorCode(Integer.valueOf(errType.errCode));
        return result;
    }

    public static Result<?> copyErr4Result(Result<?> srcResult, Result<?> destResult) {
        if (!srcResult.isSuccess()) {
            destResult.addFailureMessage(srcResult.getMessage());
            destResult.setErrorCode(srcResult.getErrorCode());
        }
        return destResult;
    }

    public static PagedResult<?> copyPagedResult(PagedResult<?> srcResult, PagedResult<?> destResult) {
        ApiResultUtils.copyErr4Result(srcResult, destResult);
        destResult.setTotalCount(srcResult.getTotalCount());
        destResult.setToPage(srcResult.getToPage());
        destResult.setPageSize(srcResult.getPageSize());
        return destResult;
    }

    public static String getMtopErrCode(ApiErrType err, String replacedPrefix) {
        if (null != err) {
            String errName = err.name();
            return errName.replace(replacedPrefix, "FAIL_BIZ");
        }
        return null;
    }

    public static Result<?> setMtopErrInfo(Result<?> result, String replacedPrefix) {
        if (result.isSuccess() || null == result.getErrorCode()) {
            return result;
        }
        ApiErrType topErr = null;
        for (ApiErrType err : ApiErrType.values()) {
            if (err.errCode != result.getErrorCode()) continue;
            topErr = err;
            break;
        }
        if (topErr != null) {
            String msgCode = ApiResultUtils.getMtopErrCode(topErr, replacedPrefix);
            result.setMsgCode(msgCode);
            result.setMsgInfo(result.getMessage());
            return result;
        }
        return null;
    }
}

