/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kelude.aps.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class DataSecurityUtils {
    private static Pattern patternLongIdNum = Pattern.compile("[1-9]\\d{5}[1-9]\\d{3}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}(\\d|X|x)");
    private static Pattern patternShortIdNum = Pattern.compile("[1-9]\\d{7}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}");
    private static Pattern patternPassportNum = Pattern.compile("(P|p)\\.?\\d{7}|(G|g)\\d{8}|(S|s)\\d{8}|(S|s)\\.\\d{7}|(D|d)\\d+|1[4,5]\\d{7}");
    private static Pattern patternOfficerNum = Pattern.compile("(\u5357|\u5317|\u6c88|\u5170|\u6210|\u6d4e|\u5e7f|\u53c2|\u8bc1|\u540e|\u88c5|\u6d77|\u7a7a)\u5b57(\u7b2c|\\s)?\\d{6,8}\u53f7?");
    private static Pattern patternCNMobileNum = Pattern.compile("((0086|\\+86)\\s{0,2}-?\\s{0,2})?1(3|4|5|7|8)\\d{9}");
    private static Pattern patternHKMobileNum = Pattern.compile("((00852|\\+852)\\s{0,2}-?\\s{0,2})?(5|6|8|9)\\d{7}");
    private static Pattern patternTWMobileNum = Pattern.compile("((00886|\\+886)\\s{0,2}-?\\s{0,2})?9\\d{8}");
    private static Pattern patternOtherPhoneNum = Pattern.compile("(((00|\\+)\\d{2,6})\\s{0,2}-?\\s{0,2})?\\d{2,5}\\s?-?\\s?\\d{6,9}");
    private static Pattern patternEntpriseRegNum = Pattern.compile("\\d{15}");
    private static Pattern patternMail = Pattern.compile("\\w+([-\\.]\\w+)*@\\w+([-\\.]\\w+)*\\.[a-zA-Z]{2,6}");
    private static Pattern patternCheckCNMobileNum = Pattern.compile("^\\d{11}$");
    private static Pattern patternCheckMail = Pattern.compile("^\\w+([-_\\.]\\w+)*@\\w+([-\\.]\\w+)*\\.[a-zA-Z]{2,6}$");
    private static Map<DataType, Pattern> mapDataType2Pattern = new HashMap<DataType, Pattern>();

    private DataSecurityUtils() {
    }

    public static boolean isEmail(String input) {
        if (StringUtils.isEmpty((String)input)) {
            return false;
        }
        return patternCheckMail.matcher(input).matches();
    }

    public static boolean isMobileNum(String input) {
        if (StringUtils.isEmpty((String)input)) {
            return false;
        }
        return patternCheckCNMobileNum.matcher(input).matches();
    }

    public static String getMaskData(String orgData) {
        if (StringUtils.isEmpty((String)orgData)) {
            return null;
        }
        String maskedStr = orgData;
        for (DataType key : mapDataType2Pattern.keySet()) {
            maskedStr = DataSecurityUtils.mask(mapDataType2Pattern.get((Object)key), maskedStr, key);
        }
        return maskedStr;
    }

    private static String mask(Pattern pattern, String orgStr, DataType dataType) {
        Matcher matcher = pattern.matcher(orgStr);
        String matchedStr = null;
        while (matcher.find()) {
            matchedStr = matcher.group();
            String maskedStr = "";
            switch (dataType) {
                case LONG_ID_NUM: 
                case SHORT_ID_NUM: {
                    maskedStr = DataSecurityUtils.maskDigitNum(matchedStr, 1, 1);
                    break;
                }
                case PASSPORT_NUM: 
                case OFFICER_NUM: {
                    maskedStr = DataSecurityUtils.maskDigitInText(matchedStr, 1, 1);
                    break;
                }
                case CN_MOBILE_NUM: {
                    maskedStr = DataSecurityUtils.maskCNMobileNum(matchedStr);
                    break;
                }
                case HK_MOBILE_NUM: {
                    maskedStr = DataSecurityUtils.maskHKMobileNum(matchedStr);
                    break;
                }
                case TW_MOBILE_NUM: {
                    maskedStr = DataSecurityUtils.maskTWMobileNum(matchedStr);
                    break;
                }
                case OTHER_PHONE_NUM: {
                    maskedStr = DataSecurityUtils.maskOtherPhoneNum(matchedStr);
                    break;
                }
                case ENT_REG_NUM: {
                    maskedStr = DataSecurityUtils.maskDigitNum(matchedStr, 1, 1);
                    break;
                }
                case MAIL: {
                    maskedStr = DataSecurityUtils.maskMail(matchedStr);
                    break;
                }
            }
            if (!StringUtils.isNotEmpty((String)maskedStr)) continue;
            orgStr = orgStr.replace(matchedStr, maskedStr);
        }
        return orgStr;
    }

    private static String maskOtherPhoneNum(String text) {
        Pattern p = Pattern.compile("\\d{6,14}");
        Matcher m = p.matcher(text);
        String digit = null;
        String maskedText = text;
        while (m.find()) {
            digit = m.group();
            if (!StringUtils.isNotEmpty((String)digit)) continue;
            String maskedDigit = DataSecurityUtils.maskDigitNum(digit, 0, 4);
            maskedText = maskedText.replace(digit, maskedDigit);
        }
        return maskedText;
    }

    private static String maskTWMobileNum(String text) {
        Pattern p = Pattern.compile("9\\d{8}");
        Matcher m = p.matcher(text);
        String digit = null;
        String maskedText = text;
        while (m.find()) {
            digit = m.group();
            if (!StringUtils.isNotEmpty((String)digit)) continue;
            String maskedDigit = DataSecurityUtils.maskDigitNum(digit, 2, 3);
            maskedText = maskedText.replace(digit, maskedDigit);
        }
        return maskedText;
    }

    private static String maskHKMobileNum(String text) {
        Pattern p = Pattern.compile("(5|6|8|9)\\d{7}");
        Matcher m = p.matcher(text);
        String digit = null;
        String maskedText = text;
        while (m.find()) {
            digit = m.group();
            if (!StringUtils.isNotEmpty((String)digit)) continue;
            String maskedDigit = DataSecurityUtils.maskDigitNum(digit, 2, 2);
            maskedText = maskedText.replace(digit, maskedDigit);
        }
        return maskedText;
    }

    private static String maskCNMobileNum(String text) {
        Pattern p = Pattern.compile("1(3|4|5|7|8)\\d{9}");
        Matcher m = p.matcher(text);
        String digit = null;
        String maskedText = text;
        while (m.find()) {
            digit = m.group();
            if (!StringUtils.isNotEmpty((String)digit)) continue;
            String maskedDigit = DataSecurityUtils.maskDigitNum(digit, 3, 4);
            maskedText = maskedText.replace(digit, maskedDigit);
        }
        return maskedText;
    }

    private static String maskDigitInText(String text, int prefixLen, int suffixLen) {
        Pattern p = Pattern.compile("\\d+");
        Matcher m = p.matcher(text);
        String digit = null;
        String maskedText = text;
        while (m.find()) {
            digit = m.group();
            if (!StringUtils.isNotEmpty((String)digit)) continue;
            String maskedDigit = DataSecurityUtils.maskDigitNum(digit, prefixLen, suffixLen);
            maskedText = maskedText.replace(digit, maskedDigit);
        }
        return maskedText;
    }

    private static String maskDigitNum(String digit, int prefixLen, int suffixLen) {
        int len = digit.length();
        StringBuilder maskedId = new StringBuilder();
        maskedId.append(digit.substring(0, prefixLen));
        for (int i = 0; i < len - (prefixLen + suffixLen); ++i) {
            maskedId.append("*");
        }
        maskedId.append(digit.substring(len - suffixLen, len));
        return maskedId.toString();
    }

    private static String maskMail(String mail) {
        String[] mailParts = mail.split("@");
        if (mailParts.length != 2) {
            return mail;
        }
        StringBuilder maskedMail = new StringBuilder();
        if (mailParts[0].length() <= 3) {
            maskedMail.append(mailParts[0]);
        } else {
            maskedMail.append(mailParts[0].substring(0, 3));
        }
        maskedMail.append("*@");
        String[] domainParts = mailParts[1].split("\\.");
        if (domainParts[0].length() <= 7) {
            maskedMail.append(domainParts[0]);
            maskedMail.append(".*");
        } else {
            maskedMail.append(domainParts[0].substring(0, 7));
            maskedMail.append("*");
        }
        return maskedMail.toString();
    }

    static {
        mapDataType2Pattern.put(DataType.MAIL, patternMail);
        mapDataType2Pattern.put(DataType.OFFICER_NUM, patternOfficerNum);
        mapDataType2Pattern.put(DataType.PASSPORT_NUM, patternPassportNum);
        mapDataType2Pattern.put(DataType.LONG_ID_NUM, patternLongIdNum);
        mapDataType2Pattern.put(DataType.SHORT_ID_NUM, patternShortIdNum);
        mapDataType2Pattern.put(DataType.ENT_REG_NUM, patternEntpriseRegNum);
        mapDataType2Pattern.put(DataType.CN_MOBILE_NUM, patternCNMobileNum);
        mapDataType2Pattern.put(DataType.TW_MOBILE_NUM, patternTWMobileNum);
        mapDataType2Pattern.put(DataType.HK_MOBILE_NUM, patternHKMobileNum);
        mapDataType2Pattern.put(DataType.OTHER_PHONE_NUM, patternOtherPhoneNum);
    }

    private static enum DataType {
        LONG_ID_NUM,
        SHORT_ID_NUM,
        PASSPORT_NUM,
        OFFICER_NUM,
        CN_MOBILE_NUM,
        HK_MOBILE_NUM,
        TW_MOBILE_NUM,
        OTHER_PHONE_NUM,
        ENT_REG_NUM,
        MAIL;

    }
}

