/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kelude.aps.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fasttext.sec.url.URIEncoder;
import com.taobao.kelude.aps.feedback.enums.OsType;
import com.taobao.kelude.aps.feedback.model.BrowserInfo;
import com.taobao.kelude.aps.feedback.model.OsInfo;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicClientConnectionManager;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.mozilla.universalchardet.UniversalDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static Logger log = LoggerFactory.getLogger(HttpUtils.class);
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final int testCount = 3;
    private static final int PERMIT_REQUEST_NUMBER = 15;
    public static Semaphore requestSemaphore = new Semaphore(15, true);
    private static DefaultHttpClient localClient = new DefaultHttpClient((ClientConnectionManager)new PoolingClientConnectionManager());
    private static final Pattern ALIAPP_PATTERN;
    private static final Pattern RESOLUTION_PATTERN;
    private static final Pattern VERSION_PATTERN;
    private static Pattern ptnRawDeviceInfo;
    private static Pattern ptnDeviceModel;
    private static TrustManager truseAllManager;

    private HttpUtils() {
    }

    public static String requestHttpNew(DefaultHttpClient client, String url, String host, String refer, boolean clearCookie) {
        String result = HttpUtils.dealeQuestHttp(client, url, host, refer, clearCookie);
        if (result == null) {
            for (int count = 1; count < 3; ++count) {
                result = HttpUtils.dealeQuestHttp(client, url, host, refer, clearCookie);
                if (result == null) continue;
                log.info("requestHttp test OK:" + count);
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File download(File file, String url) {
        if (null == file || StringUtils.isEmpty((String)url)) {
            return null;
        }
        byte[] buffer = new byte[8192];
        URLConnection connection = null;
        try {
            URL u = new URL(url);
            connection = u.openConnection();
        }
        catch (Exception e) {
            log.error("download error:" + url);
            return null;
        }
        connection.setReadTimeout(100000);
        InputStream is = null;
        FileOutputStream fos = null;
        try {
            file.createNewFile();
            is = connection.getInputStream();
            fos = new FileOutputStream(file);
            int len = 0;
            while ((len = is.read(buffer)) != -1) {
                fos.write(buffer, 0, len);
            }
        }
        catch (Exception e) {
            file.delete();
            File file2 = null;
            return file2;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        buffer = null;
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String dealeQuestHttp(DefaultHttpClient client, String url, String host, String refer, boolean clearCookie) {
        InputStream inputStream;
        if (clearCookie) {
            client.getCookieStore().clear();
        }
        HttpGet get = HttpUtils.newHttpGet(url, host, refer);
        ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
        try {
            CloseableHttpResponse response = client.execute((HttpUriRequest)get);
            if (response.getStatusLine().getStatusCode() != 200) {
                String string = null;
                return string;
            }
            inputStream = response.getEntity().getContent();
            if (inputStream != null) {
                byte[] buff = new byte[100];
                int rc = 0;
                Header flaggzip = response.getEntity().getContentEncoding();
                if (flaggzip != null && flaggzip.getName() != null && flaggzip.getName().toLowerCase().equals("content-encoding") && flaggzip.getValue() != null && flaggzip.getValue().toLowerCase().indexOf("gzip") >= 0) {
                    GZIPInputStream gzip = new GZIPInputStream(inputStream);
                    if (gzip != null) {
                        while ((rc = gzip.read(buff, 0, 100)) > 0) {
                            swapStream.write(buff, 0, rc);
                        }
                    }
                    gzip.close();
                } else {
                    while ((rc = inputStream.read(buff, 0, 100)) > 0) {
                        swapStream.write(buff, 0, rc);
                    }
                }
                byte[] in2b = swapStream.toByteArray();
                swapStream.close();
                String string = new String(in2b, HttpUtils.getEncoding(in2b));
                return string;
            }
            String buff = null;
            return buff;
        }
        catch (NoHttpResponseException e) {
            log.error("dealeQuestHttp NoHttpResponseException", (Throwable)e);
            inputStream = null;
            return inputStream;
        }
        catch (SocketTimeoutException e) {
            log.error("dealeQuestHttp SocketTimeoutException", (Throwable)e);
            inputStream = null;
            return inputStream;
        }
        catch (Exception e) {
            if ("java.io.EOFException".equals(e.toString())) {
                byte[] in2b = swapStream.toByteArray();
                try {
                    swapStream.close();
                    String buff = new String(in2b, HttpUtils.getEncoding(in2b));
                    return buff;
                }
                catch (Exception e1) {
                    log.error("dealeQuestHttp UnsupportedEncodingException", (Throwable)e);
                    String string = null;
                    return string;
                }
            }
            log.error("dealeQuestHttp Exception", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            get.releaseConnection();
        }
    }

    private static String getEncoding(byte[] in2b) throws UnsupportedEncodingException {
        UniversalDetector detector = new UniversalDetector(null);
        detector.handleData(in2b, 0, in2b.length);
        detector.dataEnd();
        String encoding = detector.getDetectedCharset();
        detector.reset();
        if (encoding == null) {
            String tmp;
            Pattern ENCODING = Pattern.compile("<meta.+?charset=[^\\w]?([-\\w]+)", 2);
            Matcher m = ENCODING.matcher(new String(in2b, DEFAULT_ENCODING));
            encoding = m.find() ? ((tmp = m.group(1)).toLowerCase().equals("gb2312") ? "gb2312" : (tmp.toLowerCase().equals("gbk") ? "gbk" : (tmp.toLowerCase().equals("utf-8") ? "utf-8" : (tmp.toLowerCase().equals("ascii") ? "ascii" : (tmp.toLowerCase().equals("iso-8859-1") ? "iso-8859-1" : "gbk"))))) : DEFAULT_ENCODING;
        }
        return encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String requestHttp(DefaultHttpClient client, String url, String host, String refer, boolean clearCookie) {
        HttpGet get;
        if (clearCookie) {
            client.getCookieStore().clear();
        }
        if ((get = HttpUtils.newHttpGet(url, host, refer)) == null) {
            return null;
        }
        try {
            CloseableHttpResponse response;
            block16: {
                response = null;
                requestSemaphore.acquire();
                try {
                    response = client.execute((HttpUriRequest)get);
                    if (response != null && response.getStatusLine().getStatusCode() == 200) break block16;
                    String string = null;
                    requestSemaphore.release();
                    return string;
                }
                catch (Throwable throwable) {
                    try {
                        requestSemaphore.release();
                        throw throwable;
                    }
                    catch (NoHttpResponseException e) {
                        log.error("No response " + url);
                        String string = HttpUtils.doLocalHttpRepeat(get, url);
                        return string;
                    }
                    catch (SocketTimeoutException e) {
                        log.error("Timeout request " + url);
                        String string = HttpUtils.doLocalHttpRepeat(get, url);
                        return string;
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                        String string = HttpUtils.doLocalHttpRepeat(get, url);
                        return string;
                    }
                }
            }
            String string = EntityUtils.toString((HttpEntity)response.getEntity(), (String)DEFAULT_ENCODING);
            requestSemaphore.release();
            return string;
        }
        finally {
            get.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String requestHttpSimple(DefaultHttpClient client, String url) {
        if (url == null) {
            return null;
        }
        HttpGet get = new HttpGet(url);
        try {
            CloseableHttpResponse response;
            block15: {
                response = null;
                requestSemaphore.acquire();
                try {
                    response = client.execute((HttpUriRequest)get);
                    if (response != null && response.getStatusLine().getStatusCode() == 200) break block15;
                    String string = null;
                    requestSemaphore.release();
                    return string;
                }
                catch (Throwable throwable) {
                    try {
                        requestSemaphore.release();
                        throw throwable;
                    }
                    catch (NoHttpResponseException e) {
                        log.error("No response " + url);
                        String string = HttpUtils.doLocalHttpRepeat(get, url);
                        return string;
                    }
                    catch (SocketTimeoutException e) {
                        log.error("Timeout request " + url);
                        String string = HttpUtils.doLocalHttpRepeat(get, url);
                        return string;
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                        String string = HttpUtils.doLocalHttpRepeat(get, url);
                        return string;
                    }
                }
            }
            String string = EntityUtils.toString((HttpEntity)response.getEntity(), (String)DEFAULT_ENCODING);
            requestSemaphore.release();
            return string;
        }
        finally {
            get.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doLocalHttpRepeat(HttpGet get, String url) {
        CloseableHttpResponse response = null;
        try {
            int start = url.indexOf("://");
            if (start < 0) {
                return null;
            }
            int end = url.indexOf("/", start += 3);
            if (end < 0) {
                return null;
            }
            String mutex = url.substring(start, end + 1).trim();
            String string = mutex.intern();
            synchronized (string) {
                response = localClient.execute((HttpUriRequest)get);
                if (response == null || response.getStatusLine().getStatusCode() != 200) {
                    return null;
                }
                return EntityUtils.toString((HttpEntity)response.getEntity(), (String)DEFAULT_ENCODING);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static HttpGet newHttpGet(String url, String host, String refer) {
        if (url == null) {
            return null;
        }
        HttpGet get = new HttpGet(url);
        get.setHeader("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8");
        get.setHeader("Accept-Language", "zh-CN,zh;q=0.8");
        get.setHeader("Connection", "keep-alive");
        if (host != null) {
            get.setHeader("Host", host);
        }
        if (refer != null) {
            get.setHeader("Referer", refer);
        }
        get.setHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/35.0.1916.153 Safari/537.36");
        return get;
    }

    public static HttpPost newHttpPost(String url, String host, String refer) {
        HttpPost post = new HttpPost(url);
        post.setHeader("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8");
        post.setHeader("Accept-Language", "zh-CN,zh;q=0.8");
        post.setHeader("Connection", "keep-alive");
        post.setHeader("Content-Type", "application/x-www-form-urlencoded");
        post.setHeader("Host", host);
        post.setHeader("Referer", refer);
        post.setHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/35.0.1916.153 Safari/537.36");
        return post;
    }

    public static Map<String, String> parseHttpUrl(String url) {
        String[] params;
        String[] args = url.split("\\?");
        if (args.length < 2) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("ROOT", args[0]);
        for (String param : params = args[1].split("&")) {
            String[] tags = param.split("=");
            result.put(tags[0].trim(), tags[1].trim());
        }
        return result;
    }

    public static String parseUrlAction(String url) {
        int end = url.indexOf("?");
        end = end == -1 ? url.length() : end;
        int index = url.lastIndexOf("/", end);
        return url.substring(index + 1, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getResponseAsString(String url, Map<String, Object> params) {
        String result = "";
        HttpClient httpClient = new HttpClient();
        httpClient.setTimeout(20000);
        httpClient.setConnectionTimeout(2000);
        PostMethod postMethod = new PostMethod(url);
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            Object object = entry.getValue();
            if (object == null) {
                postMethod.addParameter(entry.getKey(), "");
                continue;
            }
            postMethod.addParameter(entry.getKey(), entry.getValue().toString());
        }
        try {
            postMethod.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
            httpClient.executeMethod((HttpMethod)postMethod);
            result = postMethod.getResponseBodyAsString();
        }
        catch (Exception e) {
            log.info("getResponseAsString failed!" + e.getMessage(), (Throwable)e);
        }
        finally {
            postMethod.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendGetRequest(String url) {
        String result = "";
        HttpClient httpClient = new HttpClient();
        httpClient.setTimeout(20000);
        httpClient.setConnectionTimeout(2000);
        GetMethod getMethod = new GetMethod(URIEncoder.encodeURI((String)url));
        try {
            getMethod.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
            httpClient.executeMethod((HttpMethod)getMethod);
            result = getMethod.getResponseBodyAsString();
        }
        catch (Exception e) {
        }
        finally {
            getMethod.releaseConnection();
        }
        return result;
    }

    public static BrowserInfo getBrowserInfoFromUserAgent(String userAgent) throws StringIndexOutOfBoundsException {
        BrowserInfo browInfo = new BrowserInfo();
        if (StringUtils.isNotEmpty((String)userAgent)) {
            String ua = userAgent.toLowerCase();
            int occurIndex = -1;
            String temp = null;
            occurIndex = ua.indexOf("chrome/");
            if (occurIndex > -1) {
                browInfo.setBrowserType("Chrome");
                temp = ua.substring(occurIndex + "chrome/".length());
                browInfo.setBrowserVersion(temp.substring(0, temp.indexOf(" ")));
            } else {
                occurIndex = ua.indexOf("msie ");
                if (occurIndex > -1) {
                    browInfo.setBrowserType("IE");
                    temp = ua.substring(occurIndex + "msie ".length());
                    browInfo.setBrowserVersion(temp.substring(0, temp.indexOf(";")));
                } else {
                    occurIndex = ua.indexOf("ucbrowser/");
                    if (occurIndex > -1) {
                        browInfo.setBrowserType("UCBrowser");
                        temp = ua.substring(occurIndex + "ucbrowser/".length());
                        int endIndex = temp.indexOf(" ");
                        browInfo.setBrowserVersion(temp.substring(0, -1 == endIndex ? temp.length() : endIndex));
                    } else {
                        occurIndex = ua.indexOf("mqqbrowser/");
                        if (occurIndex > -1) {
                            browInfo.setBrowserType("MQQBrowser");
                            temp = ua.substring(occurIndex + "mqqbrowser/".length());
                            browInfo.setBrowserVersion(temp.substring(0, temp.indexOf(" ")));
                        } else {
                            occurIndex = ua.indexOf("applewebkit/");
                            if (occurIndex > -1) {
                                occurIndex = ua.indexOf("safari/");
                                if (occurIndex > -1) {
                                    browInfo.setBrowserType("Safari");
                                    temp = ua.substring(ua.indexOf("version/") + "version/".length());
                                    browInfo.setBrowserVersion(temp.substring(0, temp.indexOf(" ")));
                                } else {
                                    occurIndex = ua.indexOf("mobile/");
                                    if (occurIndex > -1) {
                                        browInfo.setBrowserType("AppleMobile");
                                        temp = ua.substring(ua.indexOf("applewebkit/") + "applewebkit/".length());
                                        browInfo.setBrowserVersion(temp.substring(0, temp.indexOf(" ")));
                                    }
                                }
                            } else {
                                occurIndex = ua.indexOf("firefox/");
                                if (occurIndex > -1) {
                                    browInfo.setBrowserType("Firefox");
                                    temp = ua.substring(occurIndex + "firefox/".length());
                                    browInfo.setBrowserVersion(temp.trim());
                                } else {
                                    occurIndex = ua.indexOf("opera/");
                                    if (occurIndex > -1) {
                                        browInfo.setBrowserType("Opera");
                                        temp = ua.substring(occurIndex + "opera/".length());
                                        browInfo.setBrowserVersion(temp.substring(0, temp.indexOf(" ")));
                                    } else {
                                        occurIndex = ua.indexOf("mtopsdk/");
                                        if (occurIndex > -1) {
                                            occurIndex = ua.indexOf("iphone os;");
                                            if (occurIndex > -1) {
                                                browInfo.setBrowserType("AppleMobile");
                                            } else {
                                                occurIndex = ua.indexOf("android;");
                                                if (occurIndex > -1) {
                                                    // empty if block
                                                }
                                            }
                                        } else {
                                            browInfo.setBrowserType("Unknown");
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return browInfo;
    }

    public static OsInfo getOsInfoFromUserAgent(String userAgent) throws StringIndexOutOfBoundsException {
        OsInfo osInfo = new OsInfo();
        if (StringUtils.isEmpty((String)userAgent)) {
            return osInfo;
        }
        String ua = userAgent.toLowerCase();
        int occurIndex = -1;
        String temp = null;
        occurIndex = ua.indexOf("windows");
        if (occurIndex > -1) {
            osInfo.setOsType(OsType.WIN.getKey());
            temp = ua.substring(occurIndex + "windows ".length(), occurIndex + "windows ".length() + 8);
            osInfo.setOsVersion(HttpUtils.findVersionNum(temp));
        } else {
            occurIndex = ua.indexOf("iphone;");
            if (occurIndex > -1 || (occurIndex = ua.indexOf("ipad;")) > -1) {
                osInfo.setOsType(OsType.IOS.getKey());
                int startIndex = ua.indexOf("os ");
                temp = ua.substring(startIndex + "os ".length(), startIndex + "os ".length() + 10);
                osInfo.setOsVersion(HttpUtils.findVersionNum(temp));
            } else {
                occurIndex = ua.indexOf("android");
                if (occurIndex > -1) {
                    osInfo.setOsType(OsType.ANDROID.getKey());
                    temp = ua.substring(occurIndex + "android".length(), occurIndex + "android".length() + 10);
                    osInfo.setOsVersion(HttpUtils.findVersionNum(temp));
                } else {
                    occurIndex = ua.indexOf("macintosh;");
                    if (occurIndex > -1) {
                        osInfo.setOsType(OsType.MAC.getKey());
                        int startIndex = ua.indexOf("mac os ");
                        temp = ua.substring(startIndex + "mac os ".length(), startIndex + "mac os ".length() + 12);
                        osInfo.setOsVersion(HttpUtils.findVersionNum(temp));
                    } else {
                        occurIndex = ua.indexOf("linux");
                        if (occurIndex > -1) {
                            osInfo.setOsType(OsType.LINUX.getKey());
                        } else {
                            occurIndex = ua.indexOf("mtopsdk/");
                            if (occurIndex > -1) {
                                occurIndex = ua.indexOf("iphone os;");
                                if (occurIndex > -1) {
                                    osInfo.setOsType(OsType.IOS.getKey());
                                    temp = ua.substring(occurIndex + "iphone os;".length());
                                    osInfo.setOsVersion(temp.substring(0, temp.indexOf(";")));
                                } else {
                                    occurIndex = ua.indexOf("android;");
                                    if (occurIndex > -1) {
                                        // empty if block
                                    }
                                }
                            } else {
                                osInfo.setOsType(OsType.UNKNOWN.getKey());
                            }
                        }
                    }
                }
            }
        }
        return osInfo;
    }

    public static String getAppVersionFromUserAgent(String userAgent) {
        Matcher m;
        if (StringUtils.isNotEmpty((String)userAgent) && (m = ALIAPP_PATTERN.matcher(userAgent)).find()) {
            String rawAppVer = m.group().trim();
            return rawAppVer.substring(rawAppVer.indexOf("/") + 1, rawAppVer.indexOf(")")).trim();
        }
        return null;
    }

    public static String getDeviceResolutionFromUserAgent(String userAgent) {
        Matcher m;
        if (StringUtils.isNotEmpty((String)userAgent) && (m = RESOLUTION_PATTERN.matcher(userAgent)).find()) {
            return m.group().trim();
        }
        return null;
    }

    private static String findVersionNum(String input) {
        if (StringUtils.isEmpty((String)input)) {
            return null;
        }
        Matcher m = VERSION_PATTERN.matcher(input);
        if (m.find()) {
            String verNum = m.group();
            return verNum.replace("_", ".");
        }
        return null;
    }

    public static String getDeviceModelFromUserAgent(String userAgent) {
        String deviceInfo;
        Matcher dvMatcher;
        if (StringUtils.isEmpty((String)userAgent)) {
            return null;
        }
        Matcher uaMatcher = ptnRawDeviceInfo.matcher(userAgent);
        if (uaMatcher.find() && (dvMatcher = ptnDeviceModel.matcher(deviceInfo = uaMatcher.group().trim())).find()) {
            String dv = dvMatcher.group().trim();
            return dv.substring(0, dv.indexOf(" "));
        }
        return null;
    }

    public static Map<String, String> getQueryMap(String query) {
        String[] params = query.split("&");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String param : params) {
            String name = param.split("=")[0];
            String value = param.split("=")[1];
            map.put(name, value);
        }
        return map;
    }

    public static DefaultHttpClient createHttpClient(boolean connPool, boolean ssl) {
        DefaultHttpClient httpclient = null;
        httpclient = connPool ? new DefaultHttpClient((ClientConnectionManager)new PoolingClientConnectionManager()) : new DefaultHttpClient((ClientConnectionManager)new BasicClientConnectionManager());
        if (ssl) {
            HttpUtils.enableHttpClientSSL(httpclient);
        }
        return httpclient;
    }

    public static void enableHttpClientSSL(DefaultHttpClient httpclient) {
        try {
            SSLContext sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(null, new TrustManager[]{truseAllManager}, null);
            SSLSocketFactory sf = new SSLSocketFactory(sslcontext, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            Scheme https = new Scheme("https", 443, (SchemeSocketFactory)sf);
            httpclient.getConnectionManager().getSchemeRegistry().register(https);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postJsonData(String url, Map<String, Object> params) {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        httpClient.getParams().setParameter("http.connection.timeout", (Object)2000);
        httpClient.getParams().setParameter("http.socket.timeout", (Object)5000);
        HttpPost method = new HttpPost(url);
        StringEntity entity = null;
        try {
            entity = new StringEntity(JSON.toJSONString(params), "utf-8");
            entity.setContentEncoding(DEFAULT_ENCODING);
            entity.setContentType("application/json");
            method.setEntity((HttpEntity)entity);
            CloseableHttpResponse resp = httpClient.execute((HttpUriRequest)method);
            int status = resp.getStatusLine().getStatusCode();
            if (status == 200) {
                String string = EntityUtils.toString((HttpEntity)resp.getEntity());
                return string;
            }
            log.error("post failed, status code:" + status);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            method.releaseConnection();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String requestHttpGet(CloseableHttpClient client, String url, String domain) throws Exception {
        HttpGet get = new HttpGet(url);
        get.addHeader("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8");
        get.addHeader("Accept-Language", "zh-CN,zh;q=0.8");
        get.addHeader("Cache-Control", "max-age=0");
        get.addHeader("Connection", "keep-alive");
        get.addHeader("Host", domain);
        get.addHeader("Referer", url);
        get.addHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.116 Safari/537.36");
        try {
            CloseableHttpResponse response = client.execute((HttpUriRequest)get);
            if (response.getStatusLine().getStatusCode() == 200) {
                String string = EntityUtils.toString((HttpEntity)response.getEntity(), (String)DEFAULT_ENCODING);
                return string;
            }
            log.error("request http get response:" + response.getStatusLine());
        }
        finally {
            get.releaseConnection();
        }
        return null;
    }

    public static HttpGet buildHttpGet(CloseableHttpClient client, String url, String domain) {
        HttpGet get = new HttpGet(url);
        get.addHeader("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8");
        get.addHeader("Cache-Control", "max-age=0");
        get.addHeader("Connection", "keep-alive");
        get.addHeader("Host", domain);
        get.addHeader("Referer", url);
        get.addHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.116 Safari/537.36");
        return get;
    }

    public static CloseableHttpClient buildHttpClient(String proxyHost, int proxyPort, int timeout) {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        RequestConfig reqConfig = RequestConfig.custom().setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).setSocketTimeout(timeout).build();
        httpClientBuilder.setDefaultRequestConfig(reqConfig);
        if (proxyHost != null) {
            HttpHost proxy = new HttpHost(proxyHost, proxyPort);
            httpClientBuilder.setProxy(proxy);
        }
        return httpClientBuilder.build();
    }

    public static String getResponseStreamAsString(InputStream inputStream, Boolean isGzip, String htmlCode) throws IOException {
        ByteArrayOutputStream byteArrayOutPutStream = new ByteArrayOutputStream();
        try {
            if (inputStream != null) {
                byte[] buff = new byte[1024];
                int rc = 0;
                if (isGzip.booleanValue()) {
                    GZIPInputStream gzipInputStream = new GZIPInputStream(inputStream);
                    if (gzipInputStream != null) {
                        while ((rc = gzipInputStream.read(buff)) > 0) {
                            byteArrayOutPutStream.write(buff, 0, rc);
                        }
                        gzipInputStream.close();
                        inputStream.close();
                    }
                } else {
                    while ((rc = inputStream.read(buff)) > 0) {
                        byteArrayOutPutStream.write(buff, 0, rc);
                    }
                    inputStream.close();
                }
                byte[] in2b = byteArrayOutPutStream.toByteArray();
                byteArrayOutPutStream.close();
                if (!StringUtils.isBlank((String)htmlCode)) {
                    return new String(in2b, htmlCode);
                }
                return new String(in2b, HttpUtils.getEncoding(in2b));
            }
            log.error("fail to get inputstream");
            return null;
        }
        catch (Exception e) {
            byte[] in2b = byteArrayOutPutStream.toByteArray();
            byteArrayOutPutStream.close();
            if (!StringUtils.isBlank((String)htmlCode)) {
                return new String(in2b, htmlCode);
            }
            return new String(in2b, HttpUtils.getEncoding(in2b));
        }
    }

    static {
        localClient.getParams().setParameter("http.connection.timeout", (Object)5000);
        localClient.getParams().setParameter("http.socket.timeout", (Object)5000);
        ALIAPP_PATTERN = Pattern.compile("\\sAliApp\\([\\w\\W]+/[\\w\\.]{3,}\\)\\s");
        RESOLUTION_PATTERN = Pattern.compile("\\s\\d{3,4}(\\*|X|x)\\d{3,4}(\\s|$)");
        VERSION_PATTERN = Pattern.compile("\\d+((_|\\.)\\d+)+");
        ptnRawDeviceInfo = Pattern.compile("\\s\\([\\p{Graph}\\s]+\\)\\s");
        ptnDeviceModel = Pattern.compile("\\s\\p{Graph}+\\sBuild/");
        truseAllManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
    }
}

