/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kelude.aps.utils;

import com.alibaba.fastjson.JSONObject;
import com.taobao.kelude.aps.feedback.model.UserLocation;
import com.taobao.kelude.aps.utils.HttpUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class IpUtils {
    private static final String GET_IPINFO_URL = "http://pf.ip.alibaba-inc.com/getipinfo?ip=";
    private static Pattern ipPattern = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");

    private IpUtils() {
    }

    public static String getNetworkOperator(String ip) {
        if (StringUtils.isEmpty((String)ip)) {
            return null;
        }
        String resp = HttpUtils.sendGetRequest(GET_IPINFO_URL + ip + "&lang=cn");
        JSONObject ipInfo = JSONObject.parseObject((String)resp);
        if (null == ipInfo) {
            return null;
        }
        return ipInfo.getString("isp");
    }

    public static UserLocation getUserLocation(String ip) {
        if (StringUtils.isEmpty((String)ip)) {
            return null;
        }
        String resp = HttpUtils.sendGetRequest(GET_IPINFO_URL + ip + "&lang=cn");
        if (!resp.startsWith("{") && !resp.startsWith("\r\n{")) {
            return null;
        }
        JSONObject ipInfo = JSONObject.parseObject((String)resp);
        if (null == ipInfo) {
            return null;
        }
        UserLocation userLocation = new UserLocation();
        userLocation.setIp(ip);
        userLocation.setProvince(ipInfo.getString("region"));
        userLocation.setCity(ipInfo.getString("city"));
        userLocation.setOperator(ipInfo.getString("isp"));
        return userLocation;
    }

    public static String getRequestIp(HttpServletRequest request) {
        String requestIp = request.getHeader("x-forwarded-for");
        requestIp = StringUtils.isEmpty((String)requestIp) ? request.getRemoteAddr() : requestIp.split(",")[0];
        return requestIp;
    }

    public static boolean isValidIp(String ipAddr) {
        Matcher matcher = ipPattern.matcher(ipAddr);
        return matcher.matches();
    }
}

