/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kelude.aps.utils;

import com.taobao.kelude.aps.security.model.SecurityBean;
import com.taobao.kelude.common.Result;
import com.taobao.kelude.common.util.Md5Utils;
import org.apache.commons.lang.StringUtils;

public class SecurityUtils {
    public static String bytes2Hex(byte[] bts) {
        String des = "";
        String tmp = null;
        for (int i = 0; i < bts.length; ++i) {
            tmp = Integer.toHexString(bts[i] & 0xFF);
            if (tmp.length() == 1) {
                des = des + "0";
            }
            des = des + tmp;
        }
        return des;
    }

    public static Result<Boolean> checkAuth(SecurityBean user, Long timestamp, String token) {
        Result result = new Result();
        Integer appId = user.getAppId();
        if (user == null || user.getAppId() == null || StringUtils.isBlank((String)user.getUserSkey()) || appId == null || StringUtils.isBlank((String)token) || timestamp == null) {
            result.addFailureMessage("no parameter or parameter error!");
            result.setResult((Object)false);
            return result;
        }
        String realToken = SecurityUtils.buildToken(user.getUserSkey(), timestamp, user.getAppId());
        if (!token.equals(realToken)) {
            result.addFailureMessage("no permission!");
            result.setResult((Object)false);
            return result;
        }
        return result;
    }

    public static String buildToken(String userSkey, Long timestamp, Integer appid) {
        StringBuilder userKey = new StringBuilder("");
        userKey.append(userSkey);
        userKey.append(timestamp);
        userKey.append("aps");
        userKey.append(appid);
        return Md5Utils.encode((byte[])userKey.toString().getBytes());
    }
}

