/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kelude.aps.utils;

import com.alibaba.fastjson.JSONArray;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringUtils
extends org.apache.commons.lang.StringUtils {
    private static Logger log = LoggerFactory.getLogger(StringUtils.class);
    static Pattern htmlPattern = Pattern.compile("<([^>]*)>");

    public static String filterNotUtf8(String text) {
        try {
            text = text.replaceAll("\u0000+", "");
            byte[] bytes = text.getBytes("utf-8");
            ByteBuffer buffer = ByteBuffer.allocate(bytes.length);
            int i = 0;
            while (i < bytes.length) {
                short b = bytes[i];
                if (b > 0) {
                    buffer.put(bytes[i++]);
                    continue;
                }
                if (((b = (short)(b + 256)) ^ 0xC0) >> 4 == 0) {
                    buffer.put(bytes, i, 2);
                    i += 2;
                    continue;
                }
                if ((b ^ 0xE0) >> 4 == 0) {
                    buffer.put(bytes, i, 3);
                    i += 3;
                    continue;
                }
                if ((b ^ 0xF0) >> 4 == 0) {
                    i += 4;
                    continue;
                }
                ++i;
            }
            buffer.flip();
            String ret = new String(buffer.array(), "utf-8");
            return ret.replaceAll("\u0000+", "");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return text;
        }
    }

    public static String filterNotUtf8(ByteBuffer buffer) {
        CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPLACE);
        decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        CharBuffer parsed = null;
        try {
            parsed = decoder.decode(buffer);
        }
        catch (CharacterCodingException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (parsed != null) {
            return parsed.toString();
        }
        return "";
    }

    public static int getNumberByString(String s, int index) {
        char ch;
        StringBuilder buf = new StringBuilder();
        int len = s.length();
        for (int i = index; i < len && '0' <= (ch = s.charAt(i)) && ch <= '9'; ++i) {
            buf.append(ch);
        }
        String tmp = buf.toString().trim();
        if ("".equals(tmp)) {
            return 0;
        }
        return Integer.parseInt(tmp);
    }

    public static String filterHtml(String source) {
        String regExHtml = "<[^>]+>";
        Pattern pattern = Pattern.compile(regExHtml, 2);
        Matcher matcher = pattern.matcher(source);
        String result = matcher.replaceAll("");
        result = result.replace("&nbsp;", " ").replace("&#160;", " ");
        return result.trim();
    }

    public static int getTokenNumber(String s, int defaultValue) {
        int index = s.indexOf("[");
        int end = s.indexOf("]", index);
        if (index < 0 || end < 0) {
            return defaultValue;
        }
        String tmp = s.substring(index + 1, end).trim();
        if ("".equals(tmp)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(tmp);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static long getTokenNumber(String s, long defaultValue) {
        int index = s.indexOf("[");
        int end = s.indexOf("]", index);
        if (index < 0 || end < 0) {
            return defaultValue;
        }
        String tmp = s.substring(index + 1, end).trim();
        if ("".equals(tmp)) {
            return defaultValue;
        }
        try {
            return Long.parseLong(tmp);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static String getEqualValue(String content, String key) {
        int start = content.indexOf(key);
        if (start < 0) {
            return null;
        }
        if ((start = content.indexOf("=", start + 1)) < 0) {
            return null;
        }
        int end = content.indexOf(",", start + 1);
        int end2 = content.indexOf(";", start + 1);
        if (end < 0 && end2 < 0) {
            return null;
        }
        end = end < 0 ? Integer.MAX_VALUE : end;
        end2 = end2 < 0 ? Integer.MAX_VALUE : end2;
        end = Math.min(end, end2);
        return content.substring(start + 1, end).trim();
    }

    public static int parseInt(String s, int n) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return n;
        }
    }

    public static List<Integer> splitInteger(String str, String splitStr) {
        ArrayList<Integer> intList = new ArrayList<Integer>();
        if (null != str && !"".equals(str)) {
            List<String> splitStrArray = Arrays.asList(str.split(splitStr));
            for (String s : splitStrArray) {
                try {
                    intList.add(Integer.parseInt(s));
                }
                catch (NumberFormatException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return intList;
    }

    public static String filterString(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (!StringUtils.isValid(ch)) continue;
            buf.append(ch);
        }
        return buf.toString();
    }

    private static boolean isValid(char c) {
        if (StringUtils.isChinese(c)) {
            return true;
        }
        return c >= ' ' && c < '\u007f';
    }

    private static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION;
    }

    public static boolean isChinese(String strName) {
        if (strName == null) {
            return false;
        }
        int len = strName.length();
        for (int i = 0; i < len; ++i) {
            char c = strName.charAt(i);
            if (!StringUtils.isChinese(c)) continue;
            return true;
        }
        return false;
    }

    public static String removeYearDate(String date) {
        String[] dts = date.split("-");
        if (dts.length < 3) {
            return date;
        }
        return StringUtils.bufferString(dts[1], Character.valueOf('-'), dts[2]);
    }

    public static String bufferString(Object ... objs) {
        StringBuilder buf = new StringBuilder();
        for (Object s : objs) {
            buf.append(s);
        }
        return buf.toString();
    }

    public static List<String> splitString(String s, String[] limits) {
        int index;
        int lastIndex = 0;
        ArrayList<String> result = new ArrayList<String>();
        int slen = s.length();
        block0: for (index = 0; index < slen; ++index) {
            for (String limit : limits) {
                if (slen - index < limit.length()) continue;
                boolean match = true;
                for (int i = 0; i < limit.length(); ++i) {
                    if (limit.charAt(i) == s.charAt(index + i)) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                result.add(s.substring(lastIndex, index));
                lastIndex = index + limit.length();
                continue block0;
            }
        }
        if (lastIndex < index) {
            result.add(s.substring(lastIndex, index));
        }
        return result;
    }

    public static String toCollectionString(Collection<?> c) {
        if (c == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (Object o : c) {
            buf.append(o.toString());
        }
        return buf.toString();
    }

    public static String toCollectionString(Collection<?> c, char sep) {
        if (c == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (Object o : c) {
            buf.append(o.toString()).append(sep);
        }
        if (buf.length() > 0) {
            buf.setLength(buf.length() - 1);
        }
        return buf.toString();
    }

    public static String[] toCollectionSortString(Collection<String> c1, Collection<String> c2) {
        Integer index;
        int seed = 0;
        HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
        TreeMap<Integer, String> map1 = new TreeMap<Integer, String>();
        TreeMap<Integer, String> map2 = new TreeMap<Integer, String>();
        for (String s : c1) {
            index = (Integer)indexMap.get((s = s.trim()).trim());
            if (index == null) {
                index = seed++;
                indexMap.put(s, index);
            }
            map1.put(index, s);
        }
        for (String s : c2) {
            index = (Integer)indexMap.get(s = s.trim());
            if (index == null) {
                index = seed++;
                indexMap.put(s, index);
            }
            map2.put(index, s);
        }
        return new String[]{StringUtils.toCollectionString(map1.values()), StringUtils.toCollectionString(map2.values())};
    }

    public static List<String> toList(String s, String sep) {
        if (s == null || "".equals(s)) {
            return null;
        }
        String[] args = s.split(sep);
        return Arrays.asList(args);
    }

    public static String filterContent(String content) {
        if (content == null) {
            return null;
        }
        content = StringUtils.filterHeadEN(content);
        content = StringUtils.filterYunOS(content);
        content = StringUtils.filterHtmlTags(content);
        return content.trim();
    }

    public static String filterWeibo(String content) {
        if (content == null) {
            return null;
        }
        content = content.replaceAll("/*@[^\\s^: ]+:*", "  ");
        return content;
    }

    public static String filterHeadEN(String content) {
        if (content == null) {
            return null;
        }
        content = content.replaceAll("[^\u4e00-\u9fa5\\s\\t\\n\\r\\f]{8,}", "  ");
        return content;
    }

    public static String filterYunOS(String content) {
        if (content == null) {
            return null;
        }
        if ((content = content.replaceAll(",(WIFI|3G|2G|4G),", "")).indexOf("http://") >= 0) {
            content = content.replaceAll("[http]{4}\\:\\/\\/[a-z]*(\\.[\\-a-zA-Z]*)*(\\/([a-zA-Z0-9\\-\\.])*)*\\s?", "  ");
        }
        return content;
    }

    public static String filterHtmlTags(String str) {
        if (str == null) {
            return null;
        }
        Matcher matcher = htmlPattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        boolean result1 = matcher.find();
        while (result1) {
            matcher.appendReplacement(sb, " ");
            result1 = matcher.find();
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String filterHtmlTags(String str, String sep) {
        if (str == null) {
            return null;
        }
        Matcher matcher = htmlPattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        boolean result1 = matcher.find();
        while (result1) {
            matcher.appendReplacement(sb, sep);
            result1 = matcher.find();
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String ruleRegex(String word) {
        return word.replace("\\c", "\\uFE30-\\uFFA0").replace("\\m", "\\pP\\p{Punct}").replace("\\h", "\\u4e00-\\u9fa5");
    }

    public static int getSubStringCount(String str, String sub) {
        if (null == str || "".equals(str) || null == sub || "".equals(sub)) {
            return 0;
        }
        int index = 0;
        int count = 0;
        while ((index = str.indexOf(sub, index)) != -1) {
            index += sub.length();
            ++count;
        }
        return count;
    }

    public static String truncate(String str, int len) {
        if (StringUtils.isEmpty((String)str)) {
            return "";
        }
        if (str.length() <= len) {
            return str;
        }
        return str.substring(0, len) + "...";
    }

    public static String join(List<String> strings, String separate) {
        StringBuilder sb = new StringBuilder();
        if (null != strings && strings.size() > 0) {
            for (String s : strings) {
                if (sb.length() > 0) {
                    sb.append(separate);
                }
                sb.append(s.toString());
            }
        }
        return sb.toString();
    }

    public static int endsWith(StringBuilder buf, String str) {
        int len = str.length();
        int bufLen = buf.length();
        if (bufLen < len) {
            return -1;
        }
        if (bufLen == len) {
            return buf.toString().equals(str) ? 0 : -1;
        }
        for (int i = bufLen - len; i < bufLen; ++i) {
            char bufCH = buf.charAt(i);
            char ch = str.charAt(i - bufLen + len);
            if (ch == bufCH) continue;
            return -1;
        }
        return bufLen - len;
    }

    public static List<String> changeJSONArrayToListString(JSONArray jsArray) {
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < jsArray.size(); ++i) {
            ids.add(jsArray.getString(i));
        }
        return ids;
    }

    public static List<Integer> changeJSONArrayToListInteger(JSONArray jsArray) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (int i = 0; i < jsArray.size(); ++i) {
            ids.add(jsArray.getInteger(i));
        }
        return ids;
    }

    public static String getDomain(String fullUrl) {
        URL url = null;
        try {
            url = new URL(fullUrl);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return url == null ? null : url.getHost();
    }
}

