/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kelude.aps.weibo.model;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.taobao.kelude.aps.weibo.model.MiniWeiboUser;
import com.taobao.kelude.common.BaseModel;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Analysis
extends BaseModel {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(Analysis.class);
    private static final String LOC_KEY = "\"location\":";
    private static final int LOC_KEY_LEN = "\"location\":".length();
    private static final String IMG_URL_KEY = "\"profileImageURL\":";
    private static final int IMG_URL_KEY_LEN = "\"profileImageURL\":".length();
    private static final String GENDER_KEY = "\"gender\":";
    private static final int GENDER_KEY_LEN = "\"gender\":".length();
    private Integer id;
    private Integer userId;
    private String userName;
    private String weiboUrl;
    private String uid;
    private String screenName;
    private Date pubTime;
    private String content;
    private String uInfo;
    private String wInfo;
    private Long totalFollows;
    private String simpleReport;
    private String detailReport;
    private String data;
    private String graphData;
    private Date createdAt;
    private Date updatedAt;
    private Integer productId;
    private String machineInfo;
    private String progressInfo;
    private Long repostCount;
    private String mid;
    private Long weiboId;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getUserId() {
        return this.userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getWeiboUrl() {
        return this.weiboUrl;
    }

    public void setWeiboUrl(String weiboUrl) {
        this.weiboUrl = weiboUrl;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getScreenName() {
        return this.screenName;
    }

    public void setScreenName(String screenName) {
        this.screenName = screenName;
    }

    public Date getPubTime() {
        return this.pubTime;
    }

    public void setPubTime(Date pubTime) {
        this.pubTime = pubTime;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getuInfo() {
        return this.uInfo;
    }

    public void setuInfo(String uInfo) {
        this.uInfo = uInfo;
    }

    public Long getTotalFollows() {
        return this.totalFollows;
    }

    public void setTotalFollows(Long totalFollows) {
        this.totalFollows = totalFollows;
    }

    public String getSimpleReport() {
        return this.simpleReport;
    }

    public void setSimpleReport(String simpleReport) {
        this.simpleReport = simpleReport;
    }

    public String getDetailReport() {
        return this.detailReport;
    }

    public void setDetailReport(String detailReport) {
        this.detailReport = detailReport;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getGraphData() {
        return this.graphData;
    }

    public void setGraphData(String graphData) {
        this.graphData = graphData;
    }

    public Date getCreateAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public MiniWeiboUser getMiniWeiboUser() {
        if (StringUtils.isNotEmpty((String)this.getuInfo())) {
            MiniWeiboUser user = new MiniWeiboUser();
            JSONObject jsonUser = JSON.parseObject((String)this.getuInfo());
            user.setId(jsonUser.getString("id"));
            user.setScreenName(jsonUser.getString("screenName"));
            user.setLocation(jsonUser.getString("location"));
            user.setDescription(jsonUser.getString("description"));
            user.setProfileImageUrl(jsonUser.getString("profileImageURL"));
            user.setGender(jsonUser.getString("gender"));
        }
        return null;
    }

    public static MiniWeiboUser getWeiboUserExtendedInfo(String jsonStr) {
        if (StringUtils.isNotEmpty((String)jsonStr)) {
            MiniWeiboUser user = new MiniWeiboUser();
            try {
                int startIdx;
                int endIdx;
                int keyIdx = jsonStr.indexOf(LOC_KEY);
                if (keyIdx >= 0 && (endIdx = jsonStr.indexOf("\"", startIdx = keyIdx + LOC_KEY_LEN + 1)) >= 0) {
                    user.setLocation(jsonStr.substring(startIdx, endIdx));
                }
                if ((keyIdx = jsonStr.indexOf(IMG_URL_KEY)) >= 0 && (endIdx = jsonStr.indexOf("\"", startIdx = keyIdx + IMG_URL_KEY_LEN + 1)) >= 0) {
                    user.setProfileImageUrl(jsonStr.substring(startIdx, endIdx));
                }
                if ((keyIdx = jsonStr.indexOf(GENDER_KEY)) >= 0 && (endIdx = jsonStr.indexOf("\"", startIdx = keyIdx + GENDER_KEY_LEN + 1)) >= 0) {
                    user.setGender(jsonStr.substring(startIdx, endIdx));
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            return user;
        }
        return null;
    }

    public String getwInfo() {
        return this.wInfo;
    }

    public void setwInfo(String wInfo) {
        this.wInfo = wInfo;
    }

    public Integer getProductId() {
        return this.productId;
    }

    public void setProductId(Integer productId) {
        this.productId = productId;
    }

    public String getMachineInfo() {
        return this.machineInfo;
    }

    public void setMachineInfo(String machineInfo) {
        this.machineInfo = machineInfo;
    }

    public String getProgressInfo() {
        return this.progressInfo;
    }

    public void setProgressInfo(String progressInfo) {
        this.progressInfo = progressInfo;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Long getRepostCount() {
        return this.repostCount;
    }

    public void setRepostCount(Long repostCount) {
        this.repostCount = repostCount;
    }

    public String getMid() {
        return this.mid;
    }

    public void setMid(String mid) {
        this.mid = mid;
    }

    public Long getWeiboId() {
        return this.weiboId;
    }

    public void setWeiboId(Long weiboId) {
        this.weiboId = weiboId;
    }

    public String toString() {
        return "Analysis [id=" + this.id + ", userId=" + this.userId + ", userName=" + this.userName + ", weiboUrl=" + this.weiboUrl + ", uid=" + this.uid + ", screenName=" + this.screenName + ", pubTime=" + this.pubTime + ", content=" + this.content + ", uInfo=" + this.uInfo + ", wInfo=" + this.wInfo + ", totalFollows=" + this.totalFollows + ", detailReport=" + this.detailReport + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", productId=" + this.productId + ", machineInfo=" + this.machineInfo + ", progressInfo=" + this.progressInfo + ", repostCount=" + this.repostCount + ", mid=" + this.mid + ", weiboId=" + this.weiboId + "]";
    }

    public static enum AnalysisStatus {
        INIT(100, "\u5206\u6790\u521d\u59cb\u5316"),
        GET_REPOST(110, "\u83b7\u53d6\u8f6c\u53d1\u6570\u636e"),
        STAT_INFO(120, "\u5206\u6790\u8f6c\u53d1\u6570\u636e"),
        STAT_REPOST_RELATE(130, "\u8ba1\u7b97\u8f6c\u53d1\u5173\u7cfb"),
        STAT_SPREAD_PATH(140, "\u8ba1\u7b97\u4f20\u64ad\u8def\u5f84"),
        PROC_FINISHING(150, "\u7b49\u5f85\u5206\u6790\u5b8c\u6210"),
        WAIT_PARENT_ANALYSIS(160, "\u7b49\u5f85\u4f9d\u8d56\u5206\u6790\u5b8c\u6210"),
        SUCCESS(200, "\u5206\u6790\u5b8c\u6210"),
        GET_DATA_FAILED(401, "\u8f6c\u53d1\u6570\u636e\u83b7\u53d6\u5931\u8d25"),
        STAT_FAILED(402, "\u7edf\u8ba1\u5206\u6790\u5931\u8d25"),
        ANALYSIS_FAILED(403, "\u5206\u6790\u5931\u8d25");

        int status;
        String message;

        private AnalysisStatus(int status, String message) {
            this.status = status;
            this.message = message;
        }

        public int getStatus() {
            return this.status;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

