/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kelude.aps.weibo.model;

import com.taobao.kelude.common.BaseModel;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class WeiboUserTagQuery
extends BaseModel {
    private static final long serialVersionUID = 1L;
    private Integer tag;
    private Integer needAll = 0;
    private List<String> orderingMethods = new ArrayList<String>();
    private Integer pageIndex = 1;
    private Integer pageSize = 20;

    public WeiboUserTagQuery() {
        this.orderingMethods.add("analysisCount desc");
    }

    public Integer getStartIndex() {
        return (this.pageIndex - 1) * this.pageSize;
    }

    public Integer getTag() {
        return this.tag;
    }

    public void setTag(Integer tag) {
        this.tag = tag;
    }

    public Integer getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(Integer pageIndex) {
        this.pageIndex = pageIndex;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getNeedAll() {
        return this.needAll;
    }

    public void setNeedAll(Boolean needAll) {
        this.needAll = needAll != false ? Integer.valueOf(1) : Integer.valueOf(0);
    }

    public String getOrderingMethods() {
        return StringUtils.join(this.orderingMethods, (String)",");
    }

    private void addOrderingMethod(String orderingMethod) {
        if (StringUtils.isNotEmpty((String)orderingMethod)) {
            this.orderingMethods.add(orderingMethod);
        }
    }

    private void removeOrderingMethod(String orderingMethod) {
        if (StringUtils.isNotEmpty((String)orderingMethod)) {
            this.orderingMethods.remove(orderingMethod);
        }
    }

    public void setAnalysisCountOrderingMethod(boolean asc) {
        if (this.orderingMethods.contains("analysisCount asc")) {
            this.removeOrderingMethod("analysisCount asc");
        } else if (this.orderingMethods.contains("analysisCount desc")) {
            this.removeOrderingMethod("analysisCount desc");
        }
        if (asc) {
            this.addOrderingMethod("analysisCount asc");
        } else {
            this.addOrderingMethod("analysisCount desc");
        }
    }

    public void setTagOrderingMethod(boolean asc) {
        if (this.orderingMethods.contains("tag asc")) {
            this.removeOrderingMethod("tag asc");
        } else if (this.orderingMethods.contains("tag desc")) {
            this.removeOrderingMethod("tag desc");
        }
        if (asc) {
            this.addOrderingMethod("tag asc");
        } else {
            this.addOrderingMethod("tag desc");
        }
    }
}

