/*
 * Decompiled with CFR 0.152.
 */
package com.weilai9.commons.modelgenerator;

import com.weilai9.commons.modelgenerator.DBHelper;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class DBGeneratorBack {
    private String[] colnames;
    private String[] colTypes;
    private String[] oldColnames;
    private int[] colSizes;
    private boolean f_util = false;
    private boolean f_sql = false;
    private boolean f_decimal = false;
    private boolean f_rowMapper = false;
    private boolean f_insert_update = false;
    private String dbName;
    private String packagePath;
    String url;
    String userName;
    String password;
    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public DBGeneratorBack(String packagePath, String dbName, String url, String userName, String password) {
        DBHelper.ini(url, userName, password);
        this.url = url;
        this.userName = userName;
        this.password = password;
        this.dbName = dbName;
        this.packagePath = packagePath;
    }

    public boolean isF_insert_update() {
        return this.f_insert_update;
    }

    public void setF_insert_update(boolean f_insert_update) {
        this.f_insert_update = f_insert_update;
    }

    public boolean isF_rowMapper() {
        return this.f_rowMapper;
    }

    public void setF_rowMapper(boolean f_rowMapper) {
        this.f_rowMapper = f_rowMapper;
    }

    public void build() {
        Connection conn = DBHelper.getConnection();
        List<String> tabNames = this.getTabs(this.dbName);
        for (String tableName : tabNames) {
            this.f_util = false;
            this.f_sql = true;
            this.f_decimal = false;
            PreparedStatement pstmt = null;
            String strsql = "select * from " + tableName;
            try {
                pstmt = conn.prepareStatement(strsql);
                ResultSetMetaData rsmd = pstmt.getMetaData();
                int size = rsmd.getColumnCount();
                this.colnames = new String[size];
                this.colTypes = new String[size];
                this.colSizes = new int[size];
                this.oldColnames = new String[size];
                String temp = "";
                for (int i = 0; i < rsmd.getColumnCount(); ++i) {
                    this.oldColnames[i] = temp = rsmd.getColumnName(i + 1);
                    this.colnames[i] = this.getCamelStr(temp);
                    this.colTypes[i] = rsmd.getColumnTypeName(i + 1);
                    if (this.colTypes[i].equalsIgnoreCase("datetime") || this.colTypes[i].equalsIgnoreCase("date") || this.colTypes[i].equalsIgnoreCase("timestamp")) {
                        this.f_util = true;
                    }
                    if (this.colTypes[i].equalsIgnoreCase("image") || this.colTypes[i].equalsIgnoreCase("text")) {
                        this.f_sql = true;
                    }
                    if (this.colTypes[i].equalsIgnoreCase("decimal")) {
                        this.f_decimal = true;
                    }
                    this.colSizes[i] = rsmd.getColumnDisplaySize(i + 1);
                }
                try {
                    String content = this.parse(this.colnames, this.colTypes, this.colSizes, this.packagePath, tableName);
                    String path = System.getProperty("user.dir") + File.separator + "src" + File.separator + this.packagePath.replaceAll("\\.", File.separator + "\\");
                    File file = new File(path);
                    if (!file.exists()) {
                        file.mkdirs();
                    }
                    String resPath = path + File.separator + this.initcap(tableName) + ".java";
                    FileUtils.writeStringToFile((File)new File(resPath), (String)content);
                    System.out.println(resPath);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        try {
            conn.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private List<String> getTabs(String dbName) {
        ArrayList<String> tabs = new ArrayList<String>();
        String sql = "SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = '" + dbName + "'";
        Connection con = DBHelper.getConnection();
        try {
            PreparedStatement pst = con.prepareStatement(sql);
            ResultSet set = pst.executeQuery();
            while (set.next()) {
                tabs.add(set.getString("TABLE_NAME"));
            }
            return tabs;
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                con.close();
            }
            catch (SQLException e2) {
                e2.printStackTrace();
            }
            return null;
        }
    }

    private String parse(String[] colNames, String[] colTypes, int[] colSizes, String packagePath, String tableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("package " + packagePath + ";\r\n\r\n");
        if (this.f_util) {
            sb.append("import java.util.Date;\r\n");
        }
        if (this.f_sql) {
            sb.append("import java.sql.*;\r\n\r\n\r\n");
        }
        if (this.f_decimal) {
            sb.append("import java.math.BigDecimal;\r\n\r\n\r\n");
        }
        if (this.f_rowMapper) {
            sb.append("import java.io.Serializable;\r\n\r\n\r\n");
            sb.append("import com.weilai9.commons.modelgenerator.Model;\r\n\r\n\r\n");
            sb.append("import com.weilai9.common.annotation.Transient;\r\n\r\n\r\n");
            sb.append("import java.text.SimpleDateFormat;\r\n\r\n\r\n");
        }
        String className = this.initcap(tableName);
        sb.append("public class " + className);
        sb.append(" implements Serializable");
        if (this.f_rowMapper) {
            sb.append(",Model<" + className + ">");
        }
        sb.append(" {\r\n\r\n");
        if (this.f_insert_update) {
            this.processInsertUpdateSql(sb, tableName);
        }
        sb.append("\r\n");
        this.processAllAttrs(sb);
        sb.append("\r\n");
        this.processConstructor(sb, className);
        sb.append("\r\n");
        if (this.f_insert_update) {
            this.processDynamicInsertUpdateMethod(sb, tableName);
        }
        sb.append("\r\n");
        this.processAllMethod(sb);
        if (this.f_rowMapper) {
            this.processRowMapper(sb, className);
        }
        sb.append("}\r\n");
        return sb.toString();
    }

    private void processConstructor(StringBuffer sb, String className) {
        int i;
        sb.append("\tpublic " + className + "(){}\r\n");
        String id = className.toLowerCase() + "id";
        String idType = "Integer";
        for (int i2 = 0; i2 < this.colnames.length; ++i2) {
            if (!this.colnames[i2].equals(id)) continue;
            idType = this.sqlType2JavaType(this.colTypes[i2]);
            break;
        }
        sb.append("\tpublic " + className + "(" + idType + " " + id + "){\r\n");
        sb.append("\t\tthis." + id + " = " + id + ";\r\n");
        sb.append("\t}\r\n");
        sb.append("\tpublic " + className + "(");
        int index = 0;
        for (i = 0; i < this.colnames.length; ++i) {
            if (this.colnames[i].equals(id)) continue;
            if (index > 0) {
                sb.append(",");
            }
            sb.append(this.sqlType2JavaType(this.colTypes[i]) + " " + this.colnames[i]);
            ++index;
        }
        sb.append("){\r\n");
        for (i = 0; i < this.colnames.length; ++i) {
            if (this.colnames[i].equals(id)) continue;
            sb.append("\t\tthis." + this.colnames[i] + " = " + this.colnames[i] + ";\r\n");
        }
        sb.append("}\r\n");
        sb.append("\tpublic static " + className + " newInstance(){return new " + className + "();}\r\n");
    }

    private void processInsertUpdateSql(StringBuffer sb, String tableName) {
        sb.append("\t@Transient\r\n");
        sb.append("\tstatic SimpleDateFormat dateFormat = new SimpleDateFormat(\"yyyy-MM-dd HH:mm:ss\");\r\n");
    }

    private void processDynamicInsertUpdateMethod(StringBuffer sb, String tableName) {
        int i;
        sb.append("\tpublic String buildInsertSql(){\r\n");
        sb.append("\t\tStringBuffer sb = new StringBuffer(\"INSERT INTO `" + this.dbName + "`.`" + tableName + "` (\");\r\n");
        for (int i2 = 0; i2 < this.colnames.length; ++i2) {
            sb.append("\t\tif(this." + this.colnames[i2] + " != null){\r\n");
            sb.append("\t\t\tsb.append(\"`" + this.oldColnames[i2] + "`,\");\r\n");
            sb.append("\t\t}\r\n");
        }
        sb.append("\t\tsb.append(\") VALUES (\");\r\n");
        String type = "";
        for (i = 0; i < this.colnames.length; ++i) {
            type = this.sqlType2JavaType(this.colTypes[i]);
            sb.append("\t\tif(this." + this.colnames[i] + " != null){\r\n");
            if ("String".equals(type)) {
                sb.append("\t\t\tsb.append(\"'\"+this." + this.colnames[i] + "+\"',\");\r\n");
            } else if ("Date".equals(type)) {
                sb.append("\t\t\tsb.append(\"'\"+dateFormat.format(this." + this.colnames[i] + ")+\"',\");\r\n");
            } else {
                sb.append("\t\t\tsb.append(this." + this.colnames[i] + "+\",\");\r\n");
            }
            sb.append("\t\t}\r\n");
        }
        sb.append("\t\tsb.append(\")\");\r\n");
        sb.append("\t\treturn sb.toString().replaceAll(\"\\\\,\\\\) VALUES\",\"\\\\) VALUES\")");
        sb.append(".replaceAll(\"\\\\,\\\\)\",\"\\\\)\");\r\n");
        sb.append("\t}\r\n");
        sb.append("\tpublic String buildUpdateSql(){\r\n");
        sb.append("\t\tStringBuffer sb = new StringBuffer(\"UPDATE `" + this.dbName + "`.`" + tableName + "` SET \");\r\n");
        for (i = 0; i < this.colnames.length; ++i) {
            if (this.colnames[i].equalsIgnoreCase(tableName + "id")) continue;
            type = this.sqlType2JavaType(this.colTypes[i]);
            sb.append("\t\tif(this." + this.colnames[i] + " != null){\r\n");
            if ("String".equals(type)) {
                sb.append("\t\t\tsb.append(\"`" + this.oldColnames[i] + "` = '\"+this." + this.colnames[i] + "+\"',\");\r\n");
            } else if ("Date".equals(type)) {
                sb.append("\t\t\tsb.append(\"`" + this.oldColnames[i] + "` = '\"+dateFormat.format(this." + this.colnames[i] + ")+\"',\");\r\n");
            } else {
                sb.append("\t\t\tsb.append(\"`" + this.oldColnames[i] + "` = \"+this." + this.colnames[i] + "+\",\");\r\n");
            }
            sb.append("\t\t}\r\n");
        }
        sb.append("\t\tsb.append(\" WHERE `" + this.initcap(tableName) + "ID` = \"+this." + tableName + "id);\r\n");
        sb.append("\t\treturn sb.toString().replaceAll(\"\\\\,\\\\)\",\"\\\\)\").replaceAll(\"\\\\, WHERE\",\" WHERE\");\r\n");
        sb.append("\t}\r\n");
        sb.append("\tpublic String buildDeleteSql(){\r\n");
        sb.append("\t\tStringBuffer sb = new StringBuffer(\"DELETE FROM `" + this.dbName + "`.`" + tableName + "` \");\r\n");
        sb.append("\t\tsb.append(\" WHERE `" + this.initcap(tableName) + "ID` = \"+this." + tableName + "id);\r\n");
        sb.append("\t\treturn sb.toString();\r\n");
        sb.append("\t}\r\n");
        sb.append("\tpublic String buildSelectByID(){\r\n");
        sb.append("\t\tString selectByID = \"SELECT ");
        int len = this.colnames.length;
        for (i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.oldColnames[i]);
        }
        sb.append(" FROM `" + this.dbName + "`.`" + tableName + "` WHERE `" + tableName + "`.`" + this.initcap(tableName) + "ID` = \"+this." + tableName + "id;\r\n");
        sb.append("\t\treturn selectByID;\r\n");
        sb.append("\t}\r\n");
    }

    private void processAllMethod(StringBuffer sb) {
        for (int i = 0; i < this.colnames.length; ++i) {
            sb.append("\tpublic void set" + this.initcap(this.colnames[i]) + "(" + this.sqlType2JavaType(this.colTypes[i]) + " " + this.colnames[i] + "){\r\n");
            sb.append("\t\tthis." + this.colnames[i] + " = " + this.colnames[i] + ";\r\n");
            sb.append("\t}\r\n\r\n");
            sb.append("\tpublic " + this.sqlType2JavaType(this.colTypes[i]) + " get" + this.initcap(this.colnames[i]) + "(){\r\n");
            sb.append("\t\treturn " + this.colnames[i] + ";\r\n");
            sb.append("\t}\r\n\r\n");
        }
    }

    private void processAllAttrs(StringBuffer sb) {
        for (int i = 0; i < this.colnames.length; ++i) {
            sb.append("\tprivate " + this.sqlType2JavaType(this.colTypes[i]) + " " + this.colnames[i] + ";\r\n");
        }
    }

    private void processRowMapper(StringBuffer sb, String className) {
        sb.append("\tpublic " + className + " mapRow (ResultSet rs,int arg) throws SQLException {\r\n");
        String low = className.toLowerCase();
        sb.append("\t\t" + className + " " + low + " = new " + className + "();\r\n");
        String type = "";
        for (int i = 0; i < this.colnames.length; ++i) {
            type = this.sqlType2JavaType(this.colTypes[i]);
            if ("Integer".equals(type)) {
                type = "Int";
            }
            if ("Date".equals(type)) {
                type = "Timestamp";
            }
            sb.append("\t\t" + low + ".set" + this.initcap(this.colnames[i]) + "(rs.get" + type + "(\"" + this.oldColnames[i] + "\"));\r\n");
        }
        sb.append("\t\treturn " + low + ";\r\n");
        sb.append("\t}\r\n");
    }

    private String initcap(String str) {
        if (str.indexOf("_") <= 0) {
            char[] ch = str.toCharArray();
            if (ch[0] >= 'a' && ch[0] <= 'z') {
                ch[0] = (char)(ch[0] - 32);
            }
            return new String(ch);
        }
        int index = str.indexOf("_");
        str = str.substring(0, index).toUpperCase() + str.substring(index + 1, index + 2).toUpperCase() + str.substring(index + 2);
        return str;
    }

    private String getCamelStr(String s) {
        return s.toLowerCase();
    }

    private String sqlType2JavaType(String sqlType) {
        if (sqlType.equalsIgnoreCase("bit")) {
            return "Boolean";
        }
        if (sqlType.equalsIgnoreCase("tinyint")) {
            return "byte";
        }
        if (sqlType.equalsIgnoreCase("smallint")) {
            return "Short";
        }
        if (sqlType.equalsIgnoreCase("int") || sqlType.equalsIgnoreCase("integer")) {
            return "Integer";
        }
        if (sqlType.equalsIgnoreCase("bigint")) {
            return "Long";
        }
        if (sqlType.equalsIgnoreCase("float")) {
            return "Float";
        }
        if (sqlType.equalsIgnoreCase("numeric") || sqlType.equalsIgnoreCase("real")) {
            return "Double";
        }
        if (sqlType.equalsIgnoreCase("money") || sqlType.equalsIgnoreCase("smallmoney")) {
            return "Double";
        }
        if (sqlType.equalsIgnoreCase("varchar") || sqlType.equalsIgnoreCase("char") || sqlType.equalsIgnoreCase("nvarchar") || sqlType.equalsIgnoreCase("nchar")) {
            return "String";
        }
        if (sqlType.equalsIgnoreCase("datetime")) {
            return "Date";
        }
        if (sqlType.equalsIgnoreCase("date") || sqlType.equalsIgnoreCase("timestamp")) {
            return "Date";
        }
        if (sqlType.equalsIgnoreCase("image")) {
            return "Blob";
        }
        if (sqlType.equalsIgnoreCase("text")) {
            return "Clob";
        }
        if (sqlType.equalsIgnoreCase("decimal")) {
            return "BigDecimal";
        }
        if (sqlType.equalsIgnoreCase("BLOB")) {
            return "String";
        }
        return "String";
    }

    public static void main(String[] args) {
        DBGeneratorBack gen = new DBGeneratorBack("com.weilai9.model", "swzh", "jdbc:mysql://rm-uf6892ke9027h6l83o.mysql.rds.aliyuncs.com:3306/swzh?useUnicode=true&characterEncoding=utf-8&allowMultiQueries=true", "yunlinker", "Yunlinker2017");
        gen.setF_insert_update(true);
        gen.setF_rowMapper(true);
        gen.build();
    }
}

