/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.api;

import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.response.EvaluateDecisionResponse;
import io.camunda.client.api.response.ProcessInstanceResult;
import io.camunda.client.impl.CamundaObjectMapper;
import io.camunda.process.test.api.CamundaAssertAwaitBehavior;
import io.camunda.process.test.api.assertions.DecisionInstanceAssert;
import io.camunda.process.test.api.assertions.DecisionSelector;
import io.camunda.process.test.api.assertions.DecisionSelectors;
import io.camunda.process.test.api.assertions.ElementSelector;
import io.camunda.process.test.api.assertions.ElementSelectors;
import io.camunda.process.test.api.assertions.ProcessInstanceAssert;
import io.camunda.process.test.api.assertions.ProcessInstanceSelector;
import io.camunda.process.test.api.assertions.UserTaskAssert;
import io.camunda.process.test.api.assertions.UserTaskSelector;
import io.camunda.process.test.impl.assertions.CamundaDataSource;
import io.camunda.process.test.impl.assertions.DecisionInstanceAssertj;
import io.camunda.process.test.impl.assertions.ProcessInstanceAssertj;
import io.camunda.process.test.impl.assertions.UserTaskAssertj;
import io.camunda.process.test.impl.assertions.util.AwaitilityBehavior;
import io.camunda.process.test.impl.assertions.util.CamundaAssertJsonMapper;
import io.camunda.zeebe.client.api.response.ProcessInstanceEvent;
import java.time.Duration;
import java.util.function.Function;

public class CamundaAssert {
    public static final Duration DEFAULT_ASSERTION_TIMEOUT = Duration.ofSeconds(10L);
    public static final Duration DEFAULT_ASSERTION_INTERVAL = Duration.ofMillis(100L);
    public static final Function<String, ElementSelector> DEFAULT_ELEMENT_SELECTOR = ElementSelectors::byId;
    public static final CamundaAssertAwaitBehavior DEFAULT_AWAIT_BEHAVIOR = new AwaitilityBehavior();
    public static final JsonMapper DEFAULT_JSON_MAPPER = new CamundaObjectMapper();
    private static final ThreadLocal<CamundaDataSource> DATA_SOURCE = new ThreadLocal();
    private static Function<String, ElementSelector> elementSelector = DEFAULT_ELEMENT_SELECTOR;
    private static CamundaAssertAwaitBehavior awaitBehavior = DEFAULT_AWAIT_BEHAVIOR;
    private static CamundaAssertJsonMapper jsonMapper = new CamundaAssertJsonMapper(DEFAULT_JSON_MAPPER);

    public static void setAssertionTimeout(Duration assertionTimeout) {
        awaitBehavior.setAssertionTimeout(assertionTimeout);
    }

    public static void setAssertionInterval(Duration assertionInterval) {
        awaitBehavior.setAssertionInterval(assertionInterval);
    }

    public static void setElementSelector(Function<String, ElementSelector> elementSelector) {
        CamundaAssert.elementSelector = elementSelector;
    }

    static CamundaAssertAwaitBehavior getAwaitBehavior() {
        return awaitBehavior;
    }

    public static void setAwaitBehavior(CamundaAssertAwaitBehavior awaitBehavior) {
        CamundaAssert.awaitBehavior = awaitBehavior;
    }

    public static void setJsonMapper(JsonMapper jsonMapper) {
        CamundaAssert.jsonMapper = new CamundaAssertJsonMapper(jsonMapper);
    }

    @Deprecated
    public static void setJsonMapper(io.camunda.zeebe.client.api.JsonMapper jsonMapper) {
        CamundaAssert.jsonMapper = new CamundaAssertJsonMapper(jsonMapper);
    }

    public static ProcessInstanceAssert assertThatProcessInstance(io.camunda.client.api.response.ProcessInstanceEvent processInstanceEvent) {
        return CamundaAssert.createProcessInstanceAssertj(processInstanceEvent.getProcessInstanceKey());
    }

    @Deprecated
    public static ProcessInstanceAssert assertThatProcessInstance(ProcessInstanceEvent processInstanceEvent) {
        return CamundaAssert.createProcessInstanceAssertj(processInstanceEvent.getProcessInstanceKey());
    }

    public static ProcessInstanceAssert assertThat(io.camunda.client.api.response.ProcessInstanceEvent processInstanceEvent) {
        return CamundaAssert.assertThatProcessInstance(processInstanceEvent);
    }

    @Deprecated
    public static ProcessInstanceAssert assertThat(ProcessInstanceEvent processInstanceEvent) {
        return CamundaAssert.assertThatProcessInstance(processInstanceEvent);
    }

    public static ProcessInstanceAssert assertThatProcessInstance(ProcessInstanceResult processInstanceResult) {
        return CamundaAssert.createProcessInstanceAssertj(processInstanceResult.getProcessInstanceKey());
    }

    @Deprecated
    public static ProcessInstanceAssert assertThatProcessInstance(io.camunda.zeebe.client.api.response.ProcessInstanceResult processInstanceResult) {
        return CamundaAssert.createProcessInstanceAssertj(processInstanceResult.getProcessInstanceKey());
    }

    public static ProcessInstanceAssert assertThat(ProcessInstanceResult processInstanceResult) {
        return CamundaAssert.assertThatProcessInstance(processInstanceResult);
    }

    @Deprecated
    public static ProcessInstanceAssert assertThat(io.camunda.zeebe.client.api.response.ProcessInstanceResult processInstanceResult) {
        return CamundaAssert.assertThatProcessInstance(processInstanceResult);
    }

    public static ProcessInstanceAssert assertThatProcessInstance(ProcessInstanceSelector processInstanceSelector) {
        return new ProcessInstanceAssertj(CamundaAssert.getDataSource(), awaitBehavior, jsonMapper, processInstanceSelector, elementSelector);
    }

    public static ProcessInstanceAssert assertThat(ProcessInstanceSelector processInstanceSelector) {
        return CamundaAssert.assertThatProcessInstance(processInstanceSelector);
    }

    private static ProcessInstanceAssertj createProcessInstanceAssertj(long processInstanceKey) {
        return new ProcessInstanceAssertj(CamundaAssert.getDataSource(), awaitBehavior, jsonMapper, processInstanceKey, elementSelector);
    }

    public static UserTaskAssert assertThatUserTask(UserTaskSelector userTaskSelector) {
        return new UserTaskAssertj(CamundaAssert.getDataSource(), awaitBehavior, userTaskSelector);
    }

    public static UserTaskAssert assertThat(UserTaskSelector userTaskSelector) {
        return CamundaAssert.assertThatUserTask(userTaskSelector);
    }

    public static DecisionInstanceAssert assertThatDecision(DecisionSelector decisionSelector) {
        return new DecisionInstanceAssertj(CamundaAssert.getDataSource(), awaitBehavior, jsonMapper, decisionSelector);
    }

    public static DecisionInstanceAssert assertThat(DecisionSelector decisionSelector) {
        return CamundaAssert.assertThatDecision(decisionSelector);
    }

    public static DecisionInstanceAssertj assertThatDecision(EvaluateDecisionResponse response) {
        return new DecisionInstanceAssertj(CamundaAssert.getDataSource(), awaitBehavior, jsonMapper, DecisionSelectors.byResponse(response));
    }

    public static DecisionInstanceAssertj assertThat(EvaluateDecisionResponse response) {
        return CamundaAssert.assertThatDecision(response);
    }

    private static CamundaDataSource getDataSource() {
        if (DATA_SOURCE.get() == null) {
            throw new IllegalStateException("No data source is set. Maybe you run outside of a testcase?");
        }
        return DATA_SOURCE.get();
    }

    static void initialize(CamundaDataSource dataSource) {
        DATA_SOURCE.set(dataSource);
    }

    static void reset() {
        DATA_SOURCE.remove();
    }

    static {
        CamundaAssert.setAssertionTimeout(DEFAULT_ASSERTION_TIMEOUT);
        CamundaAssert.setAssertionInterval(DEFAULT_ASSERTION_INTERVAL);
    }
}

