/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.api.coverage.core;

import io.camunda.client.api.search.enums.ElementInstanceType;
import io.camunda.client.api.search.response.ElementInstance;
import io.camunda.client.api.search.response.ProcessInstance;
import io.camunda.client.api.search.response.ProcessInstanceSequenceFlow;
import io.camunda.process.test.api.coverage.model.Coverage;
import io.camunda.process.test.api.coverage.model.Model;
import io.camunda.process.test.impl.assertions.CamundaDataSource;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.instance.IdentifiableBpmnElement;
import io.camunda.zeebe.model.bpmn.instance.SequenceFlow;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CoverageCreator {
    public static Coverage createCoverage(CamundaDataSource dataSource, ProcessInstance processInstance, Model model) {
        List<ElementInstance> takenElementInstances = dataSource.findElementInstancesByProcessInstanceKey(processInstance.getProcessInstanceKey()).stream().filter(node -> node.getType() != ElementInstanceType.PROCESS).collect(Collectors.toList());
        List<String> takenElements = takenElementInstances.stream().map(ElementInstance::getElementId).distinct().collect(Collectors.toList());
        List<String> takenSequenceFlows = dataSource.findSequenceFlowsByProcessInstanceKey(processInstance.getProcessInstanceKey()).stream().map(ProcessInstanceSequenceFlow::getElementId).distinct().collect(Collectors.toList());
        CoverageCreator.enhanceSequenceFlowsByEventBasedGateway(takenSequenceFlows, takenElementInstances, model);
        return new Coverage(processInstance.getProcessDefinitionId(), takenElements, takenSequenceFlows, CoverageCreator.calculateCoverage(takenElements, takenSequenceFlows, model));
    }

    public static List<Coverage> aggregateCoverages(Collection<Coverage> coverages, Collection<Model> models) {
        Map<String, List<Coverage>> coveragesByProcessDefinition = coverages.stream().collect(Collectors.groupingBy(Coverage::getProcessDefinitionId));
        ArrayList<Coverage> aggregatedCoverages = new ArrayList<Coverage>();
        coveragesByProcessDefinition.forEach((processDefinitionId, coveragesForProcessInstance) -> {
            List<String> completedElements = coveragesForProcessInstance.stream().flatMap(c -> c.getCompletedElements().stream()).distinct().collect(Collectors.toList());
            List<String> takenSequenceFlows = coveragesForProcessInstance.stream().flatMap(c -> c.getTakenSequenceFlows().stream()).distinct().collect(Collectors.toList());
            Model model = models.stream().filter(m -> m.getProcessDefinitionId().equals(processDefinitionId)).findFirst().orElseThrow(() -> new IllegalStateException("No model found for process definition id: " + processDefinitionId));
            aggregatedCoverages.add(new Coverage((String)processDefinitionId, completedElements, takenSequenceFlows, CoverageCreator.calculateCoverage(completedElements, takenSequenceFlows, model)));
        });
        return aggregatedCoverages;
    }

    private static void enhanceSequenceFlowsByEventBasedGateway(List<String> takenSequenceFlows, List<ElementInstance> takenNodeElements, Model model) {
        BpmnModelInstance modelInstance = Bpmn.readModelFromStream((InputStream)new ByteArrayInputStream(model.xml().getBytes()));
        for (int i = 0; i < takenNodeElements.size(); ++i) {
            ElementInstance event = takenNodeElements.get(i);
            if (event.getType() != ElementInstanceType.EVENT_BASED_GATEWAY) continue;
            List outgoingFlows = modelInstance.getModelElementsByType(SequenceFlow.class).stream().filter(flow -> flow.getSource().getId().equals(event.getElementId())).collect(Collectors.toList());
            for (int j = i + 1; j < takenNodeElements.size(); ++j) {
                ElementInstance nextEvent = takenNodeElements.get(j);
                outgoingFlows.stream().filter(flow -> flow.getTarget().getId().equals(nextEvent.getElementId())).map(IdentifiableBpmnElement::getId).findFirst().ifPresent(takenSequenceFlows::add);
            }
        }
    }

    private static double calculateCoverage(List<String> takenElements, List<String> takenSequenceFlows, Model model) {
        if (model.getTotalElementCount() == 0) {
            return 0.0;
        }
        double coveredElements = takenElements.size() + takenSequenceFlows.size();
        return coveredElements / (double)model.getTotalElementCount();
    }
}

