/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.assertions;

import com.fasterxml.jackson.databind.JsonNode;
import io.camunda.client.api.search.filter.ElementInstanceFilter;
import io.camunda.client.api.search.response.ElementInstance;
import io.camunda.client.api.search.response.Variable;
import io.camunda.process.test.api.CamundaAssertAwaitBehavior;
import io.camunda.process.test.api.assertions.ElementSelector;
import io.camunda.process.test.impl.assertions.AssertFormatUtil;
import io.camunda.process.test.impl.assertions.CamundaDataSource;
import io.camunda.process.test.impl.assertions.util.CamundaAssertJsonMapper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.OptionalAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariableAssertj
extends AbstractAssert<VariableAssertj, String> {
    private static final Logger LOG = LoggerFactory.getLogger(VariableAssertj.class);
    private final CamundaDataSource dataSource;
    private final CamundaAssertAwaitBehavior awaitBehavior;
    private final CamundaAssertJsonMapper jsonMapper;

    public VariableAssertj(CamundaDataSource dataSource, CamundaAssertAwaitBehavior awaitBehavior, CamundaAssertJsonMapper jsonMapper, String failureMessagePrefix) {
        super((Object)failureMessagePrefix, VariableAssertj.class);
        this.dataSource = dataSource;
        this.awaitBehavior = awaitBehavior;
        this.jsonMapper = jsonMapper;
    }

    public void hasLocalVariableNames(long processInstanceKey, ElementSelector selector, String ... variableNames) {
        this.withLocalVariableAssertion(processInstanceKey, selector, instance -> this.hasVariableNames(() -> this.getLocalProcessInstanceVariables(processInstanceKey, instance.getElementInstanceKey()), variableNames));
    }

    public void hasVariableNames(long processInstanceKey, String ... variableNames) {
        this.hasVariableNames(() -> this.getGlobalProcessInstanceVariables(processInstanceKey), variableNames);
    }

    private void hasVariableNames(Supplier<Map<String, String>> actualVariablesSupplier, String ... variableNames) {
        this.awaitBehavior.untilAsserted(() -> {
            Map variables = (Map)actualVariablesSupplier.get();
            List<String> missingVariableNames = Arrays.stream(variableNames).filter(variableName -> !variables.containsKey(variableName)).collect(Collectors.toList());
            ((ListAssert)Assertions.assertThat(missingVariableNames).withFailMessage("%s should have the variables %s but %s don't exist.", new Object[]{this.actual, AssertFormatUtil.formatNames(variableNames), AssertFormatUtil.formatNames(missingVariableNames)})).isEmpty();
        });
    }

    public void hasLocalVariable(long processInstanceKey, ElementSelector selector, String variableName, Object variableValue) {
        this.withLocalVariableAssertion(processInstanceKey, selector, instance -> this.hasVariable(variableName, variableValue, () -> this.getLocalProcessInstanceVariables(processInstanceKey, instance.getElementInstanceKey())));
    }

    public void hasVariable(long processInstanceKey, String variableName, Object variableValue) {
        this.hasVariable(variableName, variableValue, () -> this.getGlobalProcessInstanceVariables(processInstanceKey));
    }

    private void hasVariable(String variableName, Object variableValue, Supplier<Map<String, String>> actualVariablesSupplier) {
        JsonNode expectedValue = this.jsonMapper.toJsonNode(variableValue);
        this.awaitBehavior.untilAsserted(() -> {
            Map variables = (Map)actualVariablesSupplier.get();
            ((MapAssert)Assertions.assertThat((Map)variables).withFailMessage("%s should have a variable '%s' with value '%s' but the variable doesn't exist.", new Object[]{this.actual, variableName, expectedValue})).containsKey((Object)variableName);
            JsonNode actualValue = this.jsonMapper.readJson((String)variables.get(variableName));
            ((IterableAssert)Assertions.assertThat((Iterable)actualValue).withFailMessage("%s should have a variable '%s' with value '%s' but was '%s'.", new Object[]{this.actual, variableName, expectedValue, actualValue})).isEqualTo((Object)expectedValue);
        });
    }

    public <T> void hasLocalVariableSatisfies(long processInstanceKey, ElementSelector selector, String variableName, Class<T> variableValueType, ThrowingConsumer<T> requirement) {
        this.withLocalVariableAssertion(processInstanceKey, selector, instance -> this.hasVariableSatisfies(variableName, variableValueType, requirement, () -> this.getLocalProcessInstanceVariables(processInstanceKey, instance.getElementInstanceKey())));
    }

    public <T> void hasVariableSatisfies(long processInstanceKey, String variableName, Class<T> variableValueType, ThrowingConsumer<T> requirement) {
        this.hasVariableSatisfies(variableName, variableValueType, requirement, () -> this.getGlobalProcessInstanceVariables(processInstanceKey));
    }

    private <T> void hasVariableSatisfies(String variableName, Class<T> variableValueType, ThrowingConsumer<T> requirement, Supplier<Map<String, String>> actualVariablesSupplier) {
        this.awaitBehavior.untilAsserted(() -> {
            Map variables = (Map)actualVariablesSupplier.get();
            ((MapAssert)Assertions.assertThat((Map)variables).withFailMessage("%s should have a variable '%s', but the variable doesn't exist.", new Object[]{this.actual, variableName})).containsKey((Object)variableName);
            String actualVariable = (String)variables.get(variableName);
            try {
                Object actualValue = this.jsonMapper.readJson(actualVariable, variableValueType);
                requirement.accept(actualValue);
            }
            catch (AssertionError e) {
                Assertions.fail((String)"%s should have a variable '%s' but the following requirement was not satisfied: %s.", (Object[])new Object[]{this.actual, variableName, ((Throwable)((Object)e)).getMessage()});
            }
            catch (CamundaAssertJsonMapper.JsonMappingException e) {
                Throwable reason = Optional.ofNullable(e.getCause()).map(cause -> Optional.ofNullable(cause.getCause()).orElse((Throwable)cause)).orElse(e);
                String failureMessage = String.format("%s should have a variable '%s' of type '%s', but the JSON mapping failed:\nError: %s\nReason: %s", this.actual, variableName, variableValueType.getName(), e.getMessage(), reason);
                Assertions.fail((String)failureMessage);
            }
        });
    }

    public void hasLocalVariables(long processInstanceKey, ElementSelector selector, Map<String, Object> expectedVariables) {
        this.withLocalVariableAssertion(processInstanceKey, selector, instance -> this.hasVariables(expectedVariables, () -> this.getLocalProcessInstanceVariables(processInstanceKey, instance.getElementInstanceKey())));
    }

    public void hasVariables(long processInstanceKey, Map<String, Object> expectedVariables) {
        this.hasVariables(expectedVariables, () -> this.getGlobalProcessInstanceVariables(processInstanceKey));
    }

    private void hasVariables(Map<String, Object> expectedVariables, Supplier<Map<String, String>> actualVariablesSupplier) {
        Map<String, JsonNode> expectedValues = expectedVariables.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.jsonMapper.toJsonNode(entry.getValue())));
        Set<String> expectedVariableNames = expectedVariables.keySet();
        this.awaitBehavior.untilAsserted(() -> {
            Map<String, JsonNode> actualValues = ((Map)actualVariablesSupplier.get()).entrySet().stream().filter(entry -> expectedVariableNames.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, entry -> this.jsonMapper.readJson((String)entry.getValue())));
            List<String> missingVariables = expectedVariableNames.stream().filter(variableName -> !actualValues.containsKey(variableName)).collect(Collectors.toList());
            ((ListAssert)Assertions.assertThat(missingVariables).withFailMessage("%s should have the variables %s but was %s. The variables %s don't exist.", new Object[]{this.actual, this.jsonMapper.toJsonNode(expectedVariables), this.jsonMapper.toJsonNode(actualValues), AssertFormatUtil.formatNames(missingVariables)})).isEmpty();
            ((MapAssert)Assertions.assertThat(actualValues).withFailMessage("%s should have the variables %s but was %s.", new Object[]{this.actual, this.jsonMapper.toJsonNode(expectedVariables), this.jsonMapper.toJsonNode(actualValues)})).containsAllEntriesOf(expectedValues);
        });
    }

    private void withLocalVariableAssertion(long processInstanceKey, ElementSelector selector, Consumer<ElementInstance> assertionCallback) {
        this.awaitElementInstanceAssertion(f -> {
            f.processInstanceKey(processInstanceKey);
            selector.applyFilter((ElementInstanceFilter)f);
        }, elementInstances -> {
            Optional<ElementInstance> instance = elementInstances.stream().filter(selector::test).findFirst();
            ((OptionalAssert)Assertions.assertThat(instance).withFailMessage("No element [%s] found for process instance [key: %s]", new Object[]{selector.describe(), processInstanceKey})).isPresent();
            assertionCallback.accept(instance.get());
        });
    }

    private void awaitElementInstanceAssertion(Consumer<ElementInstanceFilter> filter, Consumer<List<ElementInstance>> assertion) {
        this.awaitBehavior.untilAsserted(() -> this.dataSource.findElementInstances(filter), assertion);
    }

    private Map<String, String> getLocalProcessInstanceVariables(long processInstanceKey, long elementInstanceKey) {
        List<Variable> variables = this.dataSource.findVariables(filter -> filter.processInstanceKey(Long.valueOf(processInstanceKey)).scopeKey(Long.valueOf(elementInstanceKey)));
        return this.toMap(this.ensureVariablesAreNotTruncated(variables));
    }

    private Map<String, String> getGlobalProcessInstanceVariables(long processInstanceKey) {
        List<Variable> variables = this.dataSource.findGlobalVariablesByProcessInstanceKey(processInstanceKey);
        return this.toMap(this.ensureVariablesAreNotTruncated(variables));
    }

    private List<Variable> ensureVariablesAreNotTruncated(List<Variable> variablesToCheck) {
        return variablesToCheck.stream().map(variable -> {
            if (variable.isTruncated().booleanValue()) {
                return this.fetchCompleteVariableByKey((Variable)variable);
            }
            return variable;
        }).collect(Collectors.toList());
    }

    private Variable fetchCompleteVariableByKey(Variable variable) {
        try {
            return this.dataSource.getVariable(variable.getVariableKey());
        }
        catch (Throwable t) {
            String expandVariableException = String.format("Unable to fetch complete variable data for truncated variable [name: %s]. Will attempt to complete the assertion based on the truncated value which may lead to errors.", variable.getName());
            LOG.warn(expandVariableException, t);
            return variable;
        }
    }

    private Map<String, String> toMap(List<Variable> variables) {
        return variables.stream().collect(HashMap::new, (m, v) -> m.put(v.getName(), v.getValue()), HashMap::putAll);
    }
}

