/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.runtime;

import io.camunda.process.test.api.CamundaClientBuilderFactory;
import io.camunda.process.test.api.CamundaProcessTestRuntimeMode;
import io.camunda.process.test.impl.containers.ContainerFactory;
import io.camunda.process.test.impl.runtime.CamundaProcessTestContainerRuntime;
import io.camunda.process.test.impl.runtime.CamundaProcessTestRemoteRuntime;
import io.camunda.process.test.impl.runtime.CamundaProcessTestRuntime;
import io.camunda.process.test.impl.runtime.CamundaProcessTestRuntimeDefaults;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamundaProcessTestRuntimeBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(CamundaProcessTestRuntimeBuilder.class);
    private ContainerFactory containerFactory = new ContainerFactory();
    private String camundaDockerImageName = CamundaProcessTestRuntimeDefaults.CAMUNDA_DOCKER_IMAGE_NAME;
    private String camundaDockerImageVersion = CamundaProcessTestRuntimeDefaults.CAMUNDA_DOCKER_IMAGE_VERSION;
    private String elasticsearchDockerImageName = "elasticsearch";
    private String elasticsearchDockerImageVersion = CamundaProcessTestRuntimeDefaults.ELASTICSEARCH_DOCKER_IMAGE_VERSION;
    private String connectorsDockerImageName = CamundaProcessTestRuntimeDefaults.CONNECTORS_DOCKER_IMAGE_NAME;
    private String connectorsDockerImageVersion = CamundaProcessTestRuntimeDefaults.CONNECTORS_DOCKER_IMAGE_VERSION;
    private final Map<String, String> camundaEnvVars = new HashMap<String, String>(CamundaProcessTestRuntimeDefaults.CAMUNDA_ENV_VARS);
    private final Map<String, String> connectorsEnvVars = new HashMap<String, String>(CamundaProcessTestRuntimeDefaults.CONNECTORS_ENV_VARS);
    private final Map<String, String> elasticsearchEnvVars = new HashMap<String, String>();
    private final List<Integer> camundaExposedPorts = new ArrayList<Integer>(CamundaProcessTestRuntimeDefaults.CAMUNDA_EXPOSED_PORTS);
    private final List<Integer> elasticsearchExposedPorts = new ArrayList<Integer>();
    private final List<Integer> connectorsExposedPorts = new ArrayList<Integer>(CamundaProcessTestRuntimeDefaults.CONNECTORS_EXPOSED_PORTS);
    private String camundaLoggerName = CamundaProcessTestRuntimeDefaults.CAMUNDA_LOGGER_NAME;
    private String elasticsearchLoggerName = "tc.elasticsearch";
    private String connectorsLoggerName = CamundaProcessTestRuntimeDefaults.CONNECTORS_LOGGER_NAME;
    private boolean connectorsEnabled = CamundaProcessTestRuntimeDefaults.CONNECTORS_ENABLED;
    private final Map<String, String> connectorsSecrets = new HashMap<String, String>(CamundaProcessTestRuntimeDefaults.CONNECTORS_SECRETS);
    private CamundaProcessTestRuntimeMode runtimeMode = CamundaProcessTestRuntimeDefaults.RUNTIME_MODE;
    private CamundaClientBuilderFactory remoteCamundaClientBuilderFactory = CamundaProcessTestRuntimeDefaults.CAMUNDA_CLIENT_BUILDER_FACTORY;
    private URI remoteCamundaMonitoringApiAddress = CamundaProcessTestRuntimeDefaults.REMOTE_CAMUNDA_MONITORING_API_ADDRESS;
    private URI remoteConnectorsRestApiAddress = CamundaProcessTestRuntimeDefaults.REMOTE_CONNECTORS_REST_API_ADDRESS;
    private boolean isMultiTenancyEnabled = CamundaProcessTestRuntimeDefaults.MULTI_TENANCY_ENABLED;
    private String coverageReportDirectory = CamundaProcessTestRuntimeDefaults.COVERAGE_REPORT_DIRECTORY;
    private List<String> coverageExcludedProcesses = CamundaProcessTestRuntimeDefaults.COVERAGE_EXCLUDED_PROCESSES;

    CamundaProcessTestRuntimeBuilder withContainerFactory(ContainerFactory containerFactory) {
        this.containerFactory = containerFactory;
        return this;
    }

    public CamundaProcessTestRuntimeBuilder withCamundaDockerImageName(String dockerImageName) {
        this.camundaDockerImageName = dockerImageName;
        return this;
    }

    public CamundaProcessTestRuntimeBuilder withCamundaDockerImageVersion(String dockerImageVersion) {
        this.camundaDockerImageVersion = dockerImageVersion;
        return this;
    }

    public CamundaProcessTestRuntimeBuilder withElasticsearchDockerImageName(String dockerImageName) {
        this.elasticsearchDockerImageName = dockerImageName;
        return this;
    }

    public CamundaProcessTestRuntimeBuilder withElasticsearchDockerImageVersion(String dockerImageVersion) {
        this.elasticsearchDockerImageVersion = dockerImageVersion;
        return this;
    }

    public CamundaProcessTestRuntimeBuilder withConnectorsDockerImageName(String dockerImageName) {
        this.connectorsDockerImageName = dockerImageName;
        return this;
    }

    public CamundaProcessTestRuntimeBuilder withConnectorsDockerImageVersion(String dockerImageVersion) {
        this.connectorsDockerImageVersion = dockerImageVersion;
        return this;
    }

    public CamundaProcessTestRuntimeBuilder withCamundaEnv(Map<String, String> envVars) {
        this.camundaEnvVars.putAll(envVars);
        return this;
    }

    public CamundaProcessTestRuntimeBuilder withCamundaEnv(String name, String value) {
        this.camundaEnvVars.put(name, value);
        return this;
    }

    public CamundaProcessTestRuntimeBuilder withElasticsearchEnv(Map<String, String> envVars) {
        this.elasticsearchEnvVars.putAll(envVars);
        return this;
    }

    public CamundaProcessTestRuntimeBuilder withElasticsearchEnv(String name, String value) {
        this.elasticsearchEnvVars.put(name, value);
        return this;
    }

    public CamundaProcessTestRuntimeBuilder withConnectorsEnv(Map<String, String> envVars) {
        this.connectorsEnvVars.putAll(envVars);
        return this;
    }

    public CamundaProcessTestRuntimeBuilder withConnectorsEnv(String name, String value) {
        this.connectorsEnvVars.put(name, value);
        return this;
    }

    public CamundaProcessTestRuntimeBuilder withCamundaExposedPort(int port) {
        this.camundaExposedPorts.add(port);
        return this;
    }

    public CamundaProcessTestRuntimeBuilder withElasticsearchExposedPort(int port) {
        this.elasticsearchExposedPorts.add(port);
        return this;
    }

    public CamundaProcessTestRuntimeBuilder withConnectorsExposedPort(int port) {
        this.connectorsExposedPorts.add(port);
        return this;
    }

    public CamundaProcessTestRuntimeBuilder withCamundaLogger(String loggerName) {
        this.camundaLoggerName = loggerName;
        return this;
    }

    public CamundaProcessTestRuntimeBuilder withElasticsearchLogger(String loggerName) {
        this.elasticsearchLoggerName = loggerName;
        return this;
    }

    public CamundaProcessTestRuntimeBuilder withConnectorsLogger(String loggerName) {
        this.connectorsLoggerName = loggerName;
        return this;
    }

    public CamundaProcessTestRuntimeBuilder withConnectorsEnabled(boolean enabled) {
        this.connectorsEnabled = enabled;
        return this;
    }

    public CamundaProcessTestRuntimeBuilder withConnectorsSecret(String name, String value) {
        this.connectorsSecrets.put(name, value);
        return this;
    }

    public CamundaProcessTestRuntimeBuilder withConnectorsSecrets(Map<String, String> secrets) {
        this.connectorsSecrets.putAll(secrets);
        return this;
    }

    public CamundaProcessTestRuntimeBuilder withRuntimeMode(CamundaProcessTestRuntimeMode runtimeMode) {
        this.runtimeMode = runtimeMode;
        return this;
    }

    public CamundaProcessTestRuntimeBuilder withRemoteCamundaClientBuilderFactory(CamundaClientBuilderFactory remoteCamundaClientBuilderFactory) {
        this.remoteCamundaClientBuilderFactory = remoteCamundaClientBuilderFactory;
        return this;
    }

    public CamundaProcessTestRuntimeBuilder withRemoteCamundaMonitoringApiAddress(URI remoteCamundaMonitoringApiAddress) {
        this.remoteCamundaMonitoringApiAddress = remoteCamundaMonitoringApiAddress;
        return this;
    }

    public CamundaProcessTestRuntimeBuilder withRemoteConnectorsRestApiAddress(URI remoteConnectorsRestApiAddress) {
        this.remoteConnectorsRestApiAddress = remoteConnectorsRestApiAddress;
        return this;
    }

    public CamundaProcessTestRuntimeBuilder withMultiTenancyEnabled(boolean enabled) {
        this.isMultiTenancyEnabled = enabled;
        return this;
    }

    public CamundaProcessTestRuntimeBuilder withCoverageReportDirectory(String coverageReportDirectory) {
        this.coverageReportDirectory = coverageReportDirectory;
        return this;
    }

    public CamundaProcessTestRuntimeBuilder withCoverageExcludedProcesses(List<String> coverageExcludedProcesses) {
        this.coverageExcludedProcesses = coverageExcludedProcesses;
        return this;
    }

    public CamundaProcessTestRuntime build() {
        switch (this.runtimeMode) {
            case MANAGED: {
                return new CamundaProcessTestContainerRuntime(this, this.containerFactory);
            }
            case REMOTE: {
                return new CamundaProcessTestRemoteRuntime(this);
            }
        }
        LOGGER.warn("Unknown runtime mode: {}. Fall back to MANAGED runtime mode.", (Object)this.runtimeMode);
        return new CamundaProcessTestContainerRuntime(this, this.containerFactory);
    }

    public String getCamundaDockerImageName() {
        return this.camundaDockerImageName;
    }

    public String getCamundaDockerImageVersion() {
        return this.camundaDockerImageVersion;
    }

    public String getElasticsearchDockerImageName() {
        return this.elasticsearchDockerImageName;
    }

    public String getElasticsearchDockerImageVersion() {
        return this.elasticsearchDockerImageVersion;
    }

    public String getConnectorsDockerImageName() {
        return this.connectorsDockerImageName;
    }

    public String getConnectorsDockerImageVersion() {
        return this.connectorsDockerImageVersion;
    }

    public Map<String, String> getCamundaEnvVars() {
        return this.camundaEnvVars;
    }

    public Map<String, String> getElasticsearchEnvVars() {
        return this.elasticsearchEnvVars;
    }

    public Map<String, String> getConnectorsEnvVars() {
        return this.connectorsEnvVars;
    }

    public List<Integer> getCamundaExposedPorts() {
        return this.camundaExposedPorts;
    }

    public List<Integer> getElasticsearchExposedPorts() {
        return this.elasticsearchExposedPorts;
    }

    public List<Integer> getConnectorsExposedPorts() {
        return this.connectorsExposedPorts;
    }

    public String getCamundaLoggerName() {
        return this.camundaLoggerName;
    }

    public String getElasticsearchLoggerName() {
        return this.elasticsearchLoggerName;
    }

    public String getConnectorsLoggerName() {
        return this.connectorsLoggerName;
    }

    public boolean isConnectorsEnabled() {
        return this.connectorsEnabled;
    }

    public boolean isMultiTenancyEnabled() {
        return this.isMultiTenancyEnabled;
    }

    public Map<String, String> getConnectorsSecrets() {
        return this.connectorsSecrets;
    }

    public CamundaProcessTestRuntimeMode getRuntimeMode() {
        return this.runtimeMode;
    }

    public CamundaClientBuilderFactory getRemoteCamundaClientBuilderFactory() {
        return this.remoteCamundaClientBuilderFactory;
    }

    public URI getRemoteCamundaMonitoringApiAddress() {
        return this.remoteCamundaMonitoringApiAddress;
    }

    public URI getRemoteConnectorsRestApiAddress() {
        return this.remoteConnectorsRestApiAddress;
    }

    public String getCoverageReportDirectory() {
        return this.coverageReportDirectory;
    }

    public List<String> getCoverageExcludedProcesses() {
        return this.coverageExcludedProcesses;
    }
}

