/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.runtime.properties;

import io.camunda.process.test.impl.runtime.util.PropertiesUtil;
import io.camunda.process.test.impl.runtime.util.VersionedPropertiesUtil;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ConnectorsContainerRuntimeProperties {
    public static final String PROPERTY_NAME_CONNECTORS_DOCKER_IMAGE_NAME = "connectorsDockerImageName";
    public static final String PROPERTY_NAME_CONNECTORS_DOCKER_IMAGE_VERSION = "connectorsDockerImageVersion";
    public static final String PROPERTY_NAME_CONNECTORS_ENABLED = "connectorsEnabled";
    public static final String PROPERTY_NAME_CONNECTORS_ENV_VARS_PREFIX = "connectorsEnvVars";
    public static final String PROPERTY_NAME_CONNECTORS_SECRETS_PREFIX = "connectorsSecrets";
    public static final String PROPERTY_NAME_CONNECTORS_EXPOSED_PORTS_PREFIX = "connectorsExposedPorts";
    private final boolean isConnectorsEnabled;
    private final String connectorsDockerImageName;
    private final String connectorsDockerImageVersion;
    private final Map<String, String> connectorsEnvVars;
    private final Map<String, String> connectorsSecrets;
    private final List<Integer> connectorsExposedPorts;

    public ConnectorsContainerRuntimeProperties(Properties properties) {
        this.isConnectorsEnabled = PropertiesUtil.getPropertyOrDefault(properties, PROPERTY_NAME_CONNECTORS_ENABLED, "false").trim().equalsIgnoreCase("true");
        this.connectorsDockerImageName = PropertiesUtil.getPropertyOrDefault(properties, PROPERTY_NAME_CONNECTORS_DOCKER_IMAGE_NAME, "camunda/connectors-bundle");
        this.connectorsDockerImageVersion = VersionedPropertiesUtil.getLatestReleasedVersion(properties, PROPERTY_NAME_CONNECTORS_DOCKER_IMAGE_VERSION, "SNAPSHOT");
        this.connectorsEnvVars = PropertiesUtil.getPropertyMapOrEmpty(properties, PROPERTY_NAME_CONNECTORS_ENV_VARS_PREFIX);
        this.connectorsSecrets = PropertiesUtil.getPropertyMapOrEmpty(properties, PROPERTY_NAME_CONNECTORS_SECRETS_PREFIX);
        this.connectorsExposedPorts = PropertiesUtil.getPropertyListOrEmpty(properties, PROPERTY_NAME_CONNECTORS_EXPOSED_PORTS_PREFIX, Integer::parseInt);
    }

    public boolean isConnectorsEnabled() {
        return this.isConnectorsEnabled;
    }

    public String getConnectorsDockerImageName() {
        return this.connectorsDockerImageName;
    }

    public String getConnectorsDockerImageVersion() {
        return this.connectorsDockerImageVersion;
    }

    public Map<String, String> getConnectorsEnvVars() {
        return this.connectorsEnvVars;
    }

    public Map<String, String> getConnectorsSecrets() {
        return this.connectorsSecrets;
    }

    public List<Integer> getConnectorsExposedPorts() {
        return this.connectorsExposedPorts;
    }
}

