/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.runtime.properties;

import io.camunda.client.impl.oauth.OAuthCredentialsProviderBuilder;
import io.camunda.process.test.impl.runtime.util.PropertiesUtil;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Properties;

public class RemoteRuntimeClientAuthProperties {
    public static final String PROPERTY_NAME_METHOD = "remote.client.auth.method";
    public static final String PROPERTY_NAME_USERNAME = "remote.client.auth.username";
    public static final String PROPERTY_NAME_PASSWORD = "remote.client.auth.password";
    public static final String PROPERTY_NAME_CLIENT_ID = "remote.client.auth.clientId";
    public static final String PROPERTY_NAME_CLIENT_SECRET = "remote.client.auth.clientSecret";
    public static final String PROPERTY_NAME_TOKEN_URL = "remote.client.auth.tokenUrl";
    public static final String PROPERTY_NAME_AUDIENCE = "remote.client.auth.audience";
    public static final String PROPERTY_NAME_SCOPE = "remote.client.auth.scope";
    public static final String PROPERTY_NAME_RESOURCE = "remote.client.auth.resource";
    public static final String PROPERTY_NAME_KEYSTORE_PATH = "remote.client.auth.keystorePath";
    public static final String PROPERTY_NAME_KEYSTORE_PASSWORD = "remote.client.auth.keystorePassword";
    public static final String PROPERTY_NAME_KEYSTORE_KEY_PASSWORD = "remote.client.auth.keystoreKeyPassword";
    public static final String PROPERTY_NAME_TRUSTSTORE_PATH = "remote.client.auth.truststorePath";
    public static final String PROPERTY_NAME_TRUSTSTORE_PASSWORD = "remote.client.auth.truststorePassword";
    public static final String PROPERTY_NAME_CREDENTIALS_CACHE_PATH = "remote.client.auth.credentialsCachePath";
    public static final String PROPERTY_NAME_CONNECT_TIMEOUT = "remote.client.auth.connectTimeout";
    public static final String PROPERTY_NAME_READ_TIMEOUT = "remote.client.auth.readTimeout";
    public static final String PROPERTY_NAME_CLIENT_ASSERTION_KEYSTORE_PATH = "remote.client.auth.clientAssertion.keystorePath";
    public static final String PROPERTY_NAME_CLIENT_ASSERTION_KEYSTORE_PASSWORD = "remote.client.auth.clientAssertion.keystorePassword";
    public static final String PROPERTY_NAME_CLIENT_ASSERTION_KEYSTORE_KEY_ALIAS = "remote.client.auth.clientAssertion.keystoreKeyAlias";
    public static final String PROPERTY_NAME_CLIENT_ASSERTION_KEYSTORE_KEY_PASSWORD = "remote.client.auth.clientAssertion.keystoreKeyPassword";
    private final AuthMethod method;
    private final String username;
    private final String password;
    private final String clientId;
    private final String clientSecret;
    private final URI tokenUrl;
    private final String audience;
    private final String scope;
    private final String resource;
    private final Path keystorePath;
    private final String keystorePassword;
    private final String keystoreKeyPassword;
    private final Path truststorePath;
    private final String truststorePassword;
    private final String credentialsCachePath;
    private final Duration connectTimeout;
    private final Duration readTimeout;
    private final Path clientAssertionKeystorePath;
    private final String clientAssertionKeystorePassword;
    private final String clientAssertionKeystoreKeyAlias;
    private final String clientAssertionKeystoreKeyPassword;

    public RemoteRuntimeClientAuthProperties(Properties properties) {
        this.method = PropertiesUtil.getPropertyOrDefault(properties, PROPERTY_NAME_METHOD, v -> AuthMethod.valueOf(v.toLowerCase()), AuthMethod.none);
        this.username = PropertiesUtil.getPropertyOrNull(properties, PROPERTY_NAME_USERNAME);
        this.password = PropertiesUtil.getPropertyOrNull(properties, PROPERTY_NAME_PASSWORD);
        this.clientId = PropertiesUtil.getPropertyOrNull(properties, PROPERTY_NAME_CLIENT_ID);
        this.clientSecret = PropertiesUtil.getPropertyOrNull(properties, PROPERTY_NAME_CLIENT_SECRET);
        this.tokenUrl = PropertiesUtil.getPropertyOrNull(properties, PROPERTY_NAME_TOKEN_URL, URI::create);
        this.audience = PropertiesUtil.getPropertyOrNull(properties, PROPERTY_NAME_AUDIENCE);
        this.scope = PropertiesUtil.getPropertyOrNull(properties, PROPERTY_NAME_SCOPE);
        this.resource = PropertiesUtil.getPropertyOrNull(properties, PROPERTY_NAME_RESOURCE);
        this.keystorePath = PropertiesUtil.getPropertyOrNull(properties, PROPERTY_NAME_KEYSTORE_PATH, x$0 -> Paths.get(x$0, new String[0]));
        this.keystorePassword = PropertiesUtil.getPropertyOrNull(properties, PROPERTY_NAME_KEYSTORE_PASSWORD);
        this.keystoreKeyPassword = PropertiesUtil.getPropertyOrNull(properties, PROPERTY_NAME_KEYSTORE_KEY_PASSWORD);
        this.truststorePath = PropertiesUtil.getPropertyOrNull(properties, PROPERTY_NAME_TRUSTSTORE_PATH, x$0 -> Paths.get(x$0, new String[0]));
        this.truststorePassword = PropertiesUtil.getPropertyOrNull(properties, PROPERTY_NAME_TRUSTSTORE_PASSWORD);
        this.credentialsCachePath = PropertiesUtil.getPropertyOrDefault(properties, PROPERTY_NAME_CREDENTIALS_CACHE_PATH, OAuthCredentialsProviderBuilder.DEFAULT_CREDENTIALS_CACHE_PATH);
        this.connectTimeout = PropertiesUtil.getPropertyOrDefault(properties, PROPERTY_NAME_CONNECT_TIMEOUT, v -> {
            try {
                return Duration.parse(v);
            }
            catch (Throwable t) {
                return OAuthCredentialsProviderBuilder.DEFAULT_CONNECT_TIMEOUT;
            }
        }, OAuthCredentialsProviderBuilder.DEFAULT_CONNECT_TIMEOUT);
        this.readTimeout = PropertiesUtil.getPropertyOrDefault(properties, PROPERTY_NAME_READ_TIMEOUT, v -> {
            try {
                return Duration.parse(v);
            }
            catch (Throwable t) {
                return OAuthCredentialsProviderBuilder.DEFAULT_READ_TIMEOUT;
            }
        }, OAuthCredentialsProviderBuilder.DEFAULT_READ_TIMEOUT);
        this.clientAssertionKeystorePath = PropertiesUtil.getPropertyOrNull(properties, PROPERTY_NAME_CLIENT_ASSERTION_KEYSTORE_PATH, x$0 -> Paths.get(x$0, new String[0]));
        this.clientAssertionKeystorePassword = PropertiesUtil.getPropertyOrNull(properties, PROPERTY_NAME_CLIENT_ASSERTION_KEYSTORE_PASSWORD);
        this.clientAssertionKeystoreKeyAlias = PropertiesUtil.getPropertyOrNull(properties, PROPERTY_NAME_CLIENT_ASSERTION_KEYSTORE_KEY_ALIAS);
        this.clientAssertionKeystoreKeyPassword = PropertiesUtil.getPropertyOrNull(properties, PROPERTY_NAME_CLIENT_ASSERTION_KEYSTORE_KEY_PASSWORD);
    }

    public AuthMethod getMethod() {
        return this.method;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public URI getTokenUrl() {
        return this.tokenUrl;
    }

    public String getAudience() {
        return this.audience;
    }

    public String getScope() {
        return this.scope;
    }

    public String getResource() {
        return this.resource;
    }

    public Path getKeystorePath() {
        return this.keystorePath;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public String getKeystoreKeyPassword() {
        return this.keystoreKeyPassword;
    }

    public Path getTruststorePath() {
        return this.truststorePath;
    }

    public String getTruststorePassword() {
        return this.truststorePassword;
    }

    public String getCredentialsCachePath() {
        return this.credentialsCachePath;
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    public Path getClientAssertionKeystorePath() {
        return this.clientAssertionKeystorePath;
    }

    public String getClientAssertionKeystorePassword() {
        return this.clientAssertionKeystorePassword;
    }

    public String getClientAssertionKeystoreKeyAlias() {
        return this.clientAssertionKeystoreKeyAlias;
    }

    public String getClientAssertionKeystoreKeyPassword() {
        return this.clientAssertionKeystoreKeyPassword;
    }

    public static enum AuthMethod {
        none,
        oidc,
        basic;

    }
}

