/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.runtime.util;

import io.camunda.process.test.impl.runtime.util.PropertiesUtil;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionedPropertiesUtil {
    public static final String SNAPSHOT_VERSION = "SNAPSHOT";
    private static final Pattern SEMANTIC_VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)(-.*)?");
    private static final String VERSION_FORMAT = "%d.%d.%d";
    private static final String LABELED_VERSION_FORMAT = "%d.%d.%d%s";

    public static String getLatestReleasedVersion(Properties properties, String propertyName, String defaultValue) {
        return PropertiesUtil.getPropertyOrDefault(properties, propertyName, propertyValue -> Optional.of(propertyValue).map(SEMANTIC_VERSION_PATTERN::matcher).filter(Matcher::find).map(matcher -> {
            int major = Integer.parseInt(matcher.group(1));
            int minor = Integer.parseInt(matcher.group(2));
            int patch = Integer.parseInt(matcher.group(3));
            String label = matcher.group(4);
            return VersionedPropertiesUtil.getLatestReleasedVersion(major, minor, patch, label);
        }).orElse((String)propertyValue), defaultValue);
    }

    private static String getLatestReleasedVersion(int major, int minor, int patch, String label) {
        if (label == null) {
            return String.format(VERSION_FORMAT, major, minor, patch);
        }
        if (!label.contains(SNAPSHOT_VERSION)) {
            return String.format(LABELED_VERSION_FORMAT, major, minor, patch, label);
        }
        if (patch == 0) {
            return SNAPSHOT_VERSION;
        }
        int previousPatchVersion = patch - 1;
        return String.format(VERSION_FORMAT, major, minor, previousPatchVersion);
    }
}

