/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.testresult;

import io.camunda.client.api.search.response.ElementInstance;
import io.camunda.client.api.search.response.Incident;
import io.camunda.client.api.search.response.MessageSubscription;
import io.camunda.client.api.search.response.ProcessInstance;
import io.camunda.process.test.impl.testresult.ProcessInstanceResult;
import io.camunda.process.test.impl.testresult.ProcessTestResult;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class CamundaProcessTestResultPrinter {
    private static final String NO_ENTRIES = "<None>";
    private static final int MAX_VALUE_LENGTH = 500;
    private final Consumer<String> printStream;

    public CamundaProcessTestResultPrinter(Consumer<String> printStream) {
        this.printStream = printStream;
    }

    public void print(ProcessTestResult result) {
        String formattedResult = this.formatResult(result);
        this.printStream.accept(formattedResult);
    }

    private String formatResult(ProcessTestResult result) {
        return "Process test results:\n=====================\n\n" + CamundaProcessTestResultPrinter.formatProcessInstances(result.getProcessInstanceTestResults()) + "\n=====================\n";
    }

    private static String formatProcessInstances(List<ProcessInstanceResult> processInstanceResults) {
        return processInstanceResults.stream().map(CamundaProcessTestResultPrinter::formatProcessInstance).collect(Collectors.joining("\n---------------------\n\n"));
    }

    private static String formatProcessInstance(ProcessInstanceResult result) {
        ProcessInstance processInstance = result.getProcessInstance();
        String formattedProcessInstance = String.format("Process instance: %d [process-id: '%s', state: %s]", processInstance.getProcessInstanceKey(), processInstance.getProcessDefinitionId(), processInstance.getState().name().toLowerCase());
        return formattedProcessInstance + "\n\nActive elements:\n" + CamundaProcessTestResultPrinter.formatElementInstances(result.getActiveElementInstances()) + "\n\nVariables:\n" + CamundaProcessTestResultPrinter.formatVariables(result.getVariables()) + "\n\nActive incidents:\n" + CamundaProcessTestResultPrinter.formatIncidents(result.getActiveIncidents()) + "\n\nActive message subscriptions:\n" + CamundaProcessTestResultPrinter.formatMessageSubscriptions(result.getActiveMessageSubscriptions());
    }

    private static String formatVariables(Map<String, String> variables) {
        if (variables.isEmpty()) {
            return NO_ENTRIES;
        }
        return variables.entrySet().stream().map(variable -> CamundaProcessTestResultPrinter.formatVariable((String)variable.getKey(), (String)variable.getValue())).collect(Collectors.joining("\n"));
    }

    private static String formatVariable(String key, String value) {
        return String.format("- '%s': %s", key, CamundaProcessTestResultPrinter.abbreviate(value));
    }

    private static String abbreviate(String value) {
        return StringUtils.abbreviate((String)value, (int)500);
    }

    private static String formatIncidents(List<Incident> incidents) {
        if (incidents.isEmpty()) {
            return NO_ENTRIES;
        }
        return incidents.stream().map(CamundaProcessTestResultPrinter::formatIncident).collect(Collectors.joining("\n"));
    }

    private static String formatIncident(Incident incident) {
        return String.format("- '%s' [type: %s] \"%s\"", incident.getElementId(), incident.getErrorType(), CamundaProcessTestResultPrinter.abbreviate(incident.getErrorMessage()));
    }

    private static String formatElementInstances(List<ElementInstance> elementInstances) {
        if (elementInstances.isEmpty()) {
            return NO_ENTRIES;
        }
        return elementInstances.stream().map(CamundaProcessTestResultPrinter::formatElementInstance).collect(Collectors.joining("\n"));
    }

    private static String formatElementInstance(ElementInstance elementInstance) {
        String name = Optional.ofNullable(elementInstance.getElementName()).orElse("");
        return String.format("- '%s' [name: '%s']", elementInstance.getElementId(), name);
    }

    private static String formatMessageSubscriptions(List<MessageSubscription> messageSubscriptions) {
        if (messageSubscriptions.isEmpty()) {
            return NO_ENTRIES;
        }
        return messageSubscriptions.stream().map(CamundaProcessTestResultPrinter::formatMessageSubscription).collect(Collectors.joining("\n"));
    }

    private static String formatMessageSubscription(MessageSubscription subscription) {
        return String.format("- '%s' [message-name: '%s', correlation-key: '%s']", subscription.getElementId(), subscription.getMessageName(), subscription.getCorrelationKey());
    }
}

