/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.configuration;

import io.camunda.process.test.api.CamundaProcessTestRuntimeMode;
import io.camunda.process.test.impl.configuration.CoverageReportConfiguration;
import io.camunda.process.test.impl.configuration.LegacyCamundaProcessTestRuntimeConfiguration;
import io.camunda.process.test.impl.configuration.RemoteConfiguration;
import io.camunda.process.test.impl.runtime.CamundaProcessTestRuntimeDefaults;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@ConfigurationProperties(prefix="camunda.process-test")
public class CamundaProcessTestRuntimeConfiguration {
    private String camundaDockerImageName = CamundaProcessTestRuntimeDefaults.CAMUNDA_DOCKER_IMAGE_NAME;
    private String camundaDockerImageVersion = CamundaProcessTestRuntimeDefaults.CAMUNDA_DOCKER_IMAGE_VERSION;
    private Map<String, String> camundaEnvVars = Collections.emptyMap();
    private List<Integer> camundaExposedPorts = Collections.emptyList();
    private boolean connectorsEnabled = false;
    private String connectorsDockerImageName = CamundaProcessTestRuntimeDefaults.CONNECTORS_DOCKER_IMAGE_NAME;
    private String connectorsDockerImageVersion = CamundaProcessTestRuntimeDefaults.CONNECTORS_DOCKER_IMAGE_VERSION;
    private Map<String, String> connectorsEnvVars = Collections.emptyMap();
    private Map<String, String> connectorsSecrets = Collections.emptyMap();
    private List<Integer> connectorsExposedPorts = Collections.emptyList();
    private String camundaLoggerName = "tc.camunda";
    private String connectorsLoggerName = "tc.connectors";
    private boolean multiTenancyEnabled = false;
    private CamundaProcessTestRuntimeMode runtimeMode = CamundaProcessTestRuntimeMode.MANAGED;
    @NestedConfigurationProperty
    private RemoteConfiguration remote = new RemoteConfiguration();
    @NestedConfigurationProperty
    private CoverageReportConfiguration coverage = new CoverageReportConfiguration();

    @Bean
    @Primary
    public CamundaProcessTestRuntimeConfiguration runtimeConfiguration(LegacyCamundaProcessTestRuntimeConfiguration legacyConfiguration) {
        CamundaProcessTestRuntimeConfiguration mergedConfig = new CamundaProcessTestRuntimeConfiguration();
        BeanUtils.copyProperties((Object)legacyConfiguration, (Object)mergedConfig);
        return mergedConfig;
    }

    @Deprecated
    public String getCamundaVersion() {
        return this.getCamundaDockerImageVersion();
    }

    @Deprecated
    public void setCamundaVersion(String camundaDockerImageVersion) {
        this.camundaDockerImageVersion = camundaDockerImageVersion;
    }

    public String getCamundaDockerImageVersion() {
        return this.camundaDockerImageVersion;
    }

    public void setCamundaDockerImageVersion(String camundaDockerImageVersion) {
        this.camundaDockerImageVersion = camundaDockerImageVersion;
    }

    public String getCamundaDockerImageName() {
        return this.camundaDockerImageName;
    }

    public void setCamundaDockerImageName(String camundaDockerImageName) {
        this.camundaDockerImageName = camundaDockerImageName;
    }

    public Map<String, String> getCamundaEnvVars() {
        return this.camundaEnvVars;
    }

    public void setCamundaEnvVars(Map<String, String> camundaEnvVars) {
        this.camundaEnvVars = camundaEnvVars;
    }

    public List<Integer> getCamundaExposedPorts() {
        return this.camundaExposedPorts;
    }

    public void setCamundaExposedPorts(List<Integer> camundaExposedPorts) {
        this.camundaExposedPorts = camundaExposedPorts;
    }

    public boolean isConnectorsEnabled() {
        return this.connectorsEnabled;
    }

    public void setConnectorsEnabled(boolean connectorsEnabled) {
        this.connectorsEnabled = connectorsEnabled;
    }

    public String getConnectorsDockerImageName() {
        return this.connectorsDockerImageName;
    }

    public void setConnectorsDockerImageName(String connectorsDockerImageName) {
        this.connectorsDockerImageName = connectorsDockerImageName;
    }

    public String getConnectorsDockerImageVersion() {
        return this.connectorsDockerImageVersion;
    }

    public void setConnectorsDockerImageVersion(String connectorsDockerImageVersion) {
        this.connectorsDockerImageVersion = connectorsDockerImageVersion;
    }

    public Map<String, String> getConnectorsEnvVars() {
        return this.connectorsEnvVars;
    }

    public void setConnectorsEnvVars(Map<String, String> connectorsEnvVars) {
        this.connectorsEnvVars = connectorsEnvVars;
    }

    public Map<String, String> getConnectorsSecrets() {
        return this.connectorsSecrets;
    }

    public void setConnectorsSecrets(Map<String, String> connectorsSecrets) {
        this.connectorsSecrets = connectorsSecrets;
    }

    public List<Integer> getConnectorsExposedPorts() {
        return this.connectorsExposedPorts;
    }

    public void setConnectorsExposedPorts(List<Integer> connectorsExposedPorts) {
        this.connectorsExposedPorts = connectorsExposedPorts;
    }

    public String getCamundaLoggerName() {
        return this.camundaLoggerName;
    }

    public void setCamundaLoggerName(String camundaLoggerName) {
        this.camundaLoggerName = camundaLoggerName;
    }

    public String getConnectorsLoggerName() {
        return this.connectorsLoggerName;
    }

    public void setConnectorsLoggerName(String connectorsLoggerName) {
        this.connectorsLoggerName = connectorsLoggerName;
    }

    public CamundaProcessTestRuntimeMode getRuntimeMode() {
        return this.runtimeMode;
    }

    public void setRuntimeMode(CamundaProcessTestRuntimeMode runtimeMode) {
        this.runtimeMode = runtimeMode;
    }

    public RemoteConfiguration getRemote() {
        return this.remote;
    }

    public void setRemote(RemoteConfiguration remote) {
        this.remote = remote;
    }

    public boolean isMultiTenancyEnabled() {
        return this.multiTenancyEnabled;
    }

    public void setMultiTenancyEnabled(boolean multiTenancyEnabled) {
        this.multiTenancyEnabled = multiTenancyEnabled;
    }

    public CoverageReportConfiguration getCoverage() {
        return this.coverage;
    }

    public void setCoverage(CoverageReportConfiguration coverage) {
        this.coverage = coverage;
    }
}

