/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.spring.bean;

import io.camunda.client.bean.BeanInfo;
import io.camunda.client.bean.MethodInfo;
import io.camunda.client.bean.ParameterInfo;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.StandardReflectionParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationUtils;

public class SpringMethodInfo
implements MethodInfo {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final StandardReflectionParameterNameDiscoverer PARAMETER_NAME_DISCOVERER = new StandardReflectionParameterNameDiscoverer();
    private final BeanInfo beanInfo;
    private final Method method;

    public SpringMethodInfo(BeanInfo beanInfo, Method method) {
        this.beanInfo = beanInfo;
        this.method = method;
    }

    @Override
    public BeanInfo getBeanInfo() {
        return this.beanInfo;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public List<ParameterInfo> getParameters() {
        return this.getParametersFiltered(parameter -> true);
    }

    @Override
    public <T extends Annotation> Optional<T> getAnnotation(Class<T> type) {
        return Optional.ofNullable(AnnotationUtils.findAnnotation((Method)this.method, type));
    }

    @Override
    public List<ParameterInfo> getParametersFilteredByAnnotation(Class<? extends Annotation> type) {
        return this.getParametersFiltered(parameter -> parameter.isAnnotationPresent(type));
    }

    @Override
    public Object invoke(Object ... args) throws Exception {
        try {
            return this.method.invoke(this.beanInfo.getBeanSupplier().get(), args);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof Exception) {
                throw (Exception)targetException;
            }
            throw new RuntimeException("Failed to invoke method: " + this.method.getName(), targetException);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to invoke method: " + this.method.getName(), e);
        }
    }

    private List<ParameterInfo> getParametersFiltered(Predicate<Parameter> filter) {
        Parameter[] parameters = this.method.getParameters();
        String[] parameterNames = this.getParameterNames();
        ArrayList<ParameterInfo> result = new ArrayList<ParameterInfo>();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            if (!filter.test(parameter)) continue;
            String parameterName = parameterNames[i];
            ParameterInfo parameterInfo = ParameterInfo.builder().parameterName(parameterName).parameter(parameter).methodInfo(this).build();
            result.add(parameterInfo);
        }
        return result;
    }

    private String[] getParameterNames() {
        String[] parameterNames = PARAMETER_NAME_DISCOVERER.getParameterNames(this.method);
        if (parameterNames == null) {
            LOG.warn("Parameter names of method " + this.method.getName() + " could not be discovered. Please set compiler flag -parameters if you rely on parameter names (e.g. for variable names to fetch from Zeebe)");
            Parameter[] parameters = this.method.getParameters();
            parameterNames = new String[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                parameterNames[i] = "arg" + i;
            }
        }
        return parameterNames;
    }
}

