/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.core;

import com.ruiyun.jvppeteer.core.Constant;
import com.ruiyun.jvppeteer.core.Environment;
import com.ruiyun.jvppeteer.core.browser.Browser;
import com.ruiyun.jvppeteer.core.browser.BrowserFetcher;
import com.ruiyun.jvppeteer.launch.ChromeLauncher;
import com.ruiyun.jvppeteer.launch.FirefoxLauncher;
import com.ruiyun.jvppeteer.launch.Launcher;
import com.ruiyun.jvppeteer.options.BrowserOptions;
import com.ruiyun.jvppeteer.options.ChromeArgOptions;
import com.ruiyun.jvppeteer.options.FetcherOptions;
import com.ruiyun.jvppeteer.options.LaunchOptions;
import com.ruiyun.jvppeteer.options.LaunchOptionsBuilder;
import com.ruiyun.jvppeteer.transport.ConnectionTransport;
import com.ruiyun.jvppeteer.util.StringUtil;
import java.io.IOException;
import java.util.List;

public class Puppeteer {
    private String productName = null;
    private Launcher launcher;
    private Environment env = null;
    private String projectRoot = System.getProperty("user.dir");
    private String preferredRevision = "722234";
    private boolean isPuppeteerCore;

    public Puppeteer() {
    }

    public Puppeteer(String projectRoot, String preferredRevision, boolean isPuppeteerCore, String productName) {
        this.projectRoot = projectRoot;
        this.preferredRevision = StringUtil.isEmpty(preferredRevision) ? "722234" : preferredRevision;
        this.isPuppeteerCore = isPuppeteerCore;
        this.productName = productName;
    }

    public static Browser launch() throws IOException {
        return Puppeteer.rawLaunch();
    }

    public static Browser launch(boolean headless) throws IOException {
        return Puppeteer.rawLaunch(headless);
    }

    public static Browser launch(LaunchOptions options) throws IOException {
        Puppeteer puppeteer = new Puppeteer();
        return Puppeteer.rawLaunch(options, puppeteer);
    }

    private static Browser rawLaunch() throws IOException {
        return Puppeteer.rawLaunch(true);
    }

    private static Browser rawLaunch(boolean headless) throws IOException {
        Puppeteer puppeteer = new Puppeteer();
        return Puppeteer.rawLaunch(new LaunchOptionsBuilder().withHeadless(headless).build(), puppeteer);
    }

    private static Browser connect(BrowserOptions options, String browserWSEndpoint, String browserURL, ConnectionTransport transport, String product) {
        Puppeteer puppeteer = new Puppeteer();
        if (StringUtil.isNotEmpty(product)) {
            puppeteer.setProductName(product);
        }
        Puppeteer.adapterLauncher(puppeteer);
        return puppeteer.getLauncher().connect(options, browserWSEndpoint, browserURL, transport);
    }

    public static Browser connect(BrowserOptions options, String browserWSEndpoint, String browserURL, ConnectionTransport transport) {
        return Puppeteer.connect(options, browserWSEndpoint, browserURL, transport, null);
    }

    public static Browser connect(String browserWSEndpoint, String browserURL, ConnectionTransport transport) {
        return Puppeteer.connect(new BrowserOptions(), browserWSEndpoint, browserURL, transport, null);
    }

    public static Browser connect(String browserWSEndpointOrURL) {
        if (browserWSEndpointOrURL.contains(":")) {
            return Puppeteer.connect(null, browserWSEndpointOrURL, null);
        }
        return Puppeteer.connect(browserWSEndpointOrURL, null, null);
    }

    public static Browser connect(ConnectionTransport transport) {
        return Puppeteer.connect(null, null, transport);
    }

    private static Browser rawLaunch(LaunchOptions options, Puppeteer puppeteer) throws IOException {
        if (StringUtil.isNotBlank(options.getProduct())) {
            puppeteer.setProductName(options.getProduct());
        }
        Puppeteer.adapterLauncher(puppeteer);
        return puppeteer.getLauncher().launch(options);
    }

    private static void adapterLauncher(Puppeteer puppeteer) {
        String productName = puppeteer.getProductName();
        if (StringUtil.isEmpty(productName) && !puppeteer.getIsPuppeteerCore()) {
            Environment env = puppeteer.getEnv();
            if (env == null) {
                env = System::getenv;
                puppeteer.setEnv(env);
            }
            for (int i = 0; i < Constant.PRODUCT_ENV.length; ++i) {
                String envProductName = Constant.PRODUCT_ENV[i];
                productName = env.getEnv(envProductName);
                if (!StringUtil.isNotEmpty(productName)) continue;
                puppeteer.setProductName(productName);
                break;
            }
        }
        if (StringUtil.isEmpty(productName)) {
            productName = "chrome";
            puppeteer.setProductName(productName);
        }
        switch (productName) {
            case "firefox": {
                FirefoxLauncher firefoxLauncher = new FirefoxLauncher(puppeteer.getIsPuppeteerCore());
            }
        }
        ChromeLauncher launcher = new ChromeLauncher(puppeteer.getProjectRoot(), puppeteer.getPreferredRevision(), puppeteer.getIsPuppeteerCore());
        puppeteer.setLauncher(launcher);
    }

    public static Browser launch(LaunchOptions options, String version) throws IOException {
        Puppeteer puppeteer = new Puppeteer();
        if (StringUtil.isNotEmpty(version)) {
            puppeteer.setPreferredRevision(version);
        }
        return Puppeteer.rawLaunch(options, puppeteer);
    }

    public List<String> defaultArgs(ChromeArgOptions options) {
        return this.getLauncher().defaultArgs(options);
    }

    public String executablePath() throws IOException {
        return this.getLauncher().executablePath();
    }

    public BrowserFetcher createBrowserFetcher() {
        return new BrowserFetcher(this.getProjectRoot(), new FetcherOptions());
    }

    public BrowserFetcher createBrowserFetcher(FetcherOptions options) {
        return new BrowserFetcher(this.getProjectRoot(), options);
    }

    private String getProductName() {
        return this.productName;
    }

    private void setProductName(String productName) {
        this.productName = productName;
    }

    private boolean getIsPuppeteerCore() {
        return this.isPuppeteerCore;
    }

    private Launcher getLauncher() {
        return this.launcher;
    }

    private void setLauncher(Launcher launcher) {
        this.launcher = launcher;
    }

    private Environment getEnv() {
        return this.env;
    }

    private void setEnv(Environment env) {
        this.env = env;
    }

    public String getProjectRoot() {
        return this.projectRoot;
    }

    public void setProjectRoot(String projectRoot) {
        this.projectRoot = projectRoot;
    }

    public String getPreferredRevision() {
        return this.preferredRevision;
    }

    public void setPreferredRevision(String preferredRevision) {
        this.preferredRevision = preferredRevision;
    }
}

