/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaoding.open.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import io.github.gaoding.open.client.BaseClient;
import io.github.gaoding.open.constant.BizCode;
import io.github.gaoding.open.model.Config;
import io.github.gaoding.open.model.HttpRequestEntity;
import io.github.gaoding.open.model.HttpResponse;
import io.github.gaoding.open.model.Method;
import io.github.gaoding.open.model.Response;
import io.github.gaoding.open.model.ValidateUil;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

public abstract class HttpClient
extends BaseClient {
    public HttpClient(Config conf) {
        super(conf);
    }

    @Override
    protected boolean check(String uri, Method method, String requestBody) {
        return ValidateUil.isHttpUri(uri) && ValidateUil.isHttpMethod(method.getName());
    }

    @Override
    protected final <T> Response<T> doExecute(String uri, Method method, String requestBody, String queryString, Map<String, String> headers, Long time, String sign, Class<T> clazz, Function<? super HttpResponse, ? extends Response<T>> mapper) {
        Map<String, String> methodHeaders = method.getHeaders();
        this.fillHeaders(methodHeaders, sign, time);
        if (headers != null) {
            methodHeaders.putAll(headers);
        }
        String serverAddr = StringUtils.isNotBlank((CharSequence)System.getenv("GAODING_OPEN_SERVER_ADDRESS")) ? System.getenv("GAODING_OPEN_SERVER_ADDRESS") : "https://open-v3.gaoding.com";
        String url = StringUtils.isBlank((CharSequence)queryString) ? serverAddr + uri : serverAddr + uri + "?" + queryString;
        HttpRequestEntity httpRequestEntity = new HttpRequestEntity(url, method.getName(), methodHeaders, requestBody);
        HttpResponse httpResponse = this.doSend().apply(httpRequestEntity);
        if (mapper != null) {
            return mapper.apply(httpResponse);
        }
        if (!httpResponse.isSuccess()) {
            if (httpResponse.isNotAuth()) {
                return Response.fail(BizCode.CHECK_SIGN_ERROR, 401);
            }
            Response response = (Response)JSON.parseObject((String)httpResponse.getBody(), Response.class);
            response.setHttpStatus(httpResponse.getStatus());
            return response;
        }
        TypeReference typeRef = new TypeReference<Response<T>>(){};
        Response tResponse = (Response)JSON.parseObject((String)httpResponse.getBody(), (TypeReference)typeRef, (Feature[])new Feature[0]);
        tResponse.setHttpStatus(httpResponse.getStatus());
        tResponse.setOriginResponse(httpResponse.getBody());
        return tResponse;
    }

    protected abstract Function<? super HttpRequestEntity, ? extends HttpResponse> doSend();

    private void fillHeaders(Map<String, String> headers, String sign, Long time) {
        headers.put("X-Timestamp", String.valueOf(time));
        headers.put("X-AccessKey", this.config.getAccessKey());
        headers.put("X-Signature", sign);
    }
}

