/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.core;

import cn.hutool.core.collection.CollUtil;
import com.dtp.common.VariableLinkedBlockingQueue;
import com.dtp.common.config.DtpProperties;
import com.dtp.common.config.ThreadPoolProperties;
import com.dtp.common.dto.DtpMainProp;
import com.dtp.common.dto.NotifyItem;
import com.dtp.common.em.NotifyTypeEnum;
import com.dtp.common.em.QueueTypeEnum;
import com.dtp.common.ex.DtpException;
import com.dtp.core.context.DtpContext;
import com.dtp.core.context.DtpContextHolder;
import com.dtp.core.convert.ExecutorConverter;
import com.dtp.core.handler.NotifierHandler;
import com.dtp.core.notify.AlarmLimiter;
import com.dtp.core.notify.NotifyHelper;
import com.dtp.core.reject.RejectHandlerGetter;
import com.dtp.core.support.ThreadPoolCreator;
import com.dtp.core.thread.DtpExecutor;
import com.dtp.core.thread.ThreadPoolBuilder;
import com.github.dadiyang.equator.Equator;
import com.github.dadiyang.equator.FieldInfo;
import com.github.dadiyang.equator.GetterBaseEquator;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class DtpRegistry
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(DtpRegistry.class);
    private static final ExecutorService NOTIFY_EXECUTOR = ThreadPoolCreator.createWithTtl("dtp-notify");
    private static final Map<String, DtpExecutor> DTP_REGISTRY = new ConcurrentHashMap<String, DtpExecutor>();
    private static final Equator EQUATOR = new GetterBaseEquator();
    private static DtpProperties dtpProperties;

    public static void register(DtpExecutor executor, String source) {
        log.info("DynamicTp register, source: {}, executor: {}", (Object)source, (Object)ExecutorConverter.convert(executor));
        DTP_REGISTRY.put(executor.getThreadPoolName(), executor);
    }

    public static DtpExecutor getExecutor(String name) {
        DtpExecutor executor = DTP_REGISTRY.get(name);
        if (Objects.isNull(executor)) {
            log.error("Cannot find a specified DynamicTp, name: {}", (Object)name);
            throw new DtpException("Cannot find a specified DynamicTp, name: " + name);
        }
        return executor;
    }

    public static void refresh(DtpProperties properties) {
        if (Objects.isNull(properties) || CollUtil.isEmpty((Collection)properties.getExecutors())) {
            log.warn("DynamicTp refresh, empty threadPoolProperties.");
            return;
        }
        properties.getExecutors().forEach(x -> {
            if (StringUtils.isBlank((CharSequence)x.getThreadPoolName())) {
                log.warn("DynamicTp refresh, threadPoolName must not be empty.");
                return;
            }
            DtpExecutor dtpExecutor = DTP_REGISTRY.get(x.getThreadPoolName());
            if (Objects.isNull(dtpExecutor)) {
                log.warn("DynamicTp refresh, cannot find specified executor, name: {}.", (Object)x.getThreadPoolName());
                return;
            }
            DtpRegistry.refresh(dtpExecutor, x);
        });
    }

    public static void refresh(DtpExecutor executor, ThreadPoolProperties properties) {
        boolean ifNotice;
        DtpMainProp oldProp = ExecutorConverter.convert(executor);
        DtpRegistry.doRefresh(executor, properties);
        DtpMainProp newProp = ExecutorConverter.convert(executor);
        if (oldProp.equals((Object)newProp)) {
            log.warn("DynamicTp [{}] has no properties changed.", (Object)executor.getThreadPoolName());
            return;
        }
        List diffFields = EQUATOR.getDiffFields((Object)oldProp, (Object)newProp);
        List diffKeys = diffFields.stream().map(FieldInfo::getFieldName).collect(Collectors.toList());
        log.info("DynamicTp [{}] refreshed end, changed keys: {}, corePoolSize: [{}], maxPoolSize: [{}], queueType: [{}], queueCapacity: [{}], keepAliveTime: [{}], rejectedType: [{}], allowsCoreThreadTimeOut: [{}]", new Object[]{executor.getThreadPoolName(), diffKeys, String.format("%s => %s", oldProp.getCorePoolSize(), newProp.getCorePoolSize()), String.format("%s => %s", oldProp.getMaxPoolSize(), newProp.getMaxPoolSize()), String.format("%s => %s", oldProp.getQueueType(), newProp.getQueueType()), String.format("%s => %s", oldProp.getQueueCapacity(), newProp.getQueueCapacity()), String.format("%ss => %ss", oldProp.getKeepAliveTime(), newProp.getKeepAliveTime()), String.format("%s => %s", oldProp.getRejectType(), newProp.getRejectType()), String.format("%s => %s", oldProp.isAllowCoreThreadTimeOut(), newProp.isAllowCoreThreadTimeOut())});
        NotifyItem notifyItem = NotifyHelper.getNotifyItem(executor, NotifyTypeEnum.CHANGE);
        boolean bl = ifNotice = CollUtil.isNotEmpty((Collection)dtpProperties.getPlatforms()) && Objects.nonNull(notifyItem) && notifyItem.isEnabled();
        if (!ifNotice) {
            return;
        }
        DtpContext context = DtpContext.builder().dtpExecutor(executor).platforms(dtpProperties.getPlatforms()).notifyItem(notifyItem).build();
        DtpContextHolder.set(context);
        NOTIFY_EXECUTOR.execute(() -> NotifierHandler.getInstance().sendNotice(oldProp, diffKeys));
    }

    public static void doRefresh(DtpExecutor dtpExecutor, ThreadPoolProperties properties) {
        if (properties.getMaximumPoolSize() >= 0) {
            dtpExecutor.setMaximumPoolSize(properties.getMaximumPoolSize());
        }
        if (properties.getCorePoolSize() > dtpExecutor.getMaximumPoolSize()) {
            throw new IllegalArgumentException();
        }
        if (properties.getCorePoolSize() >= 0) {
            dtpExecutor.setCorePoolSize(properties.getCorePoolSize());
        }
        if (properties.getKeepAliveTime() > 0L && properties.getUnit() != null) {
            dtpExecutor.setKeepAliveTime(properties.getKeepAliveTime(), properties.getUnit());
        }
        dtpExecutor.allowCoreThreadTimeOut(properties.isAllowCoreThreadTimeOut());
        String originRejectedName = dtpExecutor.getRejectHandlerName();
        if (StringUtils.isNotBlank((CharSequence)properties.getRejectedHandlerType()) && !originRejectedName.contains(properties.getRejectedHandlerType())) {
            dtpExecutor.setRejectedExecutionHandler(RejectHandlerGetter.getProxy(properties.getRejectedHandlerType()));
            dtpExecutor.setRejectHandlerName(properties.getRejectedHandlerType());
        }
        if (properties.getQueueCapacity() > 0 && Objects.equals(properties.getQueueType(), QueueTypeEnum.VARIABLE_LINKED_BLOCKING_QUEUE.getName())) {
            BlockingQueue<Runnable> blockingQueue = dtpExecutor.getQueue();
            if (blockingQueue instanceof VariableLinkedBlockingQueue) {
                ((VariableLinkedBlockingQueue)blockingQueue).setCapacity(properties.getQueueCapacity());
            } else {
                log.error("DynamicTp refresh, the blockingqueue capacity cannot be reset, dtpName: {}, queueType {}", (Object)dtpExecutor.getThreadPoolName(), (Object)dtpExecutor.getQueueName());
            }
        }
        if (CollUtil.isEmpty((Collection)properties.getNotifyItems())) {
            dtpExecutor.setNotifyItems(NotifyItem.getDefaultNotifyItems());
            return;
        }
        NotifyHelper.setExecutorNotifyItems(dtpExecutor, dtpProperties, properties);
        dtpExecutor.setNotifyItems(properties.getNotifyItems());
    }

    public static List<String> listAllDtpNames() {
        return Lists.newArrayList(DTP_REGISTRY.keySet());
    }

    @Autowired
    public void setDtpProperties(DtpProperties dtpProperties) {
        DtpRegistry.dtpProperties = dtpProperties;
    }

    public void afterPropertiesSet() {
        if (CollectionUtils.isEmpty((Collection)dtpProperties.getExecutors())) {
            return;
        }
        dtpProperties.getExecutors().forEach(x -> {
            DtpExecutor executor = ThreadPoolBuilder.newBuilder().corePoolSize(x.getCorePoolSize()).maximumPoolSize(x.getMaximumPoolSize()).keepAliveTime(x.getKeepAliveTime()).workQueue(x.getQueueType(), x.getQueueCapacity(), x.isFair()).rejectedExecutionHandler(x.getRejectedHandlerType()).threadFactory(x.getThreadNamePrefix()).allowCoreThreadTimeOut(x.isAllowCoreThreadTimeOut()).threadPoolName(x.getThreadPoolName()).notifyItems(x.getNotifyItems()).buildDynamic();
            DtpRegistry.register(executor, "configuration");
        });
        DTP_REGISTRY.forEach((k, v) -> {
            NotifyHelper.fillNotifyItems(dtpProperties.getPlatforms(), v.getNotifyItems());
            v.getNotifyItems().forEach(x -> AlarmLimiter.initAlarmLimiter(k, x));
        });
    }
}

