/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.core.monitor;

import cn.hutool.core.collection.CollUtil;
import com.dtp.common.config.DtpProperties;
import com.dtp.common.dto.ThreadPoolStats;
import com.dtp.common.em.NotifyTypeEnum;
import com.dtp.common.event.CollectEvent;
import com.dtp.core.DtpRegistry;
import com.dtp.core.convert.MetricsConverter;
import com.dtp.core.handler.CollectorHandler;
import com.dtp.core.notify.AlarmManager;
import com.dtp.core.thread.DtpExecutor;
import com.dtp.core.thread.NamedThreadFactory;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.ApplicationEventMulticaster;

public class DtpMonitor
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(DtpMonitor.class);
    private static final List<NotifyTypeEnum> ALARM_TYPES = Lists.newArrayList((Object[])new NotifyTypeEnum[]{NotifyTypeEnum.LIVENESS, NotifyTypeEnum.CAPACITY});
    private static final ScheduledExecutorService MONITOR_EXECUTOR = new ScheduledThreadPoolExecutor(1, new NamedThreadFactory("dtp-monitor", true));
    @Resource
    private DtpProperties dtpProperties;
    @Resource
    private ApplicationEventMulticaster applicationEventMulticaster;

    public void run(ApplicationArguments args) {
        MONITOR_EXECUTOR.scheduleWithFixedDelay(this::run, 0L, this.dtpProperties.getMonitorInterval(), TimeUnit.SECONDS);
    }

    private void run() {
        List<String> names = DtpRegistry.listAllDtpNames();
        if (CollUtil.isEmpty(names)) {
            return;
        }
        names.forEach(x -> {
            DtpExecutor executor = DtpRegistry.getExecutor(x);
            AlarmManager.triggerAlarm(() -> AlarmManager.doAlarm(executor, ALARM_TYPES));
            ThreadPoolStats poolStats = MetricsConverter.convert(executor);
            this.doCollect(poolStats);
        });
        this.publishEvent();
    }

    private void doCollect(ThreadPoolStats threadPoolStats) {
        if (!this.dtpProperties.isEnabledCollect()) {
            return;
        }
        try {
            CollectorHandler.getInstance().collect(threadPoolStats, this.dtpProperties.getCollectorType());
        }
        catch (Exception e) {
            log.error("DynamicTp monitor, metrics collect error...", (Throwable)e);
        }
    }

    private void publishEvent() {
        CollectEvent event = new CollectEvent((Object)this, this.dtpProperties);
        this.applicationEventMulticaster.multicastEvent((ApplicationEvent)event);
    }
}

