/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.core.notify;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.dtp.common.ApplicationContextHolder;
import com.dtp.common.dto.DtpMainProp;
import com.dtp.common.dto.Instance;
import com.dtp.common.dto.NotifyItem;
import com.dtp.common.dto.NotifyPlatform;
import com.dtp.common.em.NotifyTypeEnum;
import com.dtp.core.DtpRegistry;
import com.dtp.core.context.DtpContext;
import com.dtp.core.context.DtpContextHolder;
import com.dtp.core.notify.Notifier;
import com.dtp.core.notify.NotifyHelper;
import com.dtp.core.thread.DtpExecutor;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public abstract class AbstractNotifier
implements Notifier {
    private static final Logger log = LoggerFactory.getLogger(AbstractNotifier.class);
    private static Instance instance;

    public Instance getInstance() {
        return instance;
    }

    protected AbstractNotifier() {
        AbstractNotifier.init();
    }

    public static void init() {
        Environment environment = ApplicationContextHolder.getEnvironment();
        String appName = environment.getProperty("spring.application.name");
        appName = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appName}) ? appName : "application";
        String portStr = environment.getProperty("server.port");
        int port = StringUtils.isNotBlank((CharSequence)portStr) ? Integer.parseInt(portStr) : 0;
        String address = InetAddress.getLocalHost().getHostAddress();
        String[] profiles = environment.getActiveProfiles();
        if (profiles.length < 1) {
            profiles = environment.getDefaultProfiles();
        }
        instance = new Instance(address, port, appName, profiles[0]);
    }

    public String buildAlarmContent(NotifyPlatform platform, NotifyTypeEnum typeEnum, String template) {
        DtpContext contextWrapper = DtpContextHolder.get();
        String dtpName = contextWrapper.getDtpExecutor().getThreadPoolName();
        DtpExecutor executor = DtpRegistry.getExecutor(dtpName);
        List receivers = StrUtil.split((CharSequence)platform.getReceivers(), (char)',');
        String receivesStr = Joiner.on((String)", @").join((Iterable)receivers);
        NotifyItem notifyItem = contextWrapper.getNotifyItem();
        String content = String.format(template, this.getInstance().getServiceName(), this.getInstance().getIp() + ":" + this.getInstance().getPort(), this.getInstance().getEnv(), executor.getThreadPoolName(), typeEnum.getValue(), notifyItem.getThreshold(), executor.getCorePoolSize(), executor.getMaximumPoolSize(), executor.getPoolSize(), executor.getActiveCount(), executor.getLargestPoolSize(), executor.getTaskCount(), executor.getCompletedTaskCount(), executor.getQueue().size(), executor.getQueueName(), executor.getQueueCapacity(), executor.getQueue().size(), executor.getQueue().remainingCapacity(), executor.getRejectHandlerName(), executor.getRejectCount(), receivesStr, DateUtil.now(), notifyItem.getInterval());
        return this.highlightAlarmContent(content, typeEnum);
    }

    public String buildNoticeContent(NotifyPlatform platform, String template, DtpMainProp oldProp, List<String> diffs) {
        String threadPoolName = oldProp.getDtpName();
        DtpExecutor dtpExecutor = DtpRegistry.getExecutor(threadPoolName);
        List receivers = StrUtil.split((CharSequence)platform.getReceivers(), (char)',');
        String receivesStr = Joiner.on((String)", @").join((Iterable)receivers);
        String content = String.format(template, this.getInstance().getServiceName(), this.getInstance().getIp() + ":" + this.getInstance().getPort(), this.getInstance().getEnv(), threadPoolName, oldProp.getCorePoolSize(), dtpExecutor.getCorePoolSize(), oldProp.getMaxPoolSize(), dtpExecutor.getMaximumPoolSize(), oldProp.isAllowCoreThreadTimeOut(), dtpExecutor.allowsCoreThreadTimeOut(), oldProp.getKeepAliveTime(), dtpExecutor.getKeepAliveTime(TimeUnit.SECONDS), dtpExecutor.getQueueName(), oldProp.getQueueCapacity(), dtpExecutor.getQueueCapacity(), oldProp.getRejectType(), dtpExecutor.getRejectHandlerName(), receivesStr, DateTime.now());
        return this.highlightNotifyContent(content, diffs);
    }

    protected abstract Pair<String, String> getColors();

    private String highlightNotifyContent(String content, List<String> diffs) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return content;
        }
        Pair<String, String> pair = this.getColors();
        for (String string : diffs) {
            content = content.replace(string, (CharSequence)pair.getLeft());
        }
        for (Field field : DtpMainProp.getMainProps()) {
            content = content.replace(field.getName(), (CharSequence)pair.getRight());
        }
        return content;
    }

    private String highlightAlarmContent(String content, NotifyTypeEnum typeEnum) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return content;
        }
        List<Object> colorKeys = Lists.newArrayList();
        if (typeEnum == NotifyTypeEnum.REJECT) {
            colorKeys = NotifyHelper.REJECT_ALARM_KEYS;
        } else if (typeEnum == NotifyTypeEnum.CAPACITY) {
            colorKeys = NotifyHelper.CAPACITY_ALARM_KEYS;
        } else if (typeEnum == NotifyTypeEnum.LIVENESS) {
            colorKeys = NotifyHelper.LIVENESS_ALARM_KEYS;
        }
        colorKeys.addAll(NotifyHelper.COMMON_ALARM_KEYS);
        Pair<String, String> pair = this.getColors();
        for (String string : colorKeys) {
            content = content.replace(string, (CharSequence)pair.getLeft());
        }
        for (String string : NotifyHelper.ALL_ALARM_KEYS) {
            content = content.replace(string, (CharSequence)pair.getRight());
        }
        return content;
    }
}

