/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.core.notify.ding;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.json.JSONUtil;
import com.dtp.common.dto.MarkdownReq;
import com.dtp.common.dto.NotifyPlatform;
import com.dtp.common.util.DingSignUtil;
import com.dtp.core.notify.AbstractNotifier;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDingNotifier
extends AbstractNotifier {
    private static final Logger log = LoggerFactory.getLogger(AbstractDingNotifier.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSend(NotifyPlatform notifyPlatform, String title, String text, List<String> mobiles) {
        MarkdownReq.Markdown markdown = new MarkdownReq.Markdown();
        markdown.setTitle(title);
        markdown.setText(text);
        MarkdownReq.At at = new MarkdownReq.At();
        at.setAtMobiles(mobiles);
        if (CollUtil.isEmpty(mobiles)) {
            at.setAtAll(true);
        }
        MarkdownReq markdownReq = new MarkdownReq();
        markdownReq.setMsgtype("markdown");
        markdownReq.setMarkdown(markdown);
        markdownReq.setAt(at);
        String hookUrl = this.getTargetUrl(notifyPlatform.getSecret(), notifyPlatform.getUrlKey());
        HttpResponse response = null;
        try {
            response = HttpRequest.post((String)hookUrl).body(JSONUtil.toJsonStr((Object)markdownReq)).execute();
        }
        catch (Exception e) {
            log.error("DynamicTp notify, ding send fail...", (Throwable)e);
        }
        finally {
            if (Objects.nonNull(response)) {
                log.info("DynamicTp notify, ding send success, response: {}, request: {}", (Object)response.body(), (Object)JSONUtil.toJsonStr((Object)markdownReq));
            }
        }
    }

    private String getTargetUrl(String secret, String accessToken) {
        if (StringUtils.isBlank((CharSequence)secret)) {
            return "https://oapi.dingtalk.com/robot/send?access_token=" + accessToken;
        }
        long timestamp = System.currentTimeMillis();
        String sign = DingSignUtil.dingSign((String)secret, (long)timestamp);
        return "https://oapi.dingtalk.com/robot/send?access_token=" + accessToken + "&timestamp=" + timestamp + "&sign=" + sign;
    }
}

