/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.core.refresh;

import com.dtp.common.config.DtpProperties;
import com.dtp.common.em.ConfigFileTypeEnum;
import com.dtp.common.event.RefreshEvent;
import com.dtp.core.DtpRegistry;
import com.dtp.core.handler.ConfigHandler;
import com.dtp.core.refresh.Refresher;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.MapConfigurationPropertySource;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.ApplicationEventMulticaster;

public abstract class AbstractRefresher
implements Refresher {
    private static final Logger log = LoggerFactory.getLogger(AbstractRefresher.class);
    @Resource
    private DtpProperties dtpProperties;
    @Resource
    private ApplicationEventMulticaster applicationEventMulticaster;

    @Override
    public void refresh(String content, ConfigFileTypeEnum fileTypeEnum) {
        if (StringUtils.isBlank((CharSequence)content) || Objects.isNull(fileTypeEnum)) {
            return;
        }
        try {
            Map<Object, Object> prop = ConfigHandler.getInstance().parseConfig(content, fileTypeEnum);
            this.doRefresh(prop);
        }
        catch (IOException e) {
            log.error("DynamicTp refresh error, content: {}, fileType: {}", new Object[]{content, fileTypeEnum, e});
        }
    }

    private void doRefresh(Map<Object, Object> properties) {
        MapConfigurationPropertySource sources = new MapConfigurationPropertySource(properties);
        Binder binder = new Binder(new ConfigurationPropertySource[]{sources});
        DtpProperties bindDtpProperties = (DtpProperties)binder.bind("spring.dynamic.tp", Bindable.ofInstance((Object)this.dtpProperties)).get();
        DtpRegistry.refresh(bindDtpProperties);
        this.publishEvent();
    }

    private void publishEvent() {
        RefreshEvent event = new RefreshEvent((Object)this, this.dtpProperties);
        this.applicationEventMulticaster.multicastEvent((ApplicationEvent)event);
    }
}

