/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.core.thread;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.ttl.threadpool.TtlExecutors;
import com.dtp.common.VariableLinkedBlockingQueue;
import com.dtp.common.constant.DynamicTpConst;
import com.dtp.common.dto.NotifyItem;
import com.dtp.common.em.QueueTypeEnum;
import com.dtp.core.reject.RejectHandlerGetter;
import com.dtp.core.thread.DtpExecutor;
import com.dtp.core.thread.NamedThreadFactory;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public class ThreadPoolBuilder {
    private String threadPoolName = "DynamicTp";
    private int corePoolSize = 1;
    private int maximumPoolSize = DynamicTpConst.AVAILABLE_PROCESSORS;
    private long keepAliveTime = 30L;
    private TimeUnit timeUnit = TimeUnit.SECONDS;
    private BlockingQueue<Runnable> workQueue = new VariableLinkedBlockingQueue(1024);
    private RejectedExecutionHandler rejectedExecutionHandler = new ThreadPoolExecutor.AbortPolicy();
    private ThreadFactory threadFactory = new NamedThreadFactory("dynamic-tp");
    private boolean allowCoreThreadTimeOut = false;
    private boolean dynamic = true;
    private List<NotifyItem> notifyItems = NotifyItem.getDefaultNotifyItems();

    private ThreadPoolBuilder() {
    }

    public static ThreadPoolBuilder newBuilder() {
        return new ThreadPoolBuilder();
    }

    public ThreadPoolBuilder threadPoolName(String poolName) {
        this.threadPoolName = poolName;
        return this;
    }

    public ThreadPoolBuilder corePoolSize(int corePoolSize) {
        if (corePoolSize >= 0) {
            this.corePoolSize = corePoolSize;
        }
        return this;
    }

    public ThreadPoolBuilder maximumPoolSize(int maximumPoolSize) {
        if (maximumPoolSize > 0) {
            this.maximumPoolSize = maximumPoolSize;
        }
        return this;
    }

    public ThreadPoolBuilder keepAliveTime(long keepAliveTime) {
        if (keepAliveTime > 0L) {
            this.keepAliveTime = keepAliveTime;
        }
        return this;
    }

    public ThreadPoolBuilder timeUnit(TimeUnit timeUnit) {
        if (timeUnit != null) {
            this.timeUnit = timeUnit;
        }
        return this;
    }

    public ThreadPoolBuilder workQueue(String queueName, Integer capacity, Boolean fair) {
        if (StringUtils.isNotBlank((CharSequence)queueName)) {
            this.workQueue = QueueTypeEnum.buildBlockingQueue((String)queueName, (int)(capacity != null ? capacity : 1024), (fair != null && fair != false ? 1 : 0) != 0);
        }
        return this;
    }

    public ThreadPoolBuilder rejectedExecutionHandler(String rejectedName) {
        if (StringUtils.isNotBlank((CharSequence)rejectedName)) {
            this.rejectedExecutionHandler = RejectHandlerGetter.buildRejectedHandler(rejectedName);
        }
        return this;
    }

    public ThreadPoolBuilder threadFactory(String prefix) {
        if (StringUtils.isNotBlank((CharSequence)prefix)) {
            this.threadFactory = new NamedThreadFactory(prefix);
        }
        return this;
    }

    public ThreadPoolBuilder allowCoreThreadTimeOut(boolean allowCoreThreadTimeOut) {
        this.allowCoreThreadTimeOut = allowCoreThreadTimeOut;
        return this;
    }

    public ThreadPoolBuilder dynamic(boolean dynamic) {
        this.dynamic = dynamic;
        return this;
    }

    public ThreadPoolBuilder notifyItems(List<NotifyItem> notifyItemList) {
        if (CollUtil.isNotEmpty(notifyItemList)) {
            this.notifyItems = notifyItemList;
        }
        return this;
    }

    public ThreadPoolExecutor build() {
        if (this.dynamic) {
            return this.buildDtpExecutor(this);
        }
        return this.buildCommonExecutor(this);
    }

    public DtpExecutor buildDynamic() {
        return this.buildDtpExecutor(this);
    }

    public ThreadPoolExecutor buildCommon() {
        return this.buildCommonExecutor(this);
    }

    public ExecutorService buildWithTtl() {
        return TtlExecutors.getTtlExecutorService((ExecutorService)this.buildCommonExecutor(this));
    }

    private DtpExecutor buildDtpExecutor(ThreadPoolBuilder builder) {
        Assert.notNull((Object)builder.threadPoolName, (String)"The thread pool name must not be null.");
        DtpExecutor dtpExecutor = new DtpExecutor(builder.corePoolSize, builder.maximumPoolSize, builder.keepAliveTime, builder.timeUnit, builder.workQueue, builder.threadFactory, builder.rejectedExecutionHandler);
        dtpExecutor.allowCoreThreadTimeOut(builder.allowCoreThreadTimeOut);
        dtpExecutor.setThreadPoolName(builder.threadPoolName);
        dtpExecutor.setNotifyItems(this.notifyItems);
        return dtpExecutor;
    }

    private ThreadPoolExecutor buildCommonExecutor(ThreadPoolBuilder builder) {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(builder.corePoolSize, builder.maximumPoolSize, builder.keepAliveTime, builder.timeUnit, builder.workQueue, builder.threadFactory, builder.rejectedExecutionHandler);
        executor.allowCoreThreadTimeOut(builder.allowCoreThreadTimeOut);
        return executor;
    }
}

