/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.starter.apollo.refresh;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigChangeListener;
import com.ctrip.framework.apollo.ConfigFile;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.core.enums.ConfigFileFormat;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.dtp.common.config.DtpProperties;
import com.dtp.common.em.ConfigFileTypeEnum;
import com.dtp.core.refresh.AbstractRefresher;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;

public class ApolloRefresher
extends AbstractRefresher
implements ConfigChangeListener,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(ApolloRefresher.class);
    @Value(value="${apollo.bootstrap.namespaces:application}")
    private String namespace;
    private ConfigFileTypeEnum configFileType;
    @Resource
    private DtpProperties dtpProperties;

    public void afterPropertiesSet() {
        String[] apolloNamespaces = this.namespace.split(",");
        String realNamespace = apolloNamespaces[0];
        DtpProperties.Apollo apollo = this.dtpProperties.getApollo();
        if (apollo != null && StringUtils.isNotBlank((CharSequence)apollo.getNamespace())) {
            realNamespace = apollo.getNamespace();
        }
        ConfigFileFormat configFileFormat = this.deduceFileType(realNamespace);
        this.namespace = realNamespace.replaceAll("." + configFileFormat.getValue(), "");
        this.configFileType = ConfigFileTypeEnum.of((String)configFileFormat.getValue());
        Config config = ConfigService.getConfig((String)realNamespace);
        try {
            config.addChangeListener((ConfigChangeListener)this);
            log.info("DynamicTp refresher, add listener success, namespace: {}", (Object)realNamespace);
        }
        catch (Exception e) {
            log.error("DynamicTp refresher, add listener error, namespace: {}", (Object)realNamespace, (Object)e);
        }
    }

    public void onChange(ConfigChangeEvent changeEvent) {
        ConfigFile configFile = ConfigService.getConfigFile((String)this.namespace, (ConfigFileFormat)ConfigFileFormat.fromString((String)this.configFileType.getValue()));
        String content = configFile.getContent();
        this.refresh(content, this.configFileType);
    }

    private ConfigFileFormat deduceFileType(String namespace) {
        ConfigFileFormat configFileFormat = ConfigFileFormat.Properties;
        if (namespace.contains(ConfigFileFormat.YAML.getValue())) {
            configFileFormat = ConfigFileFormat.YAML;
        } else if (namespace.contains(ConfigFileFormat.YML.getValue())) {
            configFileFormat = ConfigFileFormat.YML;
        } else if (namespace.contains(ConfigFileFormat.JSON.getValue())) {
            configFileFormat = ConfigFileFormat.JSON;
        } else if (namespace.contains(ConfigFileFormat.XML.getValue())) {
            configFileFormat = ConfigFileFormat.XML;
        } else if (namespace.contains(ConfigFileFormat.TXT.getValue())) {
            configFileFormat = ConfigFileFormat.TXT;
        }
        return configFileFormat;
    }
}

